var system=require("../../system")
var settings=require("../../../config/settings");
const CtlBase = require("../ctl.base");
const uuidv4 = require('uuid/v4');
class AccountCtl extends CtlBase{
   constructor(){
     super(CtlBase.getServiceName(AccountCtl));
     this.accountSve=system.getObject("service.accountSve");
     //this.appS=system.getObject("service.appSve");
   }

   async initNewInstance(queryobj,qobj){
     var u=uuidv4();
     var aid=u.replace(/\-/g,"");
     var rd={name:"",appid:aid}
     return system.getResult2(rd,null);
   }
   async findById(q,obj,req){
     var aid=req.session.user.account_id;
     var reqParam=obj.param==null?"":obj.param;
     var result= await this.accountSve.getFindById(reqParam,aid);
     return system.getResult2(result,null);
   }

   async petradesSum(){
     var result=await this.accountSve.getpetradesSum();
     return system.getResult2(result,null);
   }

   async subPublicExpense(obj,pobj,req){
     var se= await this.accountSve.subPublicExpense(pobj,req);
     return system.getResult2(se,null);
   }
}
module.exports=AccountCtl;
