const system=require("../system");
class CtlBase{
  constructor(sname){
     this.serviceName=sname;
     this.service=system.getObject("service."+sname);
     this.cacheManager=system.getObject("db.cacheManager");
  }
  notify(req,msg){
    if(req.session){
      req.session.bizmsg=msg;
    }
  }
  async findOne(queryobj,qobj){
    var rd=await this.service.findOne(qobj);
    return system.getResult2(rd,null);
  }
  async findAndCountAll(queryobj,obj,req){
    obj.codepath=req.codepath;

    if(req.session.user){
      obj.uid=req.session.user.id;
      obj.appid=req.session.user.app_id;
      obj.onlyCode=req.session.user.unionId;
      obj.account_id=req.session.user.account_id;
      obj.ukstr=req.session.user.app_id+"￥"+req.session.user.id+"￥"+req.session.user.nickName+"￥"+req.session.user.headUrl;
      obj.mobile=req.session.user.mobile;
    }
    var apps=await this.service.findAndCountAll(obj);
    return system.getResult2(apps,null);
  }
  async refQuery(queryobj,qobj){
    var rd=await this.service.refQuery(qobj);
    return system.getResult2(rd,null);
  }
  async bulkDelete(queryobj,ids){
    var rd=await this.service.bulkDelete(ids);
    return system.getResult2(rd,null);
  }
  async delete(queryobj,qobj){
    var rd=await this.service.delete(qobj);
    return system.getResult2(rd,null);
  }
  async create(queryobj,qobj,req){
    if(req && req.session && req.session.app){
      qobj.app_id=req.session.app.id;
      qobj.onlyCode=req.session.user.unionId;
      if(req.codepath){
        qobj.codepath=req.codepath;
      }
    }
    var rd=await this.service.create(qobj);
    return system.getResult2(rd,null);
  }
  async update(queryobj,qobj,req){
    if(req && req.session && req.session.user){
      qobj.onlyCode=req.session.user.unionId;
    }
    if(req.codepath){
      qobj.codepath=req.codepath;
    }
    var rd=await this.service.update(qobj);
    return system.getResult2(rd,null);
  }
  static getServiceName(ClassObj){

    return ClassObj["name"].substring(0,ClassObj["name"].lastIndexOf("Ctl")).toLowerCase()+"Sve";
  }
  async initNewInstance(queryobj,req){
    return system.getResult2({},null);
  }
  async findById(oid){
    var rd=await this.service.findById(oid);
    return system.getResult2(rd,null);
  }
  async timestampConvertDate(time){
     if(time==null){
       return "";
     }
     var date =  new Date(Number(time*1000));
     var y = 1900+date.getYear();
     var m = "0"+(date.getMonth()+1);
     var d = "0"+date.getDate();
     return y+"-"+m.substring(m.length-2,m.length)+"-"+d.substring(d.length-2,d.length);
  }
  async universalTimeConvertLongDate(time){
     if(time==null){
       return "";
     }
     var d = new Date(time);
     return d.getFullYear() + '-' + (d.getMonth() + 1) + '-' + d.getDate() + ' ' + d.getHours() + ':' + d.getMinutes() + ':' + d.getSeconds();
  }
  async universalTimeConvertShortDate(time){
     if(time==null){
       return "";
     }
     var d = new Date(time);
     return d.getFullYear() + '-' + (d.getMonth() + 1) + '-' + d.getDate();
  }
  // async doExecute(methodname,params){
  //   var result= await this[methodname](params);
  //   return system.getResult2(result,null);
  // }
}
module.exports=CtlBase;
