var System=require("../../system")
const http=require("http")
const querystring = require('querystring');
const md5=require("MD5");
const uuidv4 = require('uuid/v4');
//const cyjAppKey="ccb00829347e4048833af213e502c8c5";
var settings=require("../../../config/settings");
class TradeMarkApi{
    constructor(){
      this.baseUrl=settings.teleDomain();//测试
      //this.baseUrl="http://www.telecredit.cn/";//生产
      this.cacheManager=System.getObject("db.cacheManager");
    };
    async checkParams(obj){
      let key = await this.cacheManager["InitAppKeyCache"].getAppKeyVal(obj.appKey);
      if(key==null){
        return System.getResult2(null,null,"ok","请检查您的授权KEY");
      }
      if(obj.q.replace(/(^s*)|(s*$)/g, "").length ==0)
      {
       return System.getResult2(null,null,"ok","请输入要查询的公司名");
      }
    };
    buildParams(obj){
     var currentT=(new Date()).Format("yyyy-MM-dd hh:mm:ss");
     var params = {
       q:obj.q,
       appKey:"gongsibao",
       currentTime:currentT,
       page:obj.page?obj.page:0,
       pageSize:obj.pagesize?obj.pagesize:5,
     };
     var originStr=params.currentTime+params.appKey+"d10c5fa8d0d41a56fd1390ad214898ed"
      +params.page+""+params.pageSize+params.q;
     var token=md5(originStr);
     params.token=token;
     return params;
   };

   async tmname(obj){//商标名称查询
     var data=await this.checkParams(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/trademark/tmname";
     //data/api/companyInfo/entregistry
     let params = this.buildParams(obj);
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
   async tmid(obj){//商标注册号查询
     var data=await this.checkParams(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/trademark/tmid";
     //data/api/companyInfo/entregistry
     let params = this.buildParams(obj);
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
   async tmapplicant(obj){//商标申请人查询
     var data=await this.checkParams(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/trademark/tmapplicant";
     //data/api/companyInfo/entregistry
     let params = this.buildParams(obj);
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
}
module.exports=TradeMarkApi;
// var capi=new CompanyApi();
// capi.entsearch({appKey:cyjAppKey,companyName:"大圣",currentPage:1,pageSize:10}).then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });
