var System = require("../../system");
const ApiBase = require("../api.base");

/**
 * tmk备注api
 */
class tmkremarkApi extends ApiBase {
    constructor() {
        super();
        this.cacheManager = System.getObject("db.cacheManager");
        this.service = System.getObject("service.tmkremarkSve");
    };

    //新增备注
    async addRemark(obj) {
        var data = await this.checkKey(obj.appKey);
        if (data && data.status && data.status === -1) {
            return data;
        }
        var result = await this.service.insertRemark(obj);
        if (result == null) {
            return {code: -1, msg: "添加备注失败！"}
        }
        return {code: 1, msg: "OK"}
    }

    //删除备注
    async delRemark(obj) {
        //验证appKey
        var data = await this.checkKey(obj.appKey);
        if (data && data.status && data.status === -1) {
            return data;
        }
        var result = await this.service.delRemark(obj);
        if (result == null) {
            return {code: -1, msg: "删除备注失败！"}
        }
        var remark = await this.service.selectRemark(obj);
        if (remark.data.length ===0) {
            return {code: 0, msg: "没有备注记录"}

        }else {
            return {code: 1, msg: "删除备注成功！",data:remark};
        }
        // return {code: 1, msg: "删除备注成功！"}

    }

    //显示所有备注
    async seleRemark(obj) {
        var data = await this.checkKey(obj.appKey);
        if (data && data.status && data.status === -1) {
            return data;
        }
        var select = await this.service.selectRemark(obj);
        if (select.data.length === 0) {
            return {code: 0, msg: "没有备注记录"}

        } else {
            return select;
        }
    }
}

module.exports = tmkremarkApi;