const ApiBase = require("../api.base");
const System = require("../../system");
const request = require('request');
const aliyunClient = require('../../utils/aliyunClient.js');

const OplogSve = require('../../service/impl/oplogSve.js');

let fqReqUrl = "https://yunfuapi.gongsibao.com";//线上域名
// let fqReqUrl = "https://yunfuapi-dev.gongsibao.com";//dev域名

//推送tm等信息到指定接口（每回需要推送200条）
class TmInfoPusherApi {
    constructor() {
        this.trademarkS = System.getObject("service.trademarkSve");
        this.tmapplierinfoDao = System.getObject("db.tmapplierinfoDao");
        this.aliyunClient = new aliyunClient();
        this.oplogSve = new OplogSve();
    };

    async collectInfo() {
        try {

            //获取商标数据
            let resultTm = await this.trademarkS.queryTmInfoForPush();
            console.log('请求推送的数据成功：', resultTm.length);

            let oneItem = {};

            for (let i = 0; i < resultTm.length; i++) {
                let d = resultTm[i];
                let orderNum = d.orderNum;
                let tmRegistNum = d.tmRegistNum;
                let order_no = d.channelOrderListInfo;

                oneItem.tm = d;
                //商标状态
                oneItem.tmStatusName = d.tmStatusName;
                //获取商标申请人信息
                let tmapplierSql = "SELECT * FROM `h_tmapplier_info` WHERE orderNum='" + orderNum + "';";
                let resultApplier = await this.tmapplierinfoDao.customQuery(tmapplierSql);
                oneItem.tmApplier = resultApplier[0];

                //获取联系人信息
                let resultTmCustomer = await this.trademarkS.queryTmCustomerInfoForPush(orderNum);
                oneItem.tmCustomer = resultTmCustomer[0];

                //获取官文信息, 一对多的关系，所以传入list
                let resultTmFlow = await this.trademarkS.queryTmFlowInfoForPush(tmRegistNum);
                oneItem.tmFlow = resultTmFlow;
                console.log('收集商标信息完成--', i);

                //调用推送接口推送oneItem

                let url = fqReqUrl + '/cloudapi/iduty/igirl/pushFollowUp';
                let body = {
                    'order_no': order_no,
                    'json': oneItem
                };

                let res = await this.aliyunClient.postig(url, body);
                console.log('推送完成--' + i, res);
                //将成功结果写入到日志
                await this.oplogSve.create({
                    logLevel: "info",
                    optitle: "推送商标数据至蜂擎---",
                    op: "app/base/api/impl/tmInfoPusherApi/collectInfo",
                    content: "参数:" + JSON.stringify(body) + "返回结果:" + JSON.stringify(res),
                    clientIp: ""
                });

                //更新isPushed字段为1
                await this.trademarkS.updateIsPushed(d.id);
                console.log('更新isPushed字段完成--', i);

            }
            return { code: 200, message: "调用推送接口成功" };
        } catch (e) {
            console.log('collectInfo error: ', e);
            //将错误写入到日志
            await this.oplogSve.create({
                logLevel: "error",
                optitle: "推送商标数据至蜂擎---异常",
                op: "app/base/api/impl/tmInfoPusherApi/collectInfo",
                content: JSON.stringify(e.stack),
                clientIp: ""
            });
            return { code: -1, message: e };
        }
    }
}

module.exports = TmInfoPusherApi;