var System = require("../../system");
var settings = require("../../../config/settings");
const ApiBase = require("../api.base");
const logCtl = System.getObject("web.oplogCtl");

class SubCopyright extends ApiBase {
  constructor() {
    super();
    this.softwarecrsubmitSve = System.getObject("service.softwarecrsubmitSve");
    this.workcrsubmitSve = System.getObject("service.workcrsubmitSve");
  }
  async autosubCr(obj) {//提报软件著作权数据
    var data = await this.checkKey(obj.appKey);
    if (data && data.code && data.code == -1) {
      return { code: -1, message: "appKey错误", data: null };
    }
    try {
      var tmpResult = await this.softwarecrsubmitSve.getAutoSubList();
      return tmpResult;
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "提报软件著作权数据异常",
        op: "base/api/impl/subcopyright/autosubCr",
        content: e.stack,
        clientIp: ""
      });
      return { code: -1, message: "autosubCr异常", data: [] };
    }
  }
  async autosubWorks(obj) {//提报作品著作权数据
    var data = await this.checkKey(obj.appKey);
    if (data && data.code && data.code == -1) {
      return { code: -1, message: "appKey错误", data: null };
    }
    try {
      var tmpResult = await this.workcrsubmitSve.getAutoSubList();
      return tmpResult;
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "提报作品著作权数据异常",
        op: "base/api/impl/subcopyright/autosubWorks",
        content: e.stack,
        clientIp: ""
      });
      return { code: -1, message: "autosubWorks异常", data: [] };
    }
  }
  //修改提报的状态
  /*
    appKey
    opType 操作类型,"1"软件著作权、"2"作品著作权
    proxyCode 代理号,
    statusValue 状态值,
    message 操作信息,
  */
  async putSubStatus(obj) {//修改提报状态    
    var data = await this.checkKey(obj.appKey);
    if (data && data.code && data.code == -1) {
      return { code: -1, message: "appKey错误", data: null };
    }
    try {
      //日志记录
      logCtl.info({
        optitle: "修改提报著作权状态数据==>>>>>>信息",
        op: "base/api/impl/subcopyright/putSubStatus",
        content: JSON.stringify(obj),
        clientIp: ""
      });
      const proxyCode = obj.proxyCode || "";
      const statusValue = obj.statusValue || "";
      const message = obj.message || "";
      const opType = Number(obj.opType || "-1")
      if (!proxyCode) {
        return { code: -1, message: "proxyCode不能为空", data: null };
      }
      if (!statusValue) {
        return { code: -1, message: "statusValue不能为空", data: null };
      }
      var item = null;
      //更改提报状态
      if (opType == 1) {
        item = await this.softwarecrsubmitSve.dao.findOne({ proxyCode: proxyCode });
      }
      else if (opType == 2) {
        item = await this.workcrsubmitSve.dao.findOne({ proxyCode: proxyCode });
      }
      if (!item) {
        return { code: -1, message: "数据为空，操作失败", data: null };
      }
      if (item.statusProgress != "COMMITED") {
        return { code: -1, message: "要更新的数据status不为COMMITED:人工已提交，操作失败", data: null };
      }
      var putField = {
        statusProgress: statusValue,
        subNotes: message
      };
      var sqlWheres = { where: { proxyCode: proxyCode } };
      //更改提报状态
      if (opType == 1) {
        await this.softwarecrsubmitSve.dao.updateByWhere(putField, sqlWheres);
      }
      else if (opType == 2) {
        await this.workcrsubmitSve.dao.updateByWhere(putField, sqlWheres);
      }
      return { code: 1, message: "success", data: null };
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "修改提报著作权状态数据异常",
        op: "base/api/impl/subcopyright/putSubStatus",
        content: e.stack,
        clientIp: ""
      });
      return { code: -1, message: "putSubStatus异常", data: [] };
    }
  }
}
module.exports = SubCopyright;
