var System=require("../../system");
var settings=require("../../../config/settings");
const ApiBase =require("../api.base");
const logCtl=System.getObject("web.oplogCtl");
// const uuidv4 = require('uuid/v4');
class SoftwareApi extends ApiBase{
    constructor(){
      super();
      this.utilscopyrightSve=System.getObject("service.utilscopyrightSve");
    }
    //----------------------------------------------------著作权数据-----------------------
    //某个公司的软件著作权列表=postordersbysaleman
    async getSoftwareListByAuthor(obj){
      var data= await this.checkKey(obj.appKey);
      if(data && data.status==-1){
        return data;
      }
      return this.utilscopyrightSve.softwareListByAuthor(obj,"bossShopApplet");
    }
    //软件著作权详情=post
    async getSoftwareDetailsByAuthor(obj){
      var data= await this.checkKey(obj.appKey);
      if(data && data.status==-1){
        return data;
      }
      return this.utilscopyrightSve.softwareDetailsByAuthor(obj,"bossShopApplet");
    }

    //某个公司的作品著作权列表=post
    async getWorksListByAuthor(obj){
      var data= await this.checkKey(obj.appKey);
      if(data && data.status==-1){
        return data;
      }
      return this.utilscopyrightSve.worksListByAuthor(obj,"bossShopApplet");
    }
    //作品著作权详情=post
    async getWorksDetailsByAuthor(obj){
      var data= await this.checkKey(obj.appKey);
      if(data && data.status==-1){
        return data;
      }
      return this.utilscopyrightSve.worksDetailsByAuthor(obj,"bossShopApplet");
    }

}
module.exports=SoftwareApi;
