var System=require("../../system")
const http=require("http")
const querystring = require('querystring');
const md5=require("MD5");
const uuidv4 = require('uuid/v4');
const crypto = require('crypto');
const cryptoJS = require("crypto-js");
//const cyjAppKey="ccb00829347e4048833af213e502c8c5";
var settings=require("../../../config/settings");
const logCtl=System.getObject("web.oplogCtl");
class OpTradeMarkApi{
    constructor(){
      this.cacheManager=System.getObject("db.cacheManager");
      this.channeltmSve=System.getObject("service.channeltmSve");
    };
    async checkSign(obj){
      try {
        if(obj.data==null||obj.data==""||obj.mess==null||obj.mess==""||obj.timestamp==null||obj.timestamp==""
          ||obj.app_code==null||obj.app_code==""||obj.sign==null||obj.sign==""||obj.sign_type==null||obj.sign_type==""){
            return {code:"1001",message:"参数有误"};
          }
        let applistCache = await this.cacheManager["ApplistCache"].getListByCache();
        if(applistCache==null||applistCache==""||applistCache=="undefined"){
          return {code:"1002",message:"缓存数据有误"};
        }
        let appList=JSON.parse(applistCache);
        if(appList==null||appList.length==0){
          return {code:"1003",message:"缓存数据查询有误"};
        }
        var newList = appList.filter(item=>item.app_code==obj.app_code);
        if(newList==null||newList.length==0){
          return {code:"1004",message:"app_code数据有误"};
        }
        if(newList[0].secret==""||newList[0].secret==null||newList[0].appid==""||newList[0].appid==null){
          return {code:"1005",message:"应用未设置3deskey或没有设置appkey"};
        }
        let tAppKey=newList[0].secret;
        var tSign_type="sha256";//obj.sign_type;

        let signContent="data="+obj.data+"&mess="+obj.mess+"&timestamp="+obj.timestamp+"&key="+tAppKey;
        var signStr=crypto.createHmac(tSign_type,tAppKey).update(signContent).digest('hex');
        if(obj.sign!=signStr){
          return {code:"1006",message:"签名错误，请重试"};
        }
        return {code:"0000",message:"success",keyHex:newList[0].appid,appKey:tAppKey,sign_type:tSign_type,appname:newList[0].name,
                platformProfitRatio:newList[0].platformProfitRatio==null?0:parseFloat(newList[0].platformProfitRatio)};


      } catch (e) {
        //日志记录
        logCtl.error({
					 optitle:"验签异常,app_code="+obj.app_code,
					 op:"api/optrademark/checkSign",
					 content:e.stack,
					 clientIp:obj.clientIp
				 });
        // console.log("checkSign--->签名异常，请重试，error:"+e.message);
        return {code:"1100",message:"签名异常，请重试，error:"+e.message};

      }
    }
    //提报商标
    async sub_tm(obj){
      var result={
        code:"",
        message:"",
        app_code:obj.app_code,
        data:[]
      };
      var appName="";
      var appId="";
      try {
            let checkSignResult=await this.checkSign(obj);
            if(checkSignResult.code!="0000"){
              result.code=checkSignResult.code;
              result.message="签名错误，请重试";
              return result;
            }
            appName=checkSignResult.appname;
            appId=checkSignResult.keyHex;
            //新增请求参数
            obj.appName=checkSignResult.appname;
            obj.tKeyHex=checkSignResult.keyHex;
            obj.tPlatformProfitRatio=checkSignResult.platformProfitRatio;
            obj.addTmStatus="WAITARTIFICIALEXAMINE";
            obj.addTmStatusName="等待人工审核";
            var tResult=await this.channeltmSve.addChannelTm(obj);
            result.code=tResult.code;
            result.message=tResult.message;
            var tData={channel_order_num:tResult.channel_order_num,order_num:tResult.order_num,proxy_code:tResult.proxy_code,
                       tm_status:tResult.tm_status,tm_status_name:tResult.tm_status_name};
            result.data.push(tData);
            //是否有回调Url
            if(tResult.notify_url!=null&&tResult.notify_url!=""&&tResult.notify_url.indexOf("http")>=0){
              this.channeltmSve.callbackNotify(result,tResult.notify_url,appId,appName,obj.clientIp);
            }
            return result;
        } catch (e) {
          //日志记录
          logCtl.error({
             optitle:"商标添加操作异常,obj.app_code="+obj.app_code,
             op:"api/optrademark/sub_tm",
             content:e.stack,
             clientIp:obj.clientIp
           });
          result.code="2000";
          result.message="网络异常，请重试";
        }
        return result;
    }
    //提报商标等待审核
    async sub_tm_wait(obj){
      var result={
        code:"",
        message:"",
        app_code:obj.app_code,
        data:[]
      };
      var appName="";
      var appId="";
      try {
            let checkSignResult=await this.checkSign(obj);
            if(checkSignResult.code!="0000"){
              result.code=checkSignResult.code;
              result.message="签名错误，请重试";
              return result;
            }
            appName=checkSignResult.appname;
            appId=checkSignResult.keyHex;
            //新增请求参数
            obj.appName=checkSignResult.appname;
            obj.tKeyHex=checkSignResult.keyHex;
            obj.tPlatformProfitRatio=checkSignResult.platformProfitRatio;
            obj.addTmStatus="AWAITCHECK";
            obj.addTmStatusName="等待审核";
            var tResult=await this.channeltmSve.addChannelTm(obj);
            result.code=tResult.code;
            result.message=tResult.message;
            var tData={channel_order_num:tResult.channel_order_num,order_num:tResult.order_num,proxy_code:tResult.proxy_code,
                       tm_status:tResult.tm_status,tm_status_name:tResult.tm_status_name};
            result.data.push(tData);
            //是否有回调Url
            if(tResult.notify_url!=null&&tResult.notify_url!=""&&tResult.notify_url.indexOf("http")>=0){
              this.channeltmSve.callbackNotify(result,tResult.notify_url,appId,appName,obj.clientIp);
            }
            return result;
        } catch (e) {
          //日志记录
          logCtl.error({
             optitle:"商标添加并等待审核操作异常,obj.app_code="+obj.app_code,
             op:"api/optrademark/sub_tm_wait",
             content:e.stack,
             clientIp:obj.clientIp
           });
          result.code="2000";
          result.message="网络异常，请重试";
        }
        return result;
    }
    //获取商标状态
    async get_tm_status(obj){
        var result={
          code:"",
          message:"",
          app_code:obj.app_code,
          data:[]
        };
        var appName="";
        var appId="";
        try {
          let checkSignResult=await this.checkSign(obj);
          if(checkSignResult.code!="0000"){
            result.code=checkSignResult.code;
            result.message="签名错误，请重试";
            return result;
          }
          appName=checkSignResult.appname;
          appId=checkSignResult.keyHex;
          //新增请求参数
          obj.appName=checkSignResult.appname;
          obj.tKeyHex=checkSignResult.keyHex;
          var tResult=await this.channeltmSve.getChannelTmStatus(obj);
          result.code=tResult.code;
          result.message=tResult.message;
          var tData={proxy_code:tResult.proxy_code,tm_status:tResult.tm_status,tm_status_name:tResult.tm_status_name,op_remark_info:tResult.op_remark_info};
          result.data.push(tData);
          return result;
        } catch (e) {
          //日志记录
          logCtl.error({
             optitle:"商标状态获取操作异常,obj.app_code="+obj.app_code,
             op:"api/optrademark/get_tm_status",
             content:e.stack,
             clientIp:obj.clientIp
           });
          result.code="2000";
          result.message="网络异常，请重试";
        }
        return result;
      }
    //修改商标数据
    async put_tm_data(obj){
      var result={
        code:"",
        message:"",
        app_code:obj.app_code,
        data:[]
      };
      var appName="";
      var appId="";
      try {
        let checkSignResult=await this.checkSign(obj);
        if(checkSignResult.code!="0000"){
          result.code=checkSignResult.code;
          result.message="签名错误，请重试";
          return result;
        }
        appName=checkSignResult.appname;
        appId=checkSignResult.keyHex;
        //新增请求参数
        obj.appName=checkSignResult.appname;
        obj.tKeyHex=checkSignResult.keyHex;
        obj.tPlatformProfitRatio=checkSignResult.platformProfitRatio;
        obj.putTmStatus="WAITARTIFICIALEXAMINE";
        obj.putTmStatusName="等待人工审核";
        var tResult=await this.channeltmSve.putChannelTm(obj);
        result.code=tResult.code;
        result.message=tResult.message;
        var tData={channel_order_num:tResult.channel_order_num,order_num:tResult.order_num,proxy_code:tResult.proxy_code,
                   tm_status:tResult.tm_status,tm_status_name:tResult.tm_status_name};
        result.data.push(tData);
        //是否有回调Url
        if(tResult.notify_url!=null&&tResult.notify_url!=""&&tResult.notify_url.indexOf("http")>=0){
          this.channeltmSve.callbackNotify(result,tResult.notify_url,appId,appName,obj.clientIp);
        }
        return result;
      } catch (e) {
        //日志记录
        logCtl.error({
           optitle:"商标状态更新操作异常,obj.app_code="+obj.app_code,
           op:"api/optrademark/put_tm_data",
           content:e.stack,
           clientIp:obj.clientIp
         });
        result.code="2000";
        result.message="网络异常，请重试";
      }
      return result;
    }
    //修改商标数据等待审核
    async put_tm_data_wait(obj){
      var result={
        code:"",
        message:"",
        app_code:obj.app_code,
        data:[]
      };
      var appName="";
      var appId="";
      try {
        let checkSignResult=await this.checkSign(obj);
        if(checkSignResult.code!="0000"){
          result.code=checkSignResult.code;
          result.message="签名错误，请重试";
          return result;
        }
        appName=checkSignResult.appname;
        appId=checkSignResult.keyHex;
        //新增请求参数
        obj.appName=checkSignResult.appname;
        obj.tKeyHex=checkSignResult.keyHex;
        obj.tPlatformProfitRatio=checkSignResult.platformProfitRatio;
        obj.putTmStatus="AWAITCHECK";
        obj.putTmStatusName="等待审核";
        var tResult=await this.channeltmSve.putChannelTm(obj);
        result.code=tResult.code;
        result.message=tResult.message;
        var tData={channel_order_num:tResult.channel_order_num,order_num:tResult.order_num,proxy_code:tResult.proxy_code,
                   tm_status:tResult.tm_status,tm_status_name:tResult.tm_status_name};
        result.data.push(tData);
        //是否有回调Url
        if(tResult.notify_url!=null&&tResult.notify_url!=""&&tResult.notify_url.indexOf("http")>=0){
          this.channeltmSve.callbackNotify(result,tResult.notify_url,appId,appName,obj.clientIp);
        }
        return result;
      } catch (e) {
        //日志记录
        logCtl.error({
           optitle:"商标状态更新并等待审核操作异常,obj.app_code="+obj.app_code,
           op:"api/optrademark/put_tm_data_wait",
           content:e.stack,
           clientIp:obj.clientIp
         });
        result.code="2000";
        result.message="网络异常，请重试";
      }
      return result;
    }

    //简单的接口处理,通过appkey处理
    async add_tm(obj){

    }
    async get_tmstatus(obj){

    }
    async put_tm(obj){

    }
}
module.exports=OpTradeMarkApi;
// var capi=new CompanyApi();
// capi.entsearch({appKey:cyjAppKey,companyName:"大圣",currentPage:1,pageSize:10}).then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });
