var System=require("../../system");
var settings=require("../../../config/settings");
const ApiBase =require("../api.base");
const logCtl=System.getObject("web.oplogCtl");
class NeedApi extends ApiBase{
    constructor(){
      super();
      this.channelSve=System.getObject("service.channelSve");
      this.businesschanceSve=System.getObject("service.businesschanceSve");
      this.servicesitemSve=System.getObject("service.servicesitemSve");
    }
    //畅捷通需求接入
    async submitneed(obj){
      console.log(obj);
      var data= await this.checkKey(obj.appKey);
      if(data && data.status==-1){
        return data;
      }
      if(obj.serviceItem_code==""||obj.serviceItem_code==null||obj.serviceItem_code=="undefined"){
        return {code:-100,msg:"商机类型不能为空"};
      }
      if(obj.publisherCompany==""||obj.publisherCompany==null||obj.publisherCompany=="undefined"){
        return {code:-100,msg:"企业名称不能为空"};
      }
      if(obj.publisherName==""||obj.publisherName==null||obj.publisherName=="undefined"){
        return {code:-100,msg:"企业联系人不能为空"};
      }
      if(obj.publisherMobile==""||obj.publisherMobile==null||obj.publisherMobile=="undefined"){
        return {code:-100,msg:"联系电话不能为空"};
      }
      if(obj.notes!=""&&obj.notes!=null&&obj.notes!="undefined"&&obj.notes.length>255){
        return {code:-100,msg:"沟通内容字数不能超过255"};
      }
      if(obj.serviceItem_code==""||obj.serviceItem_code==null||obj.serviceItem_code=="undefined"){
        return {code:-110,msg:"serviceItem_code参数传递错误"};
      }
      var tChannelCode=obj.channelCode==""||obj.channelCode==null||obj.channelCode=="undefined"?"":obj.channelCode;
      if(tChannelCode==""){
        return {code:-111,msg:"channelCode参数传递错误"};
      }
      var channelItem=await this.channelSve.getChannelItem(tChannelCode);
      if(channelItem==""||channelItem==null){
        return {code:-111,msg:"channelCode参数传递错误"};
      }
      var serviceItem=await this.servicesitemSve.findOneByCode(obj.serviceItem_code);
      if(serviceItem==""||serviceItem==null){
        return {code:-110,msg:"serviceItem_code参数传递错误"};
      }
      var pobj={
        name:obj.publisherCompany,
        publisherName:obj.publisherName,
        publisherMobile:obj.publisherMobile,
        serviceItem_code:obj.serviceItem_code,
        channelCode:tChannelCode,
        chanceStatus:"1"
      };
      var result=await this.businesschanceSve.findchance(pobj);
      if(result!=""&&result!=null){
        return {code:"0",msg:"需求重复发布"};
      }
      try{
        var reqParams={
          notes:obj.notes,
          name:obj.publisherCompany,
          publisherName:obj.publisherName,
          publisherMobile:obj.publisherMobile,
          channelCode:tChannelCode,
          serviceItem_code:obj.serviceItem_code,
          serviceItem_name:serviceItem.name,
          chanceStatus:"1",
          chanceType:serviceItem.itemType,
          channelProfitRatio:channelItem.profitType==1?(channelItem.everySingleProfit||0):0,//渠道分成比率（如：总额100，字段值30，则渠道的利润为30/100，剩下的则为平台利润）
          channelProfit:channelItem.profitType==2?(channelItem.everySingleProfit||0):0,//渠道利润
          profitType:channelItem.profitType//渠道利润类型:1: "比例分成", 2: "每单分成"
        };
        var chance = await this.businesschanceSve.create(reqParams);
        this.smsClient=System.getObject("util.smsClient");
        this.smsClient.sendMsg("13381139519","亲爱的知产合伙人，你的客户于"+(new Date()).Format("yyyy-MM-dd")+"发布了新的需求，亲，赶紧去自己店铺去查看“我的商机”吧！");
        return {code:"1",msg:"需求发布成功"};
      }catch(e){
        console.log(e);
        //日志记录
        logCtl.error({
           optitle:"渠道cjtneed提交需求异常",
           op:"/api/opneed/submitneed",
           content:"请求参数："+JSON.stringify(obj)+"，error："+e.stack,
           clientIp:""
         });
        return {code:"-1",msg:"操作失败，请稍后重试"};
      }


    }
    //发布工商需求接口
    async add_icbc_need(obj){
      try {

      } catch (e) {

      } finally {

      }
      var result={
            code: "0000",
            message: "success",
            app_code: "31008699",
            data: []
        };
      var data= await this.checkKey(obj.appKey);
      if(data && data.status==-1){
        return data;
      }
      var param={
        tm_name:obj.tmName,
        reg_num:obj.regNum,
        applicant_cn:obj.applicantCn,
        page_size:obj.pageSize,
        current_page:obj.currentPage
      }
      return this.utilstmSve.tmSearch(param,"FqTmSearchApi");
    }
}
module.exports=NeedApi;
