var System=require("../../system");
var settings=require("../../../config/settings");
const ApiBase =require("../api.base");
const logCtl=System.getObject("web.oplogCtl");
class OpIcbcApi extends ApiBase{
    constructor(){
      super();
      this.icbcinfoSve=System.getObject("service.icbcinfoSve");
      this.cacheManager=System.getObject("db.cacheManager");
    }
    //添加国内工商数据
    async add_icbc(obj){
      var result={
            code: "0000",
            message: "success",
            app_code:"",
            data: null
        };
      try {
          let appCache = await this.cacheManager["AppCache"].cacheApp(obj.appKey);
          if(appCache==null||appCache=="undefined"){
            result.code="1001";
            result.message="appKey错误，请重试";
            return result;
          }
          if(appCache.app_code!=obj.app_code){
            result.code="1001";
            result.message="appKey错误，请重试!!";
            return result;
          }
          obj.icbcType="gn";
          return this.icbcinfoSve.addChannelIcbc(obj,appCache.name);
      } catch (e) {
        console.log("error........................");
        console.log(e.stack);
        //日志记录
        logCtl.error({
           optitle:"渠道添加国内工商数据异常",
           op:"base/api/impl/opicbc/add_icbc",
           content:"参数："+JSON.stringify(obj)+"，error："+e.stack,
           clientIp:obj.clientIp
         });
         result.code="2000";
         result.message="网络异常，请重试";
         return result;
      }
    }
    //添加香港工商数据
    async add_hongkong_icbc(obj){
      var result={
            code: "0000",
            message: "success",
            app_code:"",
            data: null
        };
      try {
          var data= await this.checkKey(obj.appKey);
          if(data && data.status==-1){
            result.code="1001";
            result.message="appKey错误，请重试";
            return result;
          }
          obj.icbcType="hongkong";
          return this.icbcinfoSve.addChannelIcbc(obj);
      } catch (e) {
        //日志记录
        logCtl.error({
           optitle:"渠道添加香港工商数据异常",
           op:"base/api/impl/opicbc/add_hongkong_icbc",
           content:"参数："+JSON.stringify(obj)+"，error："+e.stack,
           clientIp:obj.clientIp
         });
         result.code="2000";
         result.message="网络异常，请重试";
         return result;
      }
    }
    //添加国内江苏省宿迁市工商数据
    async add_gnsqs_icbc(obj){
      var result={
            code: "0000",
            message: "success",
            app_code:"",
            data: null
        };
      try {
          var data= await this.checkKey(obj.appKey);
          if(data && data.status==-1){
            result.code="1001";
            result.message="appKey错误，请重试";
            return result;
          }
          obj.icbcType="gnjssqs";
          return this.icbcinfoSve.addChannelIcbc(obj);
      } catch (e) {
        //日志记录
        logCtl.error({
           optitle:"渠道添加国内江苏省宿迁市工商数据异常",
           op:"base/api/impl/opicbc/add_gnsqs_icbc",
           content:"参数："+JSON.stringify(obj)+"，error："+e.stack,
           clientIp:obj.clientIp
         });
         result.code="2000";
         result.message="网络异常，请重试";
         return result;
      }
    }
    //修改工商数据
    async put_icbc(obj){
      var result={
            code: "0000",
            message: "success",
            app_code:"",
            data: null
        };
      try {
          var data= await this.checkKey(obj.appKey);
          if(data && data.status==-1){
            result.code="1001";
            result.message="appKey错误，请重试";
            return result;
          }
          return this.icbcinfoSve.putChannelIcbc(obj);
      } catch (e) {
        //日志记录
        logCtl.error({
           optitle:"渠道修改工商数据异常",
           op:"base/api/impl/opicbc/put_icbc",
           content:"参数："+JSON.stringify(obj)+"，error："+e.stack,
           clientIp:obj.clientIp
         });
         result.code="2000";
         result.message="网络异常，请重试";
         return result;
      }
    }
    //获取工商状态
    async get_icbcstatus(obj){
      var result={
            code: "0000",
            message: "success",
            app_code:"",
            data: null
        };
      try {
          var data= await this.checkKey(obj.appKey);
          if(data && data.status==-1){
            result.code="1001";
            result.message="appKey错误，请重试";
            return result;
          }
          return this.icbcinfoSve.getChannelIcbcStatus(obj);
      } catch (e) {
        //日志记录
        logCtl.error({
           optitle:"渠道获取工商状态异常",
           op:"base/api/impl/opicbc/get_icbcstatus",
           content:"参数："+JSON.stringify(obj)+"，error："+e.stack,
           clientIp:obj.clientIp
         });
         result.code="2000";
         result.message="网络异常，请重试";
         return result;
      }
    }
}
module.exports=OpIcbcApi;
