var System=require("../../system");
var settings=require("../../../config/settings");
const logCtl=System.getObject("web.oplogCtl");
const ApiBase =require("../api.base");

class LbsSearch extends ApiBase{
    constructor(){
        super();
        this.AdressUrl="http://43.247.184.92:8880/lbs/api/addresssearch";
        this.LalUrl="http://43.247.184.92:8889/lbs/api/lalsearch";
        this.CityUrl="http://43.247.184.92:8886/lbs/api/citysearch";
        this.appkey="d41d8cd98f00b204e9800998ecf8427e";
    }

    async addressSearch(obj){

        var data=await this.checkKey(obj.appKey);
        if(data && data.status && data.status==-1){
            return data;
        }

        var address=obj.address==null?"":obj.address;

        if(address==""){
            return System.getResult2(null,null);
        }
        var distance=obj.distance==null?"":obj.distance;
        if(distance==""){
            return System.getResult2(null,null);
        }
        address=await this.getConvertSemiangleStr(address);//全半角转化
        var params = {
            "appkey":this.appkey,
            "address":address,
            "distance":distance,
            "pagesize":obj.pageSize,
            "currentPage":obj.currentPage
        }

        var reqUrl=this.AdressUrl;
        var rtn=null;
        var rc=System.getObject("util.execClient");
        try{

            rtn=await rc.execPost(params,reqUrl);
            var tmpResult=JSON.parse(rtn.stdout);
            if(tmpResult.status!=0){
                return System.getResult2(null,null,"other method fail");
            }else{

                return tmpResult}
        }catch(e){
            //日志记录
            logCtl.error({
               optitle:"api->lbssearch->addressSearch方法请求出错，error：",
               op:"api/lbssearch/addressSearch",
               content:e.stack,
               clientIp:""
             });
            return System.getResult2(null,null,"zntjSearch error;");
        }
    }

    async lalSearch(obj){
        var data=await this.checkKey(obj.appKey);
        if(data && data.status && data.status==-1){
            return data;
        }
        var lat=obj.lat==null?"":obj.lat;
        if(lat==""){
            return System.getResult2(null,null);
        }
        var lng=obj.lng==null?"":obj.lng;
        if(lng==""){
            return System.getResult2(null,null);
        }

        var distance=obj.distance==null?"":obj.distance;
        if(distance==""){
            return System.getResult2(null,null);
        }
        var params = {
            "appkey":this.appkey,
            "lat":lat,
            "lng":lng,
            "distance":distance,
            "pagesize":obj.pageSize,
            "currentPage":obj.currentPage
        }
        var reqUrl=this.LalUrl;
        var rtn=null;
        var rc=System.getObject("util.execClient");
        try{
            rtn=await rc.execPost(params,reqUrl);
            var tmpResult=JSON.parse(rtn.stdout);
            if(tmpResult.status!=0){
                return System.getResult2(null,null,"other method fail");
            }else{
                return tmpResult
              }
        }catch(e){
            //日志记录
            logCtl.error({
               optitle:"api->lbssearch->lalSearch方法请求出错，error：",
               op:"api/lbssearch/lalSearch",
               content:e.stack,
               clientIp:""
             });
            return System.getResult2(null,null,"zntjSearch error;");
        }
    }
    async citySearch(obj){

        var data=await this.checkKey(obj.appKey);
        if(data && data.status && data.status==-1){
            return data;
        }
        var cityName=obj.cityName==null?"":obj.cityName;
        if(cityName==""){
            return System.getResult2(null,null);
        }
        cityName=await this.getConvertSemiangleStr(cityName);//全半角转化

        var params = {
            "appkey":this.appkey,
            "cityName":cityName,
            "pagesize":obj.pageSize,
            "currentPage":obj.currentPage
        }

        var reqUrl=this.CityUrl;
        var rtn=null;
        var rc=System.getObject("util.execClient");
        try{

            rtn=await rc.execPost(params,reqUrl);
            var tmpResult=JSON.parse(rtn.stdout);
            if(tmpResult.status!=0){
                return System.getResult2(null,null,"other method fail");
            }else{

                return tmpResult}
        }catch(e){
            //日志记录
            logCtl.error({
               optitle:"api->lbssearch->citySearch方法请求出错，error：",
               op:"api/lbssearch/citySearch",
               content:e.stack,
               clientIp:""
             });
            return System.getResult2(null,null,"zntjSearch error;");
        }
    }
    async getConvertSemiangleStr(str){
        var result = "";
        var len = str.length;
        for(var i=0;i<len;i++)
        {
            var cCode = str.charCodeAt(i);
            //全角与半角相差（除空格外）：65248（十进制）
            cCode = (cCode>=0xFF01 && cCode<=0xFF5E)?(cCode - 65248) : cCode;
            //处理空格
            cCode = (cCode==0x03000)?0x0020:cCode;
            result += String.fromCharCode(cCode);
        }
        return result;
    }
}
module.exports=LbsSearch;
