var System=require("../../system");
var settings=require("../../../config/settings");
const ApiBase =require("../api.base");
//const cyjAppKey="ccb00829347e4048833af213e502c8c5";
class GsbPatentSearchApi extends ApiBase{
  constructor(){
    super();
    this.patentUrl = settings.apiconfig.paSearchUrl();
  };
  buildDate(date){
    var date = new Date(date);
    var time = Date.parse(date);
    time=time / 1000;
    return time;
  };
  async seniorSearch(obj){//高级检索，根据用户输入的不同多条件进行检索
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }
    var requrl = this.patentUrl;
    var pagesize = obj.pagesize==null?15:obj.pagesize;
    if(obj.page==null){
      var from = 0;
    }else{
      var from = Number((obj.page-1)*obj.pagesize);
    }

    var params = {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "pub_type",
        "filing_date",
        "pub_date",
        "pub_no",
        "gr_date",
        "gr_no",
        "applicant_name",
        "inventor_name",
        "agent_name1",
        "agent_name2",
        "agency_code",
        "agency_name",
        "country_code",
        "appl_zip",
        "appl_address",
        "filing_name",
        "pub_status",
        "pub_status_now",
        "abstr_text",
        "main_ipc",
        "ipc_version",
        "other_ipc",
        "prior_info",
        "pct_info"
      ]
    };

    //对有效，无效，审中做判断
    var param = {
      "bool": {
        "should": []
      }
    }
    var yxstatus=obj.yxstatus==null?"":obj.yxstatus;
    if  (yxstatus != null && yxstatus != ""){
      var parr = {
        "term": {
           "pub_status": yxstatus
         }
       }
      param.bool.should.push(parr)
    }
    var wxstatus=obj.wxstatus==null?"":obj.wxstatus;
    if  (wxstatus != null && wxstatus != ""){
      var parr = {
        "term": {
          "pub_status": wxstatus
        }
      }
      param.bool.should.push(parr)
    }
    var szstatus=obj.szstatus==null?"":obj.szstatus;
    if  (szstatus != null && szstatus != ""){
      var parr = {
        "term": {
          "pub_status": szstatus
        }
      }
      param.bool.should.push(parr)
    }
    params.query.bool.must.push(param)

    //对发明公开，发明授权，实用新型，外观设计做判断
    param = {
      "bool": {
        "should": []
      }
    }
    var xxtype=obj.xxtype==null?"":obj.xxtype;
    if (xxtype != null && xxtype != ""){
      var parr = {
        "term": {
           "pub_type": xxtype
         }
       }
      param.bool.should.push(parr)
    }
    var wgtype=obj.wgtype==null?"":obj.wgtype;
    if (wgtype != null && wgtype != ""){
      var parr = {
        "term": {
           "pub_type": wgtype
         }
       }
      param.bool.should.push(parr)
    }
    //以下对发明公开和发明授权处理，需要从gr_no区分
    var fmtype=obj.fmtype==null?"":obj.fmtype;
    var grtype=obj.grtype==null?"":obj.grtype;
    if (fmtype != "" && fmtype != null && grtype != "" && grtype != null){
      var parr = {
        "term": {
           "pub_type": "发明"
         }
       }
      param.bool.should.push(parr)
    }
    else{

      if (fmtype != "" && fmtype != null){
        var parr = {
          "term": {
            "pub_type": "发明"
          }
        }
        param.bool.should.push(parr)
        var patr = {
          "bool":{
            "must_not":{
              "exists" : {
                "field" : "gr_no"
               }
             }
           }
         }
        params.query.bool.must.push(patr)
      }
      if (grtype != "" && grtype != null){
        var parr = {
          "term": {
             "pub_type": "发明"
           }
         }
        param.bool.should.push(parr)
        var patr = {
          "exists" : {
             "field" : "gr_no"
            }
          }
        params.query.bool.must.push(patr)
      }
    }
    params.query.bool.must.push(param)


    var filingno=obj.filingno==null?"":obj.filingno;
    if(filingno!=null && filingno!=""){
      var param=  {
        "term": {
          "filing_no": filingno
        }
      }
      params.query.bool.must.push(param)
    }
    var filingname=obj.filingname==null?"":obj.filingname;
    if (filingname!=null && filingname!=""){
      var param=  {
        "match": {
          "filing_name": filingname
        }
      }
      params.query.bool.must.push(param)
    }
    var pubno=obj.pubno==null?"":obj.pubno;
    if (pubno!=null && pubno!=""){
      var param=  {
        "wildcard": {
          "pub_no": "*"+pubno+"*"
        }
      }
      params.query.bool.must.push(param)
    }
    var grno=obj.grno==null?"":obj.grno;
    if (grno!=null && grno!=""){
      var param=  {
        "wildcard": {
          "gr_no": "*"+grno+"*"
        }
      }
      params.query.bool.must.push(param)
    }
    var abstr=obj.abstract==null?"":obj.abstract;
    if (abstr!=null && abstr!=""){
      var param=  {
        "match": {
          "abstr_text": abstr
        }
      }
      params.query.bool.must.push(param)
    }
    var appl=obj.applname==null?"":obj.applname;
    if (appl!=null && appl!=""){
      var param=  {
        "match": {
          "applicant_name": appl
        }
      }
      params.query.bool.must.push(param)
    }
    var inv=obj.invname==null?"":obj.invname;
    if (inv!=null && inv!=""){
      var param=  {
        "match": {
          "inventor_name": inv
        }
      }
      params.query.bool.must.push(param)
    }
    var ipc=obj.ipcno==null?"":obj.ipcno;
    if (ipc!=null && ipc!=""){
      var param=  {
        "term": {
          "other_ipc": ipc
        }
      }
      params.query.bool.must.push(param)
    }
    if(obj.filingdate1!=null && obj.filingdate1!=""){
      var filingdate1=this.buildDate(obj.filingdate1);
    }
    else {
      var filingdate1 ="";
    }
    if(obj.filingdate2!=null && obj.filingdate2!=""){
      var filingdate2=this.buildDate(obj.filingdate2);
    }
    else {
      var filingdate2 = "";
    }
    if (filingdate1!="" || filingdate2!=""){
      var param={
        "range": {
          "filing_date": {
          }
        }
      };
      if (filingdate1!=""){
        param.range.filing_date["gte"]=filingdate1;
      }
      if (filingdate2!=""){
        param.range.filing_date["lte"]=filingdate2;
      }
      params.query.bool.must.push(param);
    }
    if(obj.pubdate1!=null && obj.pubdate1!=""){
      var pubdate1=this.buildDate(obj.pubdate1);
    }
    else {
      var pubdate1 ="";
    }
    if(obj.pubdate2!=null && obj.pubdate2!=""){
      var pubdate2=this.buildDate(obj.pubdate2);
    }
    else {
      var pubdate2 = "";
    }
    if (pubdate1!="" || pubdate2!=""){
      var param={
        "range": {
          "pub_date": {

          }
        }
      };
      if (pubdate1!=""){
        param.range.pub_date["gte"]=pubdate1;
      }
      if (pubdate2!=""){
        param.range.pub_date["lte"]=pubdate2;
      }
      params.query.bool.must.push(param);
    }
    if(obj.grdate1!=null && obj.grdate1!=""){
      var grdate1=this.buildDate(obj.grdate1);
    }
    else {
      var grdate1 ="";
    }
    if(obj.grdate2!=null && obj.grdate2!=""){
      var grdate2=this.buildDate(obj.grdate2);
    }
    else {
      var grdate2 = "";
    }
    if (grdate1!="" || grdate2!=""){
      var param={
        "range": {
          "gr_date": {

          }
        }
      };
      if (grdate1!=""){
        param.range.gr_date["gte"]=grdate1;
      }
      if (grdate2!=""){
        param.range.gr_date["lte"]=grdate2;
      }
      params.query.bool.must.push(param);
    }
    var priorno=obj.priorno==null?"":obj.priorno;
    if (priorno!=null && priorno!=""){
      var param= {
        "nested": {
          "path": "prior_info",
          "query": {
            "bool": {
              "must": [
                { "term": { "prior_info.pri_no": priorno}}
              ]
            }
          }
        }
      };
      params.query.bool.must.push(param)
    }
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResult2(j.hits,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };
  async intellectSearch(obj){//智能查询，根据输入的查询条件进行全索引查询
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }
    var selectName = obj.selectName==null?"":obj.selectName;
    if(selectName==""){
     return System.getResult2(null,null);
    }
    var reqUrl=this.patentUrl;

    var pagesize=obj.pagesize==null?15:obj.pagesize;

    if(obj.page==null){
      var from = 0;
    }else{
      var from = Number((obj.page-1)*obj.pagesize);
    }
    var params = {
      "query": {
        "query_string": {
          "query":selectName,
          "fields":[]
        }
      },
      "from": from,
      "size": pagesize,
      "_source": [
        "filing_no",
        "pub_type",
        "filing_date",
        "pub_date",
        "pub_no",
        "gr_date",
        "gr_no",
        "applicant_name",
        "inventor_name",
        "agent_name1",
        "agent_name2",
        "agency_code",
        "agency_name",
        "country_code",
        "appl_zip",
        "appl_address",
        "filing_name",
        "pub_status",
        "pub_status_now",
        "abstr_text",
        "main_ipc",
        "ipc_version",
        "other_ipc",
        "prior_info",
        "pct_info"
      ]
    };

    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(params,reqUrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResult2(j.hits,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };
}
module.exports=GsbPatentSearchApi;
