var System=require("../../system");
var settings=require("../../../config/settings");
const ApiBase =require("../api.base");
//const cyjAppKey="ccb00829347e4048833af213e502c8c5";
class GsbIcSearchApi extends ApiBase{
    constructor(){
      super();
      this.icmemberSearchUrl=settings.apiconfig.icmemberSearchUrl(settings.env);
      this.icshareholderSearchUrl=settings.apiconfig.icshareholderSearchUrl(settings.env);
      this.icinvestSearchUrl=settings.apiconfig.icinvestSearchUrl(settings.env);
      this.icchangeSearchUrl=settings.apiconfig.icchangeSearchUrl(settings.env);
      this.iccompanynameSearchUrl=settings.apiconfig.iccompanynameSearchUrl(settings.env);
      this.agencynameSearchUrl=settings.apiconfig.agencynameSearchUrl(settings.env); 
      this.iccompanycodeSearchUrl=settings.apiconfig.iccompanycodeSearchUrl(settings.env);
      this.iccompanyNumSearchUrl=settings.apiconfig.iccompanyNumSearchUrl(settings.env);
      this.icbranchSearchUrl=settings.apiconfig.icbranchSearchUrl(settings.env);
      this.phonesearch=System.getObject("api.phonesearch");
    };
    buildDate(date){
      var date = new Date(date);
      var time = Date.parse(date);
      time=time / 1000;
      return time;
    };

   async membersearch(obj){
     var data=await this.checkKey(obj.appKey);
     if(data && data.status && data.status==-1){
       return data;
     }
     var companyName=obj.companyName==null?"":obj.companyName;
     companyName=await this.getConvertSemiangleStr(companyName);
     var pageSize=obj.pageSize==null?15:obj.pageSize;
     if(obj.currentPage==null){
       var from = 0;
     }else{
       var from = Number((obj.currentPage-1)*obj.pageSize);
     }

     var reqUrl=this.icmemberSearchUrl;
     var params = {
        "query": {
            "bool": {
                "must": [

                    {
                        "term": {
                            "company_name":companyName
                        }
                    }
                ]
            }
        },
        "from": from,
        "size": pageSize,
        "_source": [
            "member_name",
            "member_position"
        ],
       "aggs": {
          "models": {
            "terms": {
              "field": "member_name"

            },
           "aggs": {
              "userdetail": {
                "top_hits": {
                  "size": 10,

      "_source": [
              "member_position"
      ]
                }
              }
            }
      }
      }
    };
     var rc=System.getObject("util.execClient");
     var rtn=null;
     try{
       rtn=await rc.execPost(params,reqUrl);
       var j=JSON.parse(rtn.stdout);
       var sources=[];
       var data={ "result":1,
                    "totalSize":j.hits.total,
                    "pageSize":pageSize,
                    "currentPage":obj.currentPage-1,"list":sources };
       j.aggregations.models.buckets.forEach(function(c){
         var po=[];
         c.userdetail.hits.hits.forEach(function(d){
           po.push(d._source.member_position);
         })
         var source={
           memberName:c.key,
           position:po,
         };
         sources.push(source);
       });
       var a={status:0,msg:"操作成功",data:data};
       return a;
     }catch(e){
       return {status:-1,msg:"操作失败",data:null};
     }
   };

   async shareholdersearch(obj){
     var data=await this.checkKey(obj.appKey);
     if(data && data.status && data.status==-1){
       return data;
     }
     var companyName=obj.companyName==null?"":obj.companyName;
     companyName=await this.getConvertSemiangleStr(companyName);
     var pageSize=obj.pageSize==null?15:obj.pageSize;
     if(obj.currentPage==null){
       var from = 0;
     }else{
       var from = Number((obj.currentPage-1)*obj.pageSize);
     }

     var reqUrl=this.icshareholderSearchUrl;
     var params = {
        "query": {
            "bool": {
                "must": [

                    {
                        "term": {
                            "company_name":companyName
                        }
                    }
                ]
            }
        },
        "from": from,
        "size": pageSize,
        "_source": [
              "investor_name",
              "subscribe_amount",
              "subscribe_amount_type",
              "subscribe_time",
              "subscribe_type",
              "paid_amount",
              "paid_amount_type",
              "paid_time",
              "paid_type"
        ]
    };
     var rc=System.getObject("util.execClient");
     var rtn=null;
     try{
       rtn=await rc.execPost(params,reqUrl);
       var j=JSON.parse(rtn.stdout);
       var sources=[];
       var data={ "result":1,
                    "totalSize":j.hits.total,
                    "pageSize":pageSize,
                    "currentPage":obj.currentPage-1,"list":sources };
       j.hits.hits.forEach(function(c){
         c._source.subscribe_amount_type=(c._source.subscribe_amount_type=="null"||c._source.subscribe_amount_type==null)?"":c._source.subscribe_amount_type;
         c._source.paid_amount_type=(c._source.paid_amount_type=="null"||c._source.paid_amount_type==null)?"":c._source.paid_amount_type;
         var source={
           subcribe:c._source.subscribe_amount+c._source.subscribe_amount_type,
           shareholdersName:c._source.investor_name,
           paidIn:c._source.paid_amount+c._source.paid_amount_type,
         };
         sources.push(source);
       });
       var a={status:0,msg:"操作成功",data:data};
       return a;
     }catch(e){
       return {status:-1,msg:"操作失败",data:null};
     }
   };

   async investsearch(obj){
     var data=await this.checkKey(obj.appKey);
     if(data && data.status && data.status==-1){
       return data;
     }
     var companyName=obj.companyName==null?"":obj.companyName;
     companyName=await this.getConvertSemiangleStr(companyName);
     var pageSize=obj.pageSize==null?15:obj.pageSize;
     if(obj.currentPage==null){
       var from = 0;
     }else{
       var from = Number((obj.currentPage-1)*obj.pageSize);
     }

     var reqUrl=this.icinvestSearchUrl;
     var params = {
        "query": {
            "bool": {
                "must": [

                    {
                        "term": {
                            "company_name":companyName
                        }
                    }
                ]
            }
        },
        "from": from,
        "size": pageSize,
        "_source": [
            "invest_name",
            "invest_person",
            "invest_time",
            "invest_capital",
            "capital_type"
        ]
    };
     var rc=System.getObject("util.execClient");
     var rtn=null;
     try{
       rtn=await rc.execPost(params,reqUrl);
       var j=JSON.parse(rtn.stdout);
       var sources=[];
       var data={ "result":1,
                    "totalSize":j.hits.total,
                    "pageSize":pageSize,
                    "currentPage":obj.currentPage-1,"list":sources };
       j.hits.hits.forEach(function(c){
         c._source.subscribe_amount_type=(c._source.subscribe_amount_type=="null"||c._source.subscribe_amount_type==null)?"":c._source.subscribe_amount_type;
         c._source.paid_amount_type=(c._source.paid_amount_type=="null"||c._source.paid_amount_type==null)?"":c._source.paid_amount_type;
         if(c._source.invest_time != null)
         {
           var time=new Date(c._source.invest_time*1000);
           c._source.invest_time= time.toLocaleDateString();
         }
         var source={
           foundDt:c._source.invest_time,
           companyName:c._source.invest_name,
           registeredCapital:c._source.invest_capital+c._source.capital_type,
           legalPerson:c._source.invest_person,
         };
         sources.push(source);
       });
       var a={status:0,msg:"操作成功",data:data};
       return a;
       }catch(e){
       return {status:-1,msg:"操作失败",data:null};
       }
   };

   async changesearch(obj){
     var data=await this.checkKey(obj.appKey);
     if(data && data.status && data.status==-1){
       return data;
     }
     var companyName=obj.companyName==null?"":obj.companyName;
     companyName=await this.getConvertSemiangleStr(companyName);
     var pageSize=obj.pageSize==null?15:obj.pageSize;
     if(obj.currentPage==null){
       var from = 0;
     }else{
       var from = Number((obj.currentPage-1)*obj.pageSize);
     }

     var reqUrl=this.icchangeSearchUrl;
     var params = {
        "query": {
            "bool": {
                "must": [

                    {
                        "term": {
                            "company_name":companyName
                        }
                    }
                ]
            }
        },
        "from": from,
        "size": pageSize,
        "_source": [
              "change_item",
              "change_time",
              "change_before",
              "change_after"
        ]
    };
     var rc=System.getObject("util.execClient");
     var rtn=null;
     try{
       rtn=await rc.execPost(params,reqUrl);
       var j=JSON.parse(rtn.stdout);
       var sources=[];
       var data={ "result":1,
                    "totalSize":j.hits.total,
                    "pageSize":pageSize,
                    "currentPage":obj.currentPage-1,"list":sources };
       j.hits.hits.forEach(function(c){
         c._source.subscribe_amount_type=(c._source.subscribe_amount_type=="null"||c._source.subscribe_amount_type==null)?"":c._source.subscribe_amount_type;
         c._source.paid_amount_type=(c._source.paid_amount_type=="null"||c._source.paid_amount_type==null)?"":c._source.paid_amount_type;
         if(c._source.change_time != null)
         {
           var time3=new Date(c._source.change_time*1000);
           c._source.change_time= time3.toLocaleDateString();
         }
         var source={
           changeEvent:c._source.change_item,
           changeData:c._source.change_time,
           changeBefore:c._source.change_before,
           changeAfter:c._source.change_after,
         };
         sources.push(source);
       });
       var a={status:0,msg:"操作成功",data:data};
       return a;
       }catch(e){
       return {status:-1,msg:"操作失败",data:null};
       }
   };

   async companynamesearch(obj){
     var data=await this.checkKey(obj.appKey);
     if(data && data.status && data.status==-1){
       return data;
     }
     var companyName=obj.companyName==null?"":obj.companyName;
     companyName=await this.getConvertSemiangleStr(companyName);
     var pageSize=obj.pageSize==null?15:obj.pageSize;
     if(obj.currentPage==null){
       var from = 0;
     }else{
       var from = Number((obj.currentPage-1)*obj.pageSize);
     }

     var reqUrl=this.iccompanynameSearchUrl;
     var params = {
        "query": {
            "bool": {
                "must": [
                    {
                      "query_string": {
              					"default_field": "company_name",
              					"query": '\"'+ companyName + '\"'
              				  }
                    }
                ]
            }
        },
        "from": from,
        "size": pageSize,
        "_source": [
            "company_id",
            "company_province",
            "company_domain",
            "company_name",
            "legal_person",
            "reg_status",
            "reg_unit",
            "reg_capital",
            "estibish_time",
            "reg_location",
            "credit_code"
        ],
       "sort": [
         {
           "reg_capital": "desc"
         }
       ]
    };
     var rc=System.getObject("util.execClient");
     var rtn=null;
     try{
       rtn=await rc.execPost(params,reqUrl);
       var j=JSON.parse(rtn.stdout);
       var sources=[];
       var data={ "result":1,
                    "totalSize":j.hits.total,
                    "pageSize":pageSize,
                    "currentPage":obj.currentPage-1,"list":sources };
       j.hits.hits.forEach(function(c){
         if(c._source.estibish_time != null)
         {
           var time=new Date(c._source.estibish_time*1000);
           c._source.estibish_time= time.toLocaleDateString();
         }
         var source={
           entId:c._source.company_id,
           province:c._source.company_province,
           domainEntName:c._source.company_domain,
           entName:c._source.company_name,
           entLegalperson:c._source.legal_person,
           entStatus:c._source.reg_status,
           capitalUnit:c._source.reg_unit,
           capitalStandard:c._source.reg_capital,
           foundedTime:c._source.estibish_time,
           regLocation:c._source.reg_location,
           creditCode:c._source.credit_code,
         };
         sources.push(source);
       });
       j.hits.hits=data;
       var a={status:0,msg:"操作成功",data:data};
       return a;
     }catch(e){
       return {status:-1,msg:"操作失败",data:null};
     }
   };

   async companynameonesearch(obj){
     var data=await this.checkKey(obj.appKey);
     if(data && data.status && data.status==-1){
       return data;
     }
     var companyName=obj.companyName==null?"":obj.companyName;
     companyName=await this.getConvertSemiangleStr(companyName);
     var pageSize=1;
     if(obj.currentPage==null){
       var from = 0;
     }else{
       var from = Number((obj.currentPage-1)*obj.pageSize);
     }

     var reqUrl=this.iccompanynameSearchUrl;
     var params = {
        "query": {
            "bool": {
                "must": [

                    {
                        "term": {
                            "company_name.raw":companyName
                        }
                    }
                ]
            }
        },
        "from": from,
        "size": pageSize,
        "_source": [
            "company_id",
            "company_province",
            "company_domain",
            "legal_person",
            "reg_status",
            "reg_unit",
            "reg_capital",
            "estibish_time",
            "credit_code",
            "reg_number",
            "org_number",
            "company_type",
            "reg_institute",
            "reg_location",
            "business_scope",
            "approved_time",
            "from_time",
            "to_time",
            "reg_unit"
        ]
    };
     var rc=System.getObject("util.execClient");
     var rtn=null;
     try{
       rtn=await rc.execPost(params,reqUrl);
       var j=JSON.parse(rtn.stdout);
       var sources=[];
       var data={ "result":1,
                    "totalSize":j.hits.total,
                    "pageSize":1,
                    "currentPage":obj.currentPage-1,"list":sources };
       j.hits.hits.forEach(function(c){
         if(c._source.approved_time != null)
         {
           var time3=new Date(c._source.approved_time*1000);
           c._source.approved_time= time3.toLocaleDateString();
         }
         if(c._source.from_time != null)
         {
           var time3=new Date(c._source.from_time*1000);
           c._source.from_time= time3.toLocaleDateString();
         }
         if(c._source.to_time != null)
         {
           var time3=new Date(c._source.to_time*1000);
           c._source.to_time= time3.toLocaleDateString();
         }
         if(c._source.estibish_time != null)
         {
           var time3=new Date(c._source.estibish_time*1000);
           c._source.estibish_time= time3.toLocaleDateString();
         }
         var source={
           name:c._source.company_domain,
           legalRepresentative:c._source.legal_person,
           managementState:c._source.reg_status,
           registeredCapital: c._source.reg_capital+c._source.reg_unit,
           foundedTime:c._source.estibish_time,
           creditCode:c._source.credit_code,
           registrID:c._source.reg_number,
           organizationCode:c._source.org_number,
           companyType:c._source.company_type,
           registerOffice:c._source.reg_institute,
           businessAddress:c._source.reg_location,
           scope:c._source.business_scope,
           dateIssue:c._source.approved_time,
           businessTerm:c._source.from_time+"至"+c._source.to_time,
         };
         sources.push(source);
       });
       var a={status:0,msg:"操作成功",data:data};
       return a;
       }catch(e){
       return {status:-1,msg:"操作失败",data:null};
       }
   };

   async companyonesearch(obj){
     var self=this;
     var data=await this.checkKey(obj.appKey);
     if(data && data.status && data.status==-1){
       return data;
     }
     var companyName=obj.companyName==null?"":obj.companyName;
     companyName=await this.getConvertSemiangleStr(companyName);
     var pageSize=1;
     if(obj.currentPage==null){
       var from = 0;
     }else{
       var from = Number((obj.currentPage-1)*obj.pageSize);
     }

     var reqUrl=this.iccompanynameSearchUrl;
     var params = {
        "query": {
            "bool": {
                "must": [

                    {
                        "term": {
                            "company_name.raw":companyName
                        }
                    }
                ]
            }
        },
        "from": from,
        "size": pageSize,
        "_source": [
            "company_id",
            "company_province",
            "company_domain",
            "legal_person",
            "reg_status",
            "reg_unit",
            "reg_capital",
            "estibish_time",
            "credit_code",
            "reg_number",
            "org_number",
            "company_type",
            "reg_institute",
            "reg_location",
            "business_scope",
            "approved_time",
            "from_time",
            "to_time",
            "reg_unit"
        ]
    };
     var rc=System.getObject("util.execClient");
     var rtn=null;
     try{
       rtn=await rc.execPost(params,reqUrl);
       var j=JSON.parse(rtn.stdout);
       var sources=[];
       var data={ "result":1,
                    "totalSize":j.hits.total,
                    "pageSize":1,
                    "currentPage":obj.currentPage-1,"list":sources };
        for(var k=0;k<j.hits.hits.length;k++){
          var c=j.hits.hits[k];
          if(c._source.approved_time != null)
          {
            var time3=new Date(c._source.approved_time*1000);
            c._source.approved_time= time3.toLocaleDateString();
          }
          if(c._source.from_time != null)
          {
            var time3=new Date(c._source.from_time*1000);
            c._source.from_time= time3.toLocaleDateString();
          }
          if(c._source.to_time != null)
          {
            var time3=new Date(c._source.to_time*1000);
            c._source.to_time= time3.toLocaleDateString();
          }
          if(c._source.estibish_time != null)
          {
            var time3=new Date(c._source.estibish_time*1000);
            c._source.estibish_time= time3.toLocaleDateString();
          }
          if(c._source.company_domain){
            var pobj={
              appKey:obj.appKey,
              companyName:c._source.company_domain
            }
            var phones= await self.phonesearch.phoneNameSearch(pobj);
            if(phones.status==0 && phones.data.list.length>0){
              c._source.tel_info=phones.data.list[0]._doc.phone_number;
              c._source.email_info=phones.data.list[0]._doc.email;
            }
          }
          if(c._source.reg_unit==null){
            c._source.reg_unit="万人民币";
          }
          if(c._source.reg_capital==null){
            c._source.reg_capital="未公开";
            c._source.reg_unit="";
          }
          var source={
            name:c._source.company_domain,
            legalRepresentative:c._source.legal_person,
            managementState:c._source.reg_status,
            registeredCapital: c._source.reg_capital+c._source.reg_unit,
            foundedTime:c._source.estibish_time,
            creditCode:c._source.credit_code,
            registrID:c._source.reg_number,
            organizationCode:c._source.org_number,
            companyType:c._source.company_type,
            registerOffice:c._source.reg_institute,
            businessAddress:c._source.reg_location,
            scope:c._source.business_scope,
            dateIssue:c._source.approved_time,
            businessTerm:c._source.from_time+"至"+c._source.to_time,
            tel_info:c._source.tel_info,
          };
          sources.push(source);
        }
       var a={status:0,msg:"操作成功",data:data};
       return a;
       }catch(e){
       return {status:-1,msg:"操作失败",data:null};
       }
   };

   async companymgetsearch(obj){
     var self=this;
     var data=await this.checkKey(obj.appKey);
     if(data && data.status && data.status==-1){
       return data;
     }
     var companyNames=obj.companyNames;
     var pageSize=obj.companyNames.length;
     if(obj.currentPage==null){
       var from = 0;
     }else{
       var from = Number((obj.currentPage-1)*obj.pageSize);
     }

     var reqUrl=this.iccompanynameSearchUrl;
     var params = {
        "query": {
            "bool": {
                "must": [

                    {
                        "terms": {
                            "company_name.raw":companyNames
                        }
                    }
                ]
            }
        },
        "from": from,
        "size": pageSize,
        "_source": [
            "company_domain",
            "legal_person",
            "reg_unit",
            "reg_capital",
            "approved_time",
            "reg_location"
        ]
    };
     var rc=System.getObject("util.execClient");
     var rtn=null;
     try{
       rtn=await rc.execPost(params,reqUrl);
       var j=JSON.parse(rtn.stdout);
       var sources=[];
       var data={ "result":1,
                    "totalSize":j.hits.total,
                    "pageSize":pageSize,
                    "currentPage":obj.currentPage-1,"list":sources };
        for(var k=0;k<j.hits.hits.length;k++){
          var c=j.hits.hits[k];
          if(c._source.approved_time != null)
          {
            var time3=new Date(c._source.approved_time*1000);
            c._source.approved_time= time3.toLocaleDateString();
          }
          if(c._source.company_domain){
            var pobj={
              appKey:obj.appKey,
              companyName:c._source.company_domain
            }
            var phones= await self.phonesearch.phoneNameSearch(pobj);
            if(phones.status==0 && phones.data.list.length>0){
              c._source.tel_info=phones.data.list[0]._doc.phone_number;
              c._source.email_info=phones.data.list[0]._doc.email;
            }
          }
          if(c._source.reg_unit==null){
            c._source.reg_unit="万人民币";
          }
          if(c._source.reg_capital==null){
            c._source.reg_capital="未公开";
            c._source.reg_unit="";
          }
          var source={
            name:c._source.company_domain,
            legalRepresentative:c._source.legal_person,
            registeredCapital: c._source.reg_capital+c._source.reg_unit,
            tel_info:c._source.tel_info,
            dateIssue:c._source.approved_time,
            businessAddress:c._source.reg_location
          };
          sources.push(source);
        }
       var a={status:0,msg:"操作成功",data:data};
       return a;
       }catch(e){
       return {status:-1,msg:"操作失败",data:null};
       }
   };

   async companycodesearch(obj){
     var data=await this.checkKey(obj.appKey);
     if(data && data.status && data.status==-1){
       return data;
     }
     var creditCode=obj.creditCode==null?"":obj.creditCode;
     var pageSize=obj.pageSize==null?15:obj.pageSize;
     if(obj.currentPage==null){
       var from = 0;
     }else{
       var from = Number((obj.currentPage-1)*obj.pageSize);
     }

     var reqUrl=this.iccompanycodeSearchUrl;
     var params = {
        "query": {
            "bool": {
                "must": [

                    {
                        "term": {
                            "credit_code":creditCode
                        }
                    }
                ]
            }
        },
        "from": from,
        "size": pageSize,
        "_source": [
          "company_name",
          "credit_code",
          "reg_number",
          "company_type",
          "legal_person",
          "reg_capital",
          "reg_institute",
          "reg_location",
          "business_scope",
          "org_number",
          "reg_status",
          "estibish_time",
          "approved_time",
          "from_time",
          "to_time",
          "reg_unit"
        ]
    };
     var rc=System.getObject("util.execClient");
     var rtn=null;
     try{
       rtn=await rc.execPost(params,reqUrl);
       var j=JSON.parse(rtn.stdout);
       var sources=[];
       var data={ "result":1,
                    "totalSize":j.hits.total,
                    "pageSize":pageSize,
                    "currentPage":obj.currentPage-1,"list":sources };
       j.hits.hits.forEach(function(c){
         if(c._source.approved_time != null)
         {
           var time3=new Date(c._source.approved_time*1000);
           c._source.approved_time= time3.toLocaleDateString();
         }
         if(c._source.from_time != null)
         {
           var time3=new Date(c._source.from_time*1000);
           c._source.from_time= time3.toLocaleDateString();
         }
         if(c._source.to_time != null)
         {
           var time3=new Date(c._source.to_time*1000);
           c._source.to_time= time3.toLocaleDateString();
         }
         if(c._source.estibish_time != null)
         {
           var time3=new Date(c._source.estibish_time*1000);
           c._source.estibish_time= time3.toLocaleDateString();
         }
         var source={
           name:c._source.company_name,
           legalRepresentative:c._source.legal_person,
           managementState:c._source.reg_status,
           registeredCapital: c._source.reg_capital+c._source.reg_unit,
           foundedTime:c._source.estibish_time,
           creditCode:c._source.credit_code,
           registrID:c._source.reg_number,
           organizationCode:c._source.org_number,
           companyType:c._source.company_type,
           registerOffice:c._source.reg_institute,
           businessAddress:c._source.reg_location,
           scope:c._source.business_scope,
           dateIssue:c._source.approved_time,
           businessTerm:c._source.from_time+"至"+c._source.to_time,
         };
         sources.push(source);
       });
       var a={status:0,msg:"操作成功",data:data};
       return a;
       }catch(e){
       return {status:-1,msg:"操作失败",data:null};
       }
   };

   async companyNumsearch(obj){
     var data=await this.checkKey(obj.appKey);
     if(data && data.status && data.status==-1){
       return data;
     }
     var regNumber=obj.regNumber==null?"":obj.regNumber;
     var pageSize=obj.pageSize==null?15:obj.pageSize;
     if(obj.currentPage==null){
       var from = 0;
     }else{
       var from = Number((obj.currentPage-1)*obj.pageSize);
     }

     var reqUrl=this.iccompanyNumSearchUrl;
     var params = {
        "query": {
            "bool": {
                "must": [

                    {
                        "term": {
                            "reg_number":regNumber
                        }
                    }
                ]
            }
        },
        "from": from,
        "size": pageSize,
        "_source": [
          "company_name",
      		"credit_code",
      		"reg_number",
      		"company_type",
      		"legal_person",
      		"reg_capital",
      		"reg_institute",
      		"reg_location",
      		"business_scope",
      		"org_number",
      		"reg_status",
      		"estibish_time",
      		"approved_time",
      		"from_time",
      		"to_time",
          "reg_unit"
        ]
    };
     var rc=System.getObject("util.execClient");
     var rtn=null;
     try{
       rtn=await rc.execPost(params,reqUrl);
       var j=JSON.parse(rtn.stdout);
       var sources=[];
       var data={ "result":1,
                    "totalSize":j.hits.total,
                    "pageSize":pageSize,
                    "currentPage":obj.currentPage-1,"list":sources };
       j.hits.hits.forEach(function(c){
         if(c._source.approved_time != null)
         {
           var time3=new Date(c._source.approved_time*1000);
           c._source.approved_time= time3.toLocaleDateString();
         }
         if(c._source.from_time != null)
         {
           var time3=new Date(c._source.from_time*1000);
           c._source.from_time= time3.toLocaleDateString();
         }
         if(c._source.to_time != null)
         {
           var time3=new Date(c._source.to_time*1000);
           c._source.to_time= time3.toLocaleDateString();
         }
         if(c._source.estibish_time != null)
         {
           var time3=new Date(c._source.estibish_time*1000);
           c._source.estibish_time= time3.toLocaleDateString();
         }
         var source={
           name:c._source.company_name,
           legalRepresentative:c._source.legal_person,
           managementState:c._source.reg_status,
           registeredCapital: c._source.reg_capital+c._source.reg_unit,
           foundedTime:c._source.estibish_time,
           creditCode:c._source.credit_code,
           registrID:c._source.reg_number,
           organizationCode:c._source.org_number,
           companyType:c._source.company_type,
           registerOffice:c._source.reg_institute,
           businessAddress:c._source.reg_location,
           scope:c._source.business_scope,
           dateIssue:c._source.approved_time,
           foundation:c._source.from_time,
           businessTerm:c._source.from_time+"至"+c._source.to_time,
         };
         sources.push(source);
       });
       var a={status:0,msg:"操作成功",data:data};
       return a;
       }catch(e){
       return {status:-1,msg:"操作失败",data:null};
       }
   };

   async agencynameonesearch(obj){
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }
    var companyName=obj.companyName==null?"":obj.companyName;
    companyName=await this.getConvertSemiangleStr(companyName);
    var pageSize=obj.pageSize==null?10:obj.pageSize;
    if(obj.currentPage==null){
      var from = 0;
    }else{
      var from = Number((obj.currentPage-1)*obj.pageSize);
    }

    var reqUrl=this.agencynameSearchUrl;
    var params = {
       "query": {
           "bool": {
               "must": [

                   {
                    "query_string": {
                      "default_field": "company_name",
                      "query": '\"'+ companyName + '\"'
                      }
                   }
               ]
           }
       },
       "from": from,
       "size": pageSize
   };
    var rc=System.getObject("util.execClient");
    var rtn=null;
    try{
      rtn=await rc.execPost(params,reqUrl);
      var j=JSON.parse(rtn.stdout);
      var data={ "result":1,
                   "totalSize":j.hits.total,
                   "pageSize":1,
                   "currentPage":obj.currentPage-1,"list":j.hits.hits };
      var a={status:0,msg:"操作成功",data:data};
      return a;
      }catch(e){
      return {status:-1,msg:"操作失败",data:null};
      }
  };

   async branchsearch(obj){
     var data=await this.checkKey(obj.appKey);
     if(data && data.status && data.status==-1){
       return data;
     }
     var companyName=obj.companyName==null?"":obj.companyName;
     companyName=await this.getConvertSemiangleStr(companyName);
     var pageSize=obj.pageSize==null?15:obj.pageSize;
     if(obj.currentPage==null){
       var from = 0;
     }else{
       var from = Number((obj.currentPage-1)*obj.pageSize);
     }

     var reqUrl=this.icbranchSearchUrl;
     var params = {
        "query": {
            "bool": {
                "must": [

                    {
                        "term": {
                            "company_name":companyName
                        }
                    }
                ]
            }
        },
        "from": from,
        "size": pageSize,
        "_source": [
                "branch_name"
        ]
    };
     var rc=System.getObject("util.execClient");
     var rtn=null;
     try{
       rtn=await rc.execPost(params,reqUrl);
       var j=JSON.parse(rtn.stdout);


       var sources=[];
       var data={ "result":1,
                    "totalSize":j.hits.total,
                    "pageSize":pageSize,
                    "currentPage":obj.currentPage-1,"list":sources };
       j.hits.hits.forEach(function(c){
         var source={
           entName:c._source.branch_name,
         };
         sources.push(source);
       });
       var a={status:0,msg:"操作成功",data:data};
       return a;
       }catch(e){
       return {status:-1,msg:"操作失败",data:null};
       }
   };

   async getConvertSemiangleStr(str){
     var result = "";
     str=str.replace(/\s+/g,"");
     var len = str.length;
     for(var i=0;i<len;i++)
     {
         var cCode = str.charCodeAt(i);
         //全角与半角相差（除空格外）：65248（十进制）
         cCode = (cCode>=0xFF01 && cCode<=0xFF5E)?(cCode - 65248) : cCode;
         //处理空格
         cCode = (cCode==0x03000)?0x0020:cCode;
         result += String.fromCharCode(cCode);
     }
    return result;
   };
}
module.exports=GsbIcSearchApi;
// var capi=new GsbTmSearchApi();
// capi.xzSearch({}).then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });
