var System = require("../../system");
var settings = require("../../../config/settings");
const ApiBase = require("../api.base");
const logCtl = System.getObject("web.oplogCtl");
// const uuidv4 = require('uuid/v4');
class EntImageApi extends ApiBase {
  constructor() {
    super();
    this.utilsentimageSve = System.getObject("service.utilsentimageSve");
    this.utilstmSve = System.getObject("service.utilstmSve");
    this.utilscopyrightSve = System.getObject("service.utilscopyrightSve");
    this.utilspaSve = System.getObject("service.utilspaSve");
  }
  async get_customerinfo(obj) {
    try {
      var data = await this.checkKey(obj.appKey);
      if (data && data.status && data.status == -1) {
        return { code: -100, message: "appKey参数错误", data: {} };
      }
      if (!obj.mobile) {
        return { code: -100, message: "mobile不能为空", data: {} };
      }
      var tmpresult = await this.utilsentimageSve.getEntInfo(obj.mobile);
      return tmpresult;
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "获取企业信息异常",
        op: "base/api/impl/entimage/get_customerinfo",
        content: "参数：" + JSON.stringify(obj) + "，error：" + e.stack,
        clientIp: obj.clientIp
      });
      return { code: 1, message: "error", data: {} };
    }
  }

  async get_customer_total(obj) {
    var result = {
      code: 1, message: "success", data: {}
    }
    try {
      var data = await this.checkKey(obj.appKey);
      if (data && data.status == -1) {
        result.code = -1;
        result.message = "appKey错误";
        return result;
      }
      var totalInfo = {
        zc_total: 63,//无形资产数值
        tm_num: 120,//商标数量
        pa_num: 20,//专利数量
        cp_num: 10,//版权数量       
      };
      result.data.total_info = totalInfo;
      result.data.customer_manage = [{ name: "汉唐信通(北京)科技有限公司", op_content: "1000万元" },
      { name: "北京联大共享科技有限公司", op_content: "100万元" }];
      return result;
    } catch (e) {
      //日志记录
      logCtl.error({
        optitle: "获取企业统计异常",
        op: "base/api/impl/entimage/get_customer_total",
        content: "参数：" + JSON.stringify(obj) + "，error：" + e.stack,
        clientIp: obj.clientIp
      });
      result.code = -200;
      result.message = "error";
      return result;
    }
  }

}
module.exports = EntImageApi;
