const ApiBase = require("../api.base");
const System = require("../../system");
const request = require('request');
const aliyunClient = require('../../utils/aliyunClient.js');

const OplogSve = require('../../service/impl/oplogSve.js');

// let fqReqUrl = "https://yunfuapi.gongsibao.com";//线上域名
let fqReqUrl = "https://yunfuapi-dev.gongsibao.com";//dev域名

//推送联系地址等信息到阿里（每次需要推送50条）
class CustomerInfoPusherApi {
    constructor() {
        this.trademarkS = System.getObject("service.trademarkSve");
        this.tmapplierinfoDao = System.getObject("db.tmapplierinfoDao");
        this.aliyunClient = new aliyunClient();
        this.oplogSve = new OplogSve();
    };

    async collectInfo() {
        try {

            //获取联系人信息(最少50条)
            let resultTmCustomer = await this.trademarkS.queryTmCustomerInfo();
            let tmCustomers = resultTmCustomer;
            console.log("联系人信息：", JSON.stringify(tmCustomers));
            if (tmCustomers.length <= 0) {
                return { code: 200, message: "所有数据已推送完成" };
            }

            for (let i = 0; i < tmCustomers.length; i++) {
                let obj = {};
                let customerInfo = tmCustomers[i];
                let orderNum = customerInfo.orderNum;

                //根据服务单号获取BizId(需求业务ID)
                let bizResults = await this.trademarkS.queryTmInfo(orderNum);
                let bizId = bizResults[0];

                let printLog = "orderNum: " + JSON.stringify(orderNum) + "bizId: " + JSON.stringify(bizId)
                console.log(printLog);

                //如果没有bizId,直接下一个
                if (!bizId) {
                    console.log("没有bizId");
                    let pusherStatus = await this.trademarkS.updateTmCustomerInfo(orderNum);
                    console.log("不是阿里商标,更新状态成功" + orderNum);
                    continue;
                }
                if (!bizId.businessId) {
                    console.log("没有businessId");
                    let pusherStatus = await this.trademarkS.updateTmCustomerInfo(orderNum);
                    console.log("不是阿里商标,更新状态成功" + orderNum);
                    continue;
                }

                obj.BizId = bizId.businessId;
                obj.ContactAddress = customerInfo.contactAddress;
                obj.ContactName = customerInfo.customerContact;
                obj.ContactNumber = customerInfo.mobile;
                obj.ContactEmail = customerInfo.email;
                obj.ContactZipCode = customerInfo.zipCode;

                //调用阿里API推送到阿里
                let pushRes = await this.aliyunClient.post("UpdateApplicantContacter", obj);
                console.log("推送完成:" + i, pushRes);
                //将成功结果写入到日志
                await this.oplogSve.create({
                    logLevel: "info",
                    optitle: "推送联系人信息到阿里",
                    op: "app/base/api/impl/customerInfoPusherApi/collectInfo",
                    content: "参数:" + JSON.stringify(obj) + "返回结果:" + JSON.stringify(pushRes),
                    clientIp: ""
                });

                //根据阿里接口返回的状态修改数据库中addressIsPushed的状态
                let pusherStatus = await this.trademarkS.updateTmCustomerInfo(orderNum);
                console.log("更新状态成功" + orderNum);
            }
            return { code: 200, message: "调用推送接口成功" };
        } catch (e) {
            console.log('collectInfo error: ', e);
            //将错误写入到日志
            await this.oplogSve.create({
                logLevel: "error",
                optitle: "推送联系人信息到阿里---异常",
                op: "app/base/api/impl/customerInfoPusherApi/collectInfo",
                content: JSON.stringify(e.stack),
                clientIp: ""
            });
            return { code: -1, message: e };
        }
    }
}

module.exports = CustomerInfoPusherApi;