var System=require("../../system");
var settings=require("../../../config/settings");
const querystring = require('querystring');
const ApiBase =require("../api.base");

class CPatentAggregationsApi extends ApiBase{
  constructor(){
    super();
    this.patentUrl = settings.reqEsAddrIc()+"bigdata_patent_op/_search";
  };
  buildDate(date){
    var date = new Date(date);
    var time = Date.parse(date);
    time=time / 1000;
    return time;
  };

  async TitlePubtypeAggs(obj){//根据标题查询，根据专利类型聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var title = obj.title==null?"":obj.title;
    if(title==""){
        return {status:-1,msg:"传入标题信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "pub_type",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "filing_name": title
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      parr = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      parr = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      parr = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      parr = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }


    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async FilingnoPubtypeAggs(obj){//根据申请号查询，根据专利类型聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var filingno = obj.filingno==null?"":obj.filingno;
    if(filingno==""){
        return {status:-1,msg:"传入的申请号信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "pub_type",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "filing_no": filingno
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      parr = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      parr = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      parr = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      parr = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async PubnoPubtypeAggs(obj){//根据公开号查询，根据专利类型聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var pubno = obj.pubno==null?"":obj.pubno;
    if(pubno==""){
        return {status:-1,msg:"传入的公开号信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "pub_type",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "pub_no": pubno
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      parr = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      parr = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      parr = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      parr = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async ApplicantPubtypeAggs(obj){//根据申请人查询，根据专利类型聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var applicant = obj.applicant==null?"":obj.applicant;
    if(applicant==""){
        return {status:-1,msg:"传入的申请人信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "pub_type",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "applicant_name": applicant
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      parr = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      parr = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      parr = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      parr = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }


    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };


  async InventorPubtypeAggs(obj){//根据发明人查询，根据专利类型聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var inventor = obj.inventor==null?"":obj.inventor;
    if(inventor==""){
        return {status:-1,msg:"传入的发明人信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "pub_type",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "inventor_name": inventor
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      parr = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      parr = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      parr = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      parr = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async TitlePubstatusAggs(obj){//根据标题查询，根据专利状态聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var title = obj.title==null?"":obj.title;
    if(title==""){
        return {status:-1,msg:"传入标题信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "pub_status",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "filing_name": title
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      parr = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      parr = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      parr = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      parr = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async FilingnoPubstatusAggs(obj){//根据申请号查询，根据专利状态聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var filingno = obj.filingno==null?"":obj.filingno;
    if(filingno==""){
        return {status:-1,msg:"传入的申请号信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "pub_status",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "filing_no": filingno
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async PubnoPubstatusAggs(obj){//根据公开号查询，根据专利状态聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var pubno = obj.pubno==null?"":obj.pubno;
    if(pubno==""){
        return {status:-1,msg:"传入的公开号信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "pub_status",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "pub_no": pubno
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async ApplicantPubstatusAggs(obj){//根据申请人查询，根据专利状态聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var applicant = obj.applicant==null?"":obj.applicant;
    if(applicant==""){
        return {status:-1,msg:"传入的申请人信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "pub_status",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "applicant_name": applicant
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async InventorPubstatusAggs(obj){//根据发明人查询，根据专利状态聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var inventor = obj.inventor==null?"":obj.inventor;
    if(inventor==""){
        return {status:-1,msg:"传入的发明人信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "pub_status",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "inventor_name": inventor
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async TitleFilingyearAggs(obj){//根据标题查询，根据申请年份聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var title = obj.title==null?"":obj.title;
    if(title==""){
        return {status:-1,msg:"传入标题信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "filing_year",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "filing_name": title
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async FilingnoFilingyearAggs(obj){//根据申请号查询，根据申请年份聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var filingno = obj.filingno==null?"":obj.filingno;
    if(filingno==""){
        return {status:-1,msg:"传入的申请号信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "filing_year",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "filing_no": filingno
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async PubnoFilingyearAggs(obj){//根据公开号查询，根据申请年份聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var pubno = obj.pubno==null?"":obj.pubno;
    if(pubno==""){
        return {status:-1,msg:"传入的公开号信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "filing_year",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "pub_no": pubno
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async ApplicantFilingyearAggs(obj){//根据申请人查询，根据申请年份聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var applicant = obj.applicant==null?"":obj.applicant;
    if(applicant==""){
        return {status:-1,msg:"传入的申请人信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "filing_year",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "applicant_name": applicant
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async InventorfilingyearAggs(obj){//根据发明人查询，根据申请年份聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var inventor = obj.inventor==null?"":obj.inventor;
    if(inventor==""){
        return {status:-1,msg:"传入的发明人信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "filing_year",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "inventor_name": inventor
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async TitleFilingyearAggs(obj){//根据标题查询，根据公开年份聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var title = obj.title==null?"":obj.title;
    if(title==""){
        return {status:-1,msg:"传入标题信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "pub_year",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "filing_name": title
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async FilingnoFilingyearAggs(obj){//根据申请号查询，根据公开年份聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var filingno = obj.filingno==null?"":obj.filingno;
    if(filingno==""){
        return {status:-1,msg:"传入的申请号信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "pub_year",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "filing_no": filingno
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async PubnoFilingyearAggs(obj){//根据公开号查询，根据公开年份聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var pubno = obj.pubno==null?"":obj.pubno;
    if(pubno==""){
        return {status:-1,msg:"传入的公开号信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "pub_year",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "pub_no": pubno
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async ApplicantFilingyearAggs(obj){//根据申请人查询，根据公开年份聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var applicant = obj.applicant==null?"":obj.applicant;
    if(applicant==""){
        return {status:-1,msg:"传入的申请人信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "pub_year",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "applicant_name": applicant
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };

  async InventorfilingyearAggs(obj){//根据发明人查询，根据公开年份聚合
    var data=await this.checkKey(obj.appKey);
    if(data && data.status && data.status==-1){
      return data;
    }

    var inventor = obj.inventor==null?"":obj.inventor;
    if(inventor==""){
        return {status:-1,msg:"传入的发明人信息为空",data:null};
    }

    var params= {
      "query": {
        "bool": {
          "must": []
        }
      },
      "from": 0,
      "size": 1,
      "aggregations": {
        "types": {
            "terms": {
                "field": "pub_year",
                "size": 1000
            }
        }
      }
    };

    var param = {
      "term": {
        "inventor_name": inventor
      }
    }
    params.query.bool.must.push(param);

    var pubtype=obj.pubype==null?"":obj.pubtype;//专利类型
    if (pubtype != null && pubtype != ""){
      param = {
        "term": {
           "pub_type": pubtype
        }
      }
      params.query.bool.must.push(param)
    }

    var pubsatus = obj.pubstatus==null?"":obj.pubstatus;//法律状态
    if (pubstatus != null && pubstatus != ""){
      param = {
        "term": {
           "pub_status": pubstatus
        }
      }
      params.query.bool.must.push(param)
    }

    var filingyear = obj.filingyear==null?"":obj.filingyear;//申请年份
    if (filingyear != null && filingyear !=""){
      param = {
        "term": {
           "filing_year": filingyear
        }
      }
      params.query.bool.must.push(param)
    }

    var pubyear = obj.pubyear==null?"":obj.pubyear;//公开年份
    if (pubyear != null && pubyear != ""){
      param = {
        "term": {
           "pub_year": pubyear
        }
      }
      params.query.bool.must.push(param)
    }

    var rc=System.getObject("util.execClient");
    var rtn=null;
    var requrl = this.patentUrl;
    try{
      rtn=await rc.execPost(params,requrl);
      var j=JSON.parse(rtn.stdout);
      return System.getResultjuhe(j,null);
    }catch(e){
      return rtn=System.getResult2(null,null);
    }
  };
}
module.exports = CPatentAggregationsApi;
