var System=require("../../system")
const http=require("http")
const querystring = require('querystring');
const md5=require("MD5");
const uuidv4 = require('uuid/v4');
const cyjAppKey="ccb00829347e4048833af213e502c8c5";
var settings=require("../../../config/settings");
class CompanyApi{
    constructor(){
      this.baseUrl=settings.teleDomain();//测试
      // this.baseUrl="http://www.telecredit.cn/";//生产
      this.cacheManager=System.getObject("db.cacheManager");
    };
    async checkParams(obj){
      let key = await this.cacheManager["InitAppKeyCache"].getAppKeyVal(obj.appKey);
      if(key==null){
        return System.getResult2(null,null,"ok","请检查您的授权KEY");
      }
      if(obj.companyName.replace(/(^s*)|(s*$)/g, "").length ==0)
      {
       return System.getResult2(null,null,"ok","请输入要查询的公司名");
      }
    };
    async checkParams2(obj){
      let key = await this.cacheManager["InitAppKeyCache"].getAppKeyVal(obj.appKey);
      if(key==null){
        return System.getResult2(null,null,"ok","请检查您的授权KEY");
      }

    };
    buildParams(obj){
     var currentT=(new Date()).Format("yyyy-MM-dd hh:mm:ss");
     var params = {
       companyName:obj.companyName,
       appKey:"gongsibao",
       currentTime:currentT,
       currentPage:obj.page?obj.page:0,
       pageSize:obj.pagesize?obj.pagesize:5,
     };
     var originStr=params.currentTime+params.appKey+"d10c5fa8d0d41a56fd1390ad214898ed"
      +params.companyName+params.currentPage+""+params.pageSize;
     var token=md5(originStr);
     params.token=token;
     return params;
   };
   async entsearch(obj){//企业名称模糊搜索
    var data=await this.checkParams(obj);
    if(data && data.status && data.status==-1){
      return data;
    }
     var reqUrl=this.baseUrl+"data/api/companyInfo/pageEntSearch"
     var currentT=(new Date()).Format("yyyy-MM-dd hh:mm:ss");
     let params = {
       companyName:obj.companyName,
       appKey:"gongsibao",
       currentTime:currentT,
       currentPage:obj.page?obj.page:0,
       pageSize:obj.pagesize?obj.pagesize:5,
     };
     var originStr=params.currentTime+params.appKey+"d10c5fa8d0d41a56fd1390ad214898ed"
      +params.companyName+params.currentPage+""+params.pageSize;
     var token=md5(originStr);
     params.token=token;
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params)
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return System.getResult2(null,null);
     }
   }
   async entregistry(obj){//企业注册信息 企业工商详细信息
     var data=await this.checkParams(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/companyInfo/entregistry";
     //data/api/companyInfo/entregistry
     let params = this.buildParams(obj);
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
   async pageEntshareholder(obj){//股东信息
     var data=await this.checkParams(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/companyInfo/pageEntshareholder";
     //data/api/companyInfo/entregistry
     let params = this.buildParams(obj);
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };

   async pageEntMember(obj){//主要人员信息 企业核心团队信息
     var data=await this.checkParams(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/companyInfo/pageEntMember";
     //data/api/companyInfo/entregistry
     let params = this.buildParams(obj);
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
   async pageEntBranch(obj){//分支机构
     var data=await this.checkParams(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/companyInfo/pageEntBranch";
     //data/api/companyInfo/entregistry
     let params = this.buildParams(obj);
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
   async pageEntInvest(obj){//对外投资
     var data=await this.checkParams(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/companyInfo/pageEntInvest";
     //data/api/companyInfo/entregistry
     let params = this.buildParams(obj);
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
   //------------------------------------------------------
   async pageAnnualReport(obj){//年报  联系信息
     var data=await this.checkParams(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/companyInfo/pageAnnualReport";
     //data/api/companyInfo/entregistry
     let params = this.buildParams(obj);
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
   async pageEntChangeRecord(obj){//企业变更记录
     var data=await this.checkParams(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/companyInfo/pageEntChangeRecord";
     //data/api/companyInfo/entregistry
     let params = this.buildParams(obj);
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
   async pageJudgment(obj){//法院判决
     var data=await this.checkParams(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/companyInfo/pageJudgment";
     let params = this.buildParams(obj);
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
   async pageDishonestInfo(obj){//失信人信息
     var data=await this.checkParams(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/companyInfo/pageDishonestInfo";
     let params = this.buildParams(obj);
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
   async pageCourtExecutive(obj){//被执行人信息
     var data=await this.checkParams(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/companyInfo/pageCourtExecutive";
     let params = this.buildParams(obj);
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
   async pageIcpInfo(obj){//icp信息
     var data=await this.checkParams(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/companyInfo/pageIcpInfo";
     let params = this.buildParams(obj);
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
   async pagePatents(obj){//专利信息
     var data=await this.checkParams(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/companyInfo/pagePatents";
     let params = this.buildParams(obj);
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
   async pageCopyright(obj){//软件著作权信息
     var data=await this.checkParams(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/companyInfo/pageCopyright";
     let params = this.buildParams(obj);
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
   async pageTm(obj){//商标信息
     var data=await this.checkParams(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/companyInfo/pageTm";
     let params = this.buildParams(obj);
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
   async pageWorksCopyright(obj){//作品著作权信息
     var data=await this.checkParams(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/companyInfo/pageWorksCopyright";
     let params = this.buildParams(obj);
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
   // async pageReportWebInfo(obj){//商标流程信息 操作失败 4809011
   //   var data=await this.checkParams2(obj);
   //   if(data && data.status && data.status==-1){
   //     return data;
   //   }
   //   var reqUrl=this.baseUrl+"data/api/companyInfo/pageReportWebInfo";
   //   var currentT=(new Date()).Format("yyyy-MM-dd hh:mm:ss");
   //   var params = {
   //     tmId:obj.tmId,
   //     appKey:"gongsibao",
   //     currentTime:currentT,
   //     currentPage:obj.currentPage?obj.currentPage:0,
   //     pageSize:obj.pageSize?obj.pageSize:5,
   //   };
   //   console.log("------------------params---------------------");
   //   console.log(params);
   //   var originStr=params.currentTime+params.appKey+"d10c5fa8d0d41a56fd1390ad214898ed"
   //    +params.currentPage+""+params.pageSize+params.tmId;
   //   var token=md5(originStr);
   //   params.token=token;
   //   console.log(params);
   //   var rc=System.getObject("util.restClient");
   //   var data=querystring.stringify(params);
   //   var rtn=null;
   //   try{
   //     rtn=await rc.execPost2(data,reqUrl);
   //     return System.getResult2(JSON.parse(rtn.stdout).data,null);
   //   }catch(e){
   //     return rtn=System.getResult2(null,null);
   //   }
   // };
   async pageTmdesc(obj){//商标详情信息
     var data=await this.checkParams2(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/companyInfo/pageTmdesc";
     var currentT=(new Date()).Format("yyyy-MM-dd hh:mm:ss");
     var params = {
       tmId:obj.tmId,
       appKey:"gongsibao",
       currentTime:currentT,
     };
     var originStr=params.currentTime+params.appKey+"d10c5fa8d0d41a56fd1390ad214898ed"
      +params.tmId;
     var token=md5(originStr);
     params.token=token;
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
   async pagePatentdesc(obj){//专利详情信息
     var data=await this.checkParams2(obj);
     if(data && data.status && data.status==-1){
       return data;
     }
     var reqUrl=this.baseUrl+"data/api/companyInfo/pagePatentdesc";
     var currentT=(new Date()).Format("yyyy-MM-dd hh:mm:ss");
     var params = {
       patentId:obj.patentId,
       appKey:"gongsibao",
       currentTime:currentT,
     };
     var originStr=params.currentTime+params.appKey+"d10c5fa8d0d41a56fd1390ad214898ed"
    +params.patentId;
     var token=md5(originStr);
     params.token=token;
     var rc=System.getObject("util.restClient");
     var data=querystring.stringify(params);
     var rtn=null;
     try{
       rtn=await rc.execPost2(data,reqUrl);
       return System.getResult2(JSON.parse(rtn.stdout).data,null);
     }catch(e){
       return rtn=System.getResult2(null,null);
     }
   };
}
module.exports=CompanyApi;
// var capi=new CompanyApi();
// capi.entsearch({appKey:cyjAppKey,companyName:"大圣",currentPage:1,pageSize:10}).then(function(result){
//   console.log((result));
// }).catch(function(e){
//   console.log(e);
// });
