var System = require("../../system")
const http = require("http")
const querystring = require('querystring');
const md5 = require("MD5");
const uuidv4 = require('uuid/v4');
//const cyjAppKey="ccb00829347e4048833af213e502c8c5";
var settings = require("../../../config/settings");
/**
 * 渠道接入，接收提报数据
 */
class ChannelAccessApi {
  constructor() {
    this.orderSve = System.getObject("service.orderSve");
    this.userSve = System.getObject("service.userSve");
    this.appSve = System.getObject("service.appSve");
    this.channelSve = System.getObject("service.channelSve");
  };
  async getUidStr(len, radix) {
    var chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.split('');
    var uuid = [],
      i;
    radix = radix || chars.length;
    if (len) {
      for (i = 0; i < len; i++) uuid[i] = chars[0 | Math.random() * radix];
    } else {
      var r;
      uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
      uuid[14] = '4';
      for (i = 0; i < 36; i++) {
        if (!uuid[i]) {
          r = 0 | Math.random() * 16;
          uuid[i] = chars[(i == 19) ? (r & 0x3) | 0x8 : r];
        }
      }
    }
    return uuid.join('');
  }
  async checkAndLogin(obj, channelCode, app) {
    if (!obj || !obj.channelUserId) {
      return { code: -1, msg: "未知渠道用户" };
    }
    if (!channelCode) {
      return { code: -2, msg: "渠道编码错误" };
    }
    var app = await this.appSve.dao.model.findOne({
      where: { appid: "2e787bbaacda4c6488b9fae58fff30ba", isEnabled: 1 },
      raw: true
    });
    if (!app || !app.id) {
      return { code: -100, msg: "未知应用" };
    }
    var openid = channelCode + "_" + obj.channelUserId;
    var user = await this.userSve.dao.model.findOne({
      where:{
        openid:openid,app_id:app.id
      },
      raw:true
    });
    if (!user) {
      var name = await this.getUidStr(8, 62);
      user = {
        app_id: app.id,//应用id
        nickName: obj.nickname || obj.channelUserName || name,
        openId: openid,
        unionId: openid,
        onlyCode: openid,
        mobile: obj.channelUserMobile || "",
        userName: obj.channelUserName || obj.nickname || name,
        headUrl: "",
        appKey: "2e787bbaacda4c6488b9fae58fff30ba"
      };
      user["description"] = "渠道接入_自动提报";
      await this.userSve.loginWithoutGift(user);
      // user = await this.userSve.getUserByOpenId(openid, "2e787bbaacda4c6488b9fae58fff30ba");
      user = await this.userSve.dao.model.findOne({
        where:{
          openid:openid,app_id:app.id
        },
        raw:true
      });
    }
    return { code: 1, data: user };
  };
  async getUserInfo(obj, channelCode) {
    var openid = channelCode + "_" + obj.channelUserId;
    var app = await this.appSve.dao.model.findOne({
      where: { appid: "2e787bbaacda4c6488b9fae58fff30ba", isEnabled: 1 },
      raw: true
    });
    if (!app || !app.id) {
      return { code: -100, msg: "未知应用" };
    }
    // var user = await this.userSve.getUserByOpenId(openid, "2e787bbaacda4c6488b9fae58fff30ba");
    var user = await this.userSve.dao.model.findOne({
      where:{
        openid:openid,app_id:app.id
      },
      raw:true
    });
    return user;
  };
  //渠道商标方案确认
  async channelTmConfirm(pobj, obj) {
    var channelCode = obj.channelCode;
    var channelUserId = obj.channelUserId;
    if (!channelCode) {
      return { code: -1, msg: "channelCode参数错误" };
    }
    if (!channelUserId) {
      return { code: -2, msg: "channelUserId参数错误" };
    }
    try {
      var app = await this.appSve.dao.model.findOne({
        where: { appid: "2e787bbaacda4c6488b9fae58fff30ba", isEnabled: 1 },
        raw: true
      });
      if (app) {
        obj["app"] = app
      } else {
        return { code: -100, msg: "未知应用" };
      }
      var channel = await this.channelSve.getChannelItem(channelCode);
      if (channel) {
        obj["channel"] = channel
      } else {
        return { code: -101, msg: "未知渠道" };
      }
      // var user = await this.getUserInfo({channelUserId:channelUserId},channelCode);
      // if(user){
      //   obj["user"]=user;
      // }else{
      //   return {code:-102,msg:"未知用户"};
      // }
      return await this.orderSve.channelTmConfirm(obj);
    } catch (e) {
      return { code: -200, msg: "操作失败", err: e.stack };
    }
  }
  //商标自动提报(渠道)
  async createChannelOrder(pobj, obj) {
    var channelUser = obj.channelUser;
    var channelCode = obj.channelCode;
    if (!channelCode) {
      return { code: -1, msg: "channelCode参数错误" };
    }
    try {
      var app = await this.appSve.dao.model.findOne({
        where: { appid: "2e787bbaacda4c6488b9fae58fff30ba", isEnabled: 1 },
        raw: true
      });
      if (app) {
        obj["app"] = app
      } else {
        return { code: -100, msg: "未知应用" };
      }
      var channel = await this.channelSve.getChannelItem(channelCode);
      if (channel) {
        obj["channel"] = channel
      } else {
        return { code: -101, msg: "未知渠道" };
      }
      var userRes = await this.checkAndLogin(channelUser, channelCode, app);
      if (!userRes || userRes.code != 1) {
        return { code: -102, msg: "未知用户" };
      } else {
        obj["user"] = userRes.data;
      }
      return await this.orderSve.createChannelOrder(obj);
    } catch (e) {
      return { code: -200, msg: "操作失败", err: e.stack };
    }
  }
  //修改商标订单-商标信息修改
  async updateChannelTmInfo(pobj, obj) {
    var channelCode = obj.channelCode;
    var channelUserId = obj.channelUserId;
    if (!channelCode) {
      return { code: -1, msg: "channelCode参数错误" };
    }
    if (!channelUserId) {
      return { code: -2, msg: "channelUserId参数错误" };
    }
    try {
      var app = await this.appSve.dao.model.findOne({
        where: { appid: "2e787bbaacda4c6488b9fae58fff30ba", isEnabled: 1 },
        raw: true
      });
      if (app) {
        obj["app"] = app
      } else {
        return { code: -100, msg: "未知应用" };
      }
      var channel = await this.channelSve.getChannelItem(channelCode);
      if (channel) {
        obj["channel"] = channel
      } else {
        return { code: -101, msg: "未知渠道" };
      }
      // var userRes = await this.checkAndLogin({channelUserId:channelUserId},channelCode,app);
      // if(!userRes || userRes.code!=1){
      //   return {code:-102,msg:"未知用户"};
      // }else{
      //   obj["user"]=userRes.data;
      // }
      var user = await this.getUserInfo({ channelUserId: channelUserId }, channelCode);
      if (user) {
        obj["user"] = user;
      } else {
        return { code: -102, msg: "未知用户" };
      }
      return await this.orderSve.updateChannelTmInfo(obj);
    } catch (e) {
      return { code: -200, msg: "操作失败", err: e.stack };
    }
  }
  //商标订单-商标尼斯信息
  async updateChannelNclInfo(pobj, obj) {
    var channelCode = obj.channelCode;
    var channelUserId = obj.channelUserId;
    if (!channelCode) {
      return { code: -1, msg: "channelCode参数错误" };
    }
    if (!channelUserId) {
      return { code: -2, msg: "channelUserId参数错误" };
    }
    try {
      var app = await this.appSve.dao.model.findOne({
        where: { appid: "2e787bbaacda4c6488b9fae58fff30ba", isEnabled: 1 },
        raw: true
      });
      if (app) {
        obj["app"] = app
      } else {
        return { code: -100, msg: "未知应用" };
      }
      var channel = await this.channelSve.getChannelItem(channelCode);
      if (channel) {
        obj["channel"] = channel
      } else {
        return { code: -101, msg: "未知渠道" };
      }
      // var userRes = await this.checkAndLogin({channelUserId:channelUserId},channelCode,app);
      // if(!userRes || userRes.code!=1){
      //   return {code:-102,msg:"未知用户"};
      // }else{
      //   obj["user"]=userRes.data;
      // }
      var user = await this.getUserInfo({ channelUserId: channelUserId }, channelCode);
      if (user) {
        obj["user"] = user;
      } else {
        return { code: -102, msg: "未知用户" };
      }
      return await this.orderSve.updateChannelNclInfo(obj);
    } catch (e) {
      return { code: -200, msg: "操作失败", err: e.stack };
    }
  }
  //修改商标订单-修改商标交付单联系人
  async updateChannelContacts(pobj, obj) {
    var channelCode = obj.channelCode;
    var channelUserId = obj.channelUserId;
    if (!channelCode) {
      return { code: -1, msg: "channelCode参数错误" };
    }
    if (!channelUserId) {
      return { code: -2, msg: "channelUserId参数错误" };
    }
    try {
      var app = await this.appSve.dao.model.findOne({
        where: { appid: "2e787bbaacda4c6488b9fae58fff30ba", isEnabled: 1 },
        raw: true
      });
      if (app) {
        obj["app"] = app
      } else {
        return { code: -100, msg: "未知应用" };
      }
      var channel = await this.channelSve.getChannelItem(channelCode);
      if (channel) {
        obj["channel"] = channel
      } else {
        return { code: -101, msg: "未知渠道" };
      }
      // var userRes = await this.checkAndLogin({channelUserId:channelUserId},channelCode,app);
      // if(!userRes || userRes.code!=1){
      //   return {code:-102,msg:"未知用户"};
      // }else{
      //   obj["user"]=userRes.data;
      // }
      var user = await this.getUserInfo({ channelUserId: channelUserId }, channelCode);
      if (user) {
        obj["user"] = user;
      } else {
        return { code: -102, msg: "未知用户" };
      }
      return await this.orderSve.updateChannelContacts(obj);
    } catch (e) {
      return { code: -200, msg: "操作失败", err: e.stack };
    }
  }

  //修改商标订单-修改申请人信息
  async updateChannelCustomerInfo(pobj, obj) {
    var channelCode = obj.channelCode;
    var channelUserId = obj.channelUserId;
    if (!channelCode) {
      return { code: -1, msg: "channelCode参数错误" };
    }
    if (!channelUserId) {
      return { code: -2, msg: "channelUserId参数错误" };
    }
    try {
      var app = await this.appSve.dao.model.findOne({
        where: { appid: "2e787bbaacda4c6488b9fae58fff30ba", isEnabled: 1 },
        raw: true
      });
      if (app) {
        obj["app"] = app
      } else {
        return { code: -100, msg: "未知应用" };
      }
      var channel = await this.channelSve.getChannelItem(channelCode);
      if (channel) {
        obj["channel"] = channel
      } else {
        return { code: -101, msg: "未知渠道" };
      }
      // var userRes = await this.checkAndLogin({channelUserId:channelUserId},channelCode,app);
      // if(!userRes || userRes.code!=1){
      //   return {code:-102,msg:"未知用户"};
      // }else{
      //   obj["user"]=userRes.data;
      // }
      var user = await this.getUserInfo({ channelUserId: channelUserId }, channelCode);
      if (user) {
        obj["user"] = user;
      } else {
        return { code: -102, msg: "未知用户" };
      }
      return await this.orderSve.updateChannelCustomerInfo(obj);
    } catch (e) {
      return { code: -200, msg: "操作失败", err: e.stack };
    }
  }

  //修改商标订单-修改交官文件
  async updateChannelOfficial(pobj, obj) {
    var channelCode = obj.channelCode;
    var channelUserId = obj.channelUserId;
    if (!channelCode) {
      return { code: -1, msg: "channelCode参数错误" };
    }
    if (!channelUserId) {
      return { code: -2, msg: "channelUserId参数错误" };
    }
    try {
      var app = await this.appSve.dao.model.findOne({
        where: { appid: "2e787bbaacda4c6488b9fae58fff30ba", isEnabled: 1 },
        raw: true
      });
      if (app) {
        obj["app"] = app
      } else {
        return { code: -100, msg: "未知应用" };
      }
      var channel = await this.channelSve.getChannelItem(channelCode);
      if (channel) {
        obj["channel"] = channel
      } else {
        return { code: -101, msg: "未知渠道" };
      }
      // var userRes = await this.checkAndLogin({channelUserId:channelUserId},channelCode,app);
      // if(!userRes || userRes.code!=1){
      //   return {code:-102,msg:"未知用户"};
      // }else{
      //   obj["user"]=userRes.data;
      // }
      var user = await this.getUserInfo({ channelUserId: channelUserId }, channelCode);
      if (user) {
        obj["user"] = user;
      } else {
        return { code: -102, msg: "未知用户" };
      }
      return await this.orderSve.updateChannelOfficial(obj);
    } catch (e) {
      return { code: -200, msg: "操作失败", err: e.stack };
    }
  }

  //修改商标订单-修改支付状态------------------用于渠道更新支付状态
  async updateChannelPayStatus(pobj, obj) {
    var channelCode = obj.channelCode;
    var channelUserId = obj.channelUserId;
    if (!channelCode) {
      return { code: -1, msg: "channelCode参数错误" };
    }
    if (!channelUserId) {
      return { code: -2, msg: "channelUserId参数错误" };
    }
    if (!obj.appid) {
      return { code: -3, msg: "appid参数错误" };
    }
    try {
      var app = await this.appSve.dao.model.findOne({
        where: { appid: obj.appid, isEnabled: 1 },
        raw: true
      });
      if (app) {
        obj["app"] = app
      } else {
        return { code: -100, msg: "未知应用" };
      }
      var channel = await this.channelSve.getChannelItem(channelCode);
      if (channel) {
        obj["channel"] = channel
      } else {
        return { code: -101, msg: "未知渠道" };
      }
      // var userRes = await this.checkAndLogin({channelUserId:channelUserId},channelCode,app);
      // if(!userRes || userRes.code!=1){
      //   return {code:-102,msg:"未知用户"};
      // }else{
      //   obj["user"]=userRes.data;
      // }
      var user = await this.getUserInfo({ channelUserId: channelUserId }, channelCode);
      if (user) {
        obj["user"] = user;
      } else {
        return { code: -102, msg: "未知用户" };
      }
      return await this.orderSve.updateChannelPayStatus(obj);
    } catch (e) {
      return { code: -200, msg: "操作失败", err: e.stack };
    }
  }
}
module.exports = ChannelAccessApi;