#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Time    : 2020/4/10 0010 14:41
# @Author  : guopeng
# @File    : logo_msg.py
# @Software: PyCharm Community Edition

from flask import Flask, render_template, request
import json
import pymysql,sys,os
from flask_cors import CORS
import LogoManage
import GetLogo
import CreateScene


# 服务器接口API
interface_path = os.path.dirname(__file__)
sys.path.insert(0, interface_path)  # 将当前文件的父目录加入临时系统变量
app = Flask(__name__)
@app.route('/api/singlelogo', methods = ['POST'])
def SingleLogoApi():#获取单个logo
    try:
        title = ""
        subtitle = ""
        profession = ""
        description = ""
        if "title" in request.get_json() and request.get_json().get("title"):
            title= request.get_json().get("title")
        if "subtitle" in request.get_json() and request.get_json().get("subtitle"):
            subtitle = request.get_json().get("subtitle")
        if "profession" in request.get_json() and request.get_json().get("profession"):
            profession = request.get_json().get("profession")
        if "description" in request.get_json() and request.get_json().get("description"):
            description = request.get_json().get("description")
        curpage =1
        pagesize =10
        if "curpage" in request.get_json() and request.get_json().get("curpage"):
            curpage = request.get_json().get("curpage")
        if "pagesize" in request.get_json() and request.get_json().get("pagesize"):
            pagesize = request.get_json().get("pagesize")

        if not title or not profession:
            return json.dumps({"status": -1, "msg": "参数不正确", "data": {}}, ensure_ascii=False)
        else:
            inputdata = {"title":title,"subtitle":subtitle,"profession":profession,"description":description}
            #调用获取LOGO信息方法，返回LOGO信息
            isSuccess,logocount,logoinfo = LogoManage.ReturnLogoInfo(inputdata,curpage,pagesize)
            if (isSuccess and logocount):
                info_list = []
                for info in logoinfo:
                    info_list.append({
                        "id": info["id"],
                        "title": info["title"],
                        "subtitle": info["subtitle"],
                        # "description":info["description"],
                        "first_color": info["first_color"],
                        "sec_color": info["sec_color"],
                        "color_description": info["color_description"],
                        #"font_name": info["font_name"],
                        "font_description": "\"" +info["title"] + "\"选用\"" + str(info["font_name"]).
                            replace(".TTF","").replace(".ttf","").replace(".otf","").replace("字体","") + "\"字体，"+ info["font_description"],
                        "pic_url": info["pic_url"]
                     })
                return json.dumps({"status": 0, "msg": "成功", "total":logocount,"data": info_list}, ensure_ascii=False)
            else:
                return json.dumps({"status": -1, "msg": "返回数据出错", "total":0, "data": {}}, ensure_ascii=False)
    except:
        return json.dumps({"status": -1, "msg":"调用服务出错", "total":0,"data": {}}, ensure_ascii=False)

@app.route('/api/downloadlogo', methods = ['POST'])
def DownloadLogoApi():#下载logo
    try:
        id = -1
        title = ""
        subtitle = ""
        if "id" in request.get_json().keys() and request.get_json().get("id"):
            id = request.get_json().get("id")
        if "title" in request.get_json().keys() and request.get_json().get("title"):
            title= request.get_json().get("title")
        if "subtitle" in request.get_json().keys() and request.get_json().get("subtitle"):
            subtitle = request.get_json().get("subtitle")
        if not title or not id:
            return json.dumps({"status": -1, "msg": "参数错误", "data": {}}, ensure_ascii=False)
        else:
            inputdata = {"id": id, "title": title, "subtitle": subtitle}
            istrue, pic_all = GetLogo.getLogoUrl(inputdata)
            if istrue:
                return json.dumps({"status": 0, "msg": "成功", "data": pic_all}, ensure_ascii=False)
            else:
                return json.dumps({"status": -1, "msg": "生成图像出错", "data": {}}, ensure_ascii=False)
    except Exception as e:
        return json.dumps({"status": -1, "msg":"调用服务出错","data": {}}, ensure_ascii=False)

@app.route('/api/changelogo', methods = ['POST'])
def ChangeABatchApi():#换一批
    try:
        title = ""
        subtitle = ""
        profession = ""
        description = ""
        if "title" in request.get_json() and request.get_json().get("title"):
            title= request.get_json().get("title")
        if "subtitle" in request.get_json() and request.get_json().get("subtitle"):
            subtitle = request.get_json().get("subtitle")
        if "profession" in request.get_json() and request.get_json().get("profession"):
            profession = request.get_json().get("profession")
        if "description" in request.get_json() and request.get_json().get("description"):
            description = request.get_json().get("description")

        if not title or not profession:
            return json.dumps({"status": -1, "msg": "参数不正确", "data": {}}, ensure_ascii=False)
        else:
            inputdata = {"title":title,"subtitle":subtitle,"profession":profession,"description":description}
            #调用获取LOGO信息方法，返回LOGO信息
            isSuccess,logocount,logoinfo = LogoManage.ChangeABatch(inputdata)
            if (isSuccess and logocount):
                info_list = []
                for info in logoinfo:
                    info_list.append({
                        "id": info["id"],
                        "title": info["title"],
                        "subtitle": info["subtitle"],
                        # "description":info["description"],
                        "first_color": info["first_color"],
                        "sec_color": info["sec_color"],
                        "color_description": info["color_description"],
                        #"font_name": info["font_name"],
                        "font_description": "\"" +info["title"] + "\"选用\"" + str(info["font_name"]).
                            replace(".TTF","").replace(".ttf","").replace(".otf","").replace("字体","") + "\"字体，"+ info["font_description"],
                        "pic_url": info["pic_url"]
                     })
                return json.dumps({"status": 0, "msg": "成功", "total":logocount,"data": info_list}, ensure_ascii=False)
            else:
                return json.dumps({"status": -1, "msg": "返回数据出错", "total":0, "data": {}}, ensure_ascii=False)
    except:
        return json.dumps({"status": -1, "msg":"调用服务出错", "total":0,"data": {}}, ensure_ascii=False)

@app.route('/api/downloadscene', methods = ['POST'])
def DownloadSceneApi():#得到场景信息
    try:
        id = -1
        title = ""
        subtitle = ""
        if "id" in request.get_json().keys() and request.get_json().get("id"):
            id = request.get_json().get("id")
        if "title" in request.get_json().keys() and request.get_json().get("title"):
            title = request.get_json().get("title")
        if "subtitle" in request.get_json().keys() and request.get_json().get("subtitle"):
            subtitle = request.get_json().get("subtitle")
        if not title or not id:
            return json.dumps({"status": -1, "msg": "参数错误", "data": {}}, ensure_ascii=False)
        else:
            inputdata = {"id": id, "title": title, "subtitle": subtitle}
            istrue, pic_all = CreateScene.sceneservers(inputdata)
            if istrue:
                return json.dumps({"status": 0, "msg": "成功", "data": pic_all}, ensure_ascii=False)
            else:
                return json.dumps({"status": -1, "msg": "生成图像出错", "data": []}, ensure_ascii=False)
    except Exception as e:
        return json.dumps({"status": -1, "msg": "调用服务出错", "data": []}, ensure_ascii=False)


@app.route('/api/createlogo', methods = ['POST'])#生成单个logo服务
def CreateLogoApi():#得到场景信息
    try:
        type = ""
        title = ""
        font_url = ""
        first_color = ""
        textpos = ""
        subtitle = ""
        sec_color = ""
        log_url = ""
        logo_id = 0
        if "type" in request.get_json().keys() and request.get_json().get("type"):
            type = request.get_json().get("type")
        if "title" in request.get_json().keys() and request.get_json().get("title"):
            title = request.get_json().get("title")
        if "subtitle" in request.get_json().keys() and request.get_json().get("subtitle"):
            subtitle = request.get_json().get("subtitle")
        if "font_url" in request.get_json().keys() and request.get_json().get("font_url"):
            font_url = request.get_json().get("font_url")
        if "first_color" in request.get_json().keys() and request.get_json().get("first_color"):
            first_color = request.get_json().get("first_color")
        if "textpos" in request.get_json().keys() and request.get_json().get("textpos"):
            textpos = request.get_json().get("textpos")
        if "sec_color" in request.get_json().keys() and request.get_json().get("sec_color"):
            sec_color = request.get_json().get("sec_color")
        if "log_url" in request.get_json().keys() and request.get_json().get("log_url"):
            log_url = request.get_json().get("log_url")
        if "logo_id" in request.get_json().keys() and request.get_json().get("logo_id"):
            logo_id = request.get_json().get("logo_id")

        inputdata = {
            "type": type,
            "title": title,
            "subtitle": subtitle,
            "font_url": font_url,
            "first_color": first_color,
            "textpos": textpos,
            "sec_color": sec_color,
            "log_url": log_url,
            "logo_id": logo_id
        }
        istrue, pic_url = LogoManage.SaveSingleLogo(inputdata)
        if istrue:
            return json.dumps({"status": 0, "msg": "成功", "data": pic_url}, ensure_ascii=False)
        else:
            return json.dumps({"status": -1, "msg": "生成图像出错", "data": ""}, ensure_ascii=False)
    except:
        return json.dumps({"status": -1, "msg": "调用服务出错", "data": ""}, ensure_ascii=False)


if __name__ == '__main__':
    CORS(app, supports_credentials=True)#允许跨域
    app.run(host='0.0.0.0', port=80, debug=True)
    #app.run(host='127.0.0.1', port=5000, debug=True)

