#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Time    : 2020-05-03 11:07
# @Author  : zhangyunfei
# @File    : customizelogosmall.py
# @Software: PyCharm

import os, random, time, oss2
from PIL import Image, ImageDraw, ImageFont
from LogoUtil import put2oss, add_watermark,alpha2white,downlogo_path,downlogo
from LogoTemplatesmall import tenplateGenerator
'''
    实现自定义模板生成logo
'''
width, height = 380, 280

# 实现竖排字体
def vertical_template(brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
    logo_image = Image.new('RGB', (width, height), (255, 255, 255))
    draw = ImageDraw.Draw(logo_image)
    # 获取品牌语font的大小
    brand_width, brand_height = brand_font.getsize(brand_text)
    # print('品牌语字体大小:', brand_width, brand_height)
    # 获取标语font的大小
    slogan_width, slogan_height = slogan_font.getsize(slogan_text)
    # print('标语字体大小:', slogan_width, slogan_height)
    # 获取宽度
    text_width = brand_height + slogan_height
    # 品牌语开始位置
    brand_width_start = 190 - int((brand_height + slogan_height) / 2)
    brand_h = 0
    for ch in brand_text:
        ch_width, ch_height = brand_font.getsize(ch)
        brand_h += ch_height
    brand_height_start = 140 - int(brand_h / 2)
    # 标语开始位置
    slogan_h = 0
    for ch in slogan_text:
        ch_width, ch_height = slogan_font.getsize(ch)
        slogan_h += ch_height
    slogan_width_start = brand_width_start + brand_height
    slogan_height_start = 140 - int(slogan_h / 2)

    # draw.line((brand_width_start,brand_height_start,brand_width_start+200,brand_height_start),fill=(255,255,255),width=3)
    # draw.line((brand_width_start, brand_height_start, brand_width_start + 200, brand_height_start),
    #           fill=(255, 255, 255), width=3)

    # 开始书写品牌语
    brand_down = 0
    for ch in brand_text:
        ch_width, ch_height = brand_font.getsize(ch)
        # print(ch_width)
        draw.text((brand_width_start + int(brand_height / 2) - int(ch_width / 2), brand_height_start + brand_down), ch,
                  brand_color, brand_font)
        brand_down += ch_height

    # 开始书写标语
    slogan_down = 0
    for ch in slogan_text:
        ch_width, ch_height = slogan_font.getsize(ch)
        draw.text((slogan_width_start + int(slogan_height / 2) - int(ch_width / 2), slogan_height_start + slogan_down),
                  ch, slogan_color, slogan_font)
        slogan_down += ch_height
    # print(slogan_down)
    # logo_image_new = add_watermark(logo_image, 'www.gongsibao.com')
    # logo_image_new.show()
    return logo_image


# 实现品牌语被矩形框包围
def rectangle_template(brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
    logo_image = Image.new('RGB', (width, height), (255, 255, 255))
    draw = ImageDraw.Draw(logo_image)
    # 品牌语整体的长宽
    brand_width, brand_height = brand_font.getsize(brand_text)
    # 标语的宽高
    slogan_width, slogan_height = slogan_font.getsize(slogan_text)
    # 获取品牌语单个字符的宽度
    brand_w = 0
    for ch in brand_text:
        ch_width, ch_height = brand_font.getsize(ch)
        # print(ch_width, ch_height, brand_height)
        brand_w += ch_width
    # 品牌语开始位置
    brand_width_start = 190 - int(brand_w / 2)
    brand_height_start = 140 - int((brand_height + slogan_height) / 2)
    # 标语开始位置
    slogan_width_start = 190 - int(slogan_width / 2)
    slogan_height_start = brand_height_start + brand_height
    move_w = 0
    for i, ch in enumerate(brand_text):
        ch_width, ch_height = brand_font.getsize(ch)
        draw.text((brand_width_start + move_w, brand_height_start), ch, brand_color, brand_font)
        if i == 0:
            draw.rectangle((brand_width_start + move_w, brand_height_start, brand_width_start + move_w + ch_width,
                            brand_height_start + brand_height), outline='black', width=1)
        else:
            draw.rectangle((brand_width_start + move_w + 2, brand_height_start, brand_width_start + move_w + ch_width,
                            brand_height_start + brand_height), outline='black', width=1)

        move_w += ch_width

    draw.text((slogan_width_start, slogan_height_start), slogan_text, slogan_color, slogan_font)
    # logo_image_new = add_watermark(logo_image, 'www.gongsibao.com')
    # logo_image_new.show()
    return logo_image


# 实现logo被矩形颜色框包围(涉及半透明图像alpha通道)
def rectanglecolor_template(brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
    logo_image = Image.new('RGB', (width, height), (255, 255, 255))
    draw = ImageDraw.Draw(logo_image)
    # 品牌语整体的长宽
    brand_width, brand_height = brand_font.getsize(brand_text)
    # 标语的宽高
    slogan_width, slogan_height = slogan_font.getsize(slogan_text)
    # 品牌语开始位置
    brand_width_start = 190 - int(brand_width / 2)
    brand_height_start = 140 - int((brand_height + slogan_height) / 2)
    # 标语开始位置
    slogan_width_start = 190 - int(slogan_width / 2)
    slogan_height_start = brand_height_start + brand_height

    # 找出长度最大的文本
    w_max = max(brand_width, slogan_width)

    draw.text((brand_width_start, brand_height_start), brand_text, brand_color, brand_font)
    draw.text((slogan_width_start, slogan_height_start), slogan_text, slogan_color, slogan_font)

    # 新定一个带alpha通道的图像，画两个矩形
    # 矩形一位置
    rec_x = 190 - int(w_max / 2)
    rec_y = 140 - int((brand_height + slogan_height) / 2)
    alpha_logo = Image.new('RGB', (width, height), (255, 255, 255)).convert('RGBA')
    alpha_draw = ImageDraw.Draw(alpha_logo)
    # 画透明矩形
    alpha_draw.rectangle((rec_x - 10, rec_y - 10, rec_x + w_max,
                          rec_y + brand_height + slogan_height), fill=(173, 177, 185, 50))
    alpha_draw.rectangle((rec_x, rec_y, rec_x + w_max + 10,
                          rec_y + brand_height + slogan_height + 10), fill=(173, 177, 185, 120))
    # 将两个图像融合的结果
    final = Image.new("RGBA", (width, height))  # 合成的image
    final = Image.alpha_composite(final, logo_image.convert('RGBA'))
    final = Image.alpha_composite(final, alpha_logo)
    final = final.convert('RGB')
    # final.show()
    # logo_image_new = add_watermark(final, 'www.gongsibao.com')
    # logo_image_new.show()
    # final.save('image_mask.jpg')
    return final


# 实现对角线对角样式
def cornerline_template(brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
    logo_image = Image.new('RGB', (width, height), (255, 255, 255))
    draw = ImageDraw.Draw(logo_image)
    # 品牌语整体的长宽
    brand_width, brand_height = brand_font.getsize(brand_text)
    # 标语的宽高
    slogan_width, slogan_height = slogan_font.getsize(slogan_text)
    # 品牌语开始位置
    brand_width_start = 190 - int(brand_width / 2)
    brand_height_start = 140 - int((brand_height + slogan_height) / 2)
    # 标语开始位置
    slogan_width_start = 190 - int(slogan_width / 2)
    slogan_height_start = brand_height_start + brand_height

    # 找出长度最大的文本
    w_max = max(brand_width, slogan_width)

    draw.text((brand_width_start, brand_height_start), brand_text, brand_color, brand_font)
    draw.text((slogan_width_start, slogan_height_start), slogan_text, slogan_color, slogan_font)

    # 左上角开始位置

    left_x = 180 - int(w_max / 2)
    left_y = 130 - int((brand_height + slogan_height) / 2)
    # draw.line((left_x,left_y,left_x,left_y + 200),width=10,fill='green')
    # draw.line((left_x, left_y, left_x + 200, left_y ), width=10, fill='green')
    draw.rectangle((left_x, left_y, left_x + 2, left_y + 25), fill=(0, 0, 0))
    draw.rectangle((left_x, left_y, left_x + 25, left_y + 2), fill=(0, 0, 0))
    # 右下角开始位置
    right_x = 200 + int(w_max / 2)
    right_y = 150 + int((brand_height + slogan_height) / 2)
    # draw.line((right_x, right_y, right_x, right_y - 200), width=10, fill='green')
    # draw.line((right_x, right_y, right_x - 200, right_y), width=10, fill='green')
    draw.rectangle((right_x, right_y, right_x - 2, right_y - 25), fill=(0, 0, 0))
    draw.rectangle((right_x, right_y, right_x - 25, right_y - 2), fill=(0, 0, 0))

    # logo_image_new = add_watermark(logo_image, 'www.gongsibao.com')
    # logo_image_new.show()
    return logo_image


# 实现两个品字型的样式
def twopin_template(brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
    logo_image = Image.new('RGB', (width, height), (255, 255, 255))
    draw = ImageDraw.Draw(logo_image)
    # 品牌语整体的长宽
    brand_width, brand_height = brand_font.getsize(brand_text)
    # 标语的宽高
    slogan_width, slogan_height = slogan_font.getsize(slogan_text)
    # 品牌语开始位置
    brand_width_start = 190 - int(brand_width / 2)
    brand_height_start = 140 - int((brand_height + slogan_height) / 2)
    # 标语开始位置
    slogan_width_start = 190 - int(slogan_width / 2)
    slogan_height_start = brand_height_start + brand_height

    # 找出长度最大的文本
    w_max = max(brand_width, slogan_width)

    draw.text((brand_width_start, brand_height_start), brand_text, brand_color, brand_font)
    draw.text((slogan_width_start, slogan_height_start), slogan_text, slogan_color, slogan_font)

    # 左边开始位置
    left_x = 180
    left_y = brand_height_start - 35
    # 矩形宽
    rect_w = 4
    # 画竖矩形
    draw.rectangle((left_x - 10, left_y + 2, left_x + 10 + rect_w, left_y + 2 + rect_w), fill=(0, 0, 0))  # 顶部矩形
    draw.rectangle((left_x - 10, left_y + 2, left_x - 10 + rect_w, left_y + 15), fill=(0, 0, 0))  # 上左矩形
    draw.rectangle((left_x + 10, left_y + 2, left_x + 10 + rect_w, left_y + 15), fill=(0, 0, 0))  # 上右矩形

    draw.rectangle((left_x - 20, left_y + 15, left_x - 10 + rect_w, left_y + 15 + rect_w), fill=(0, 0, 0))  # 上左下矩形
    draw.rectangle((left_x + 10, left_y + 15, left_x + 20 + rect_w, left_y + 15 + rect_w), fill=(0, 0, 0))  # 上右下矩形

    draw.rectangle((left_x - 20, left_y + 15, left_x - 20 + rect_w, left_y + 25), fill=(0, 0, 0))  # 上左下左矩形
    draw.rectangle((left_x + 20, left_y + 15, left_x + 20 + rect_w, left_y + 25), fill=(0, 0, 0))  # 上右下右矩形

    draw.rectangle((left_x, left_y + 2, left_x + rect_w, left_y + 25), fill=(0, 0, 0))  # 中间矩形
    draw.rectangle((left_x - 20, left_y + 25, left_x + 20 + rect_w, left_y + 25 + rect_w), fill=(0, 0, 0))  # 底部矩形
    # 左边矩形，中间为空
    draw.rectangle((left_x - 30, left_y - 4, left_x - 14, left_y + 12), outline='black',width=4)
    draw.rectangle((left_x + 18, left_y - 4, left_x + 34, left_y + 12), outline='black',width=4)

    # draw.rectangle((left_x, left_y, left_x + 200, left_y + 10), fill=(0, 0, 0))
    # 右下角开始位置
    # right_x = 1050 + int(w_max / 2)
    # right_y = 1050 + int((brand_height + slogan_height) / 2)
    # # draw.line((right_x, right_y, right_x, right_y - 200), width=10, fill='green')
    # # draw.line((right_x, right_y, right_x - 200, right_y), width=10, fill='green')
    # draw.rectangle((right_x, right_y, right_x - 10, right_y - 200), fill=(0, 0, 0))
    # draw.rectangle((right_x, right_y, right_x - 200, right_y - 10), fill=(0, 0, 0))
    # logo_image.show()
    return logo_image


# 实现线条半包围logo字体
def line_template(brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
    logo_image = Image.new('RGB', (width, height), (255, 255, 255))
    draw = ImageDraw.Draw(logo_image)
    # 品牌语整体的长宽
    brand_width, brand_height = brand_font.getsize(brand_text)
    # 标语的宽高
    slogan_width, slogan_height = slogan_font.getsize(slogan_text)
    # 品牌语开始位置
    brand_width_start = 190 - int(brand_width / 2)
    brand_height_start = 140 - int((brand_height + slogan_height) / 2)
    # 标语开始位置
    slogan_width_start = 190 - int(slogan_width / 2)
    slogan_height_start = brand_height_start + brand_height

    # 找出长度最大的文本
    w_max = max(brand_width, slogan_width)

    draw.text((brand_width_start, brand_height_start), brand_text, brand_color, brand_font)
    draw.text((slogan_width_start, slogan_height_start), slogan_text, slogan_color, slogan_font)

    # 左上角开始位置
    left_x = 180 - int(w_max / 2)
    left_y = 125 - int((brand_height + slogan_height) / 2)
    left_y_bottom = 165 + int((brand_height + slogan_height) / 2)
    draw.rectangle((left_x, left_y, left_x + 1, left_y_bottom), fill=(0, 0, 0))
    draw.rectangle((left_x, left_y, left_x + 10 + int(w_max / 2), left_y + 1), fill=(0, 0, 0))
    draw.rectangle((left_x, left_y_bottom, left_x + +10 + int(w_max / 2), left_y_bottom + 1), fill=(0, 0, 0))
    draw.rectangle((left_x + 10 + int(w_max / 2), left_y, left_x + 10 + int(w_max / 2) + 1, left_y + 10),
                   fill=(0, 0, 0))
    draw.rectangle(
        (left_x + 10 + int(w_max / 2), left_y_bottom, left_x + 10 + int(w_max / 2) - 1, left_y_bottom - 10),
        fill=(0, 0, 0))
    # draw.rectangle((left_x, left_y_bottom, left_x + +100 + int(w_max / 2), left_y_bottom + 10), fill=(0, 0, 0))

    # 右下角开始位置
    # right_x = 1050 + int(w_max / 2)
    # right_y = 1050 + int((brand_height + slogan_height) / 2)
    # # draw.line((right_x, right_y, right_x, right_y - 200), width=10, fill='green')
    # # draw.line((right_x, right_y, right_x - 200, right_y), width=10, fill='green')
    # draw.rectangle((right_x, right_y, right_x - 10, right_y - 200), fill=(0, 0, 0))
    # draw.rectangle((right_x, right_y, right_x - 200, right_y - 10), fill=(0, 0, 0))

    # logo_image.show()
    return logo_image


# 实现竖排字体加上帽子
def verticalline_template(brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
    logo_image = Image.new('RGB', (width, height), (255, 255, 255))
    draw = ImageDraw.Draw(logo_image)
    # 获取品牌语font的大小
    brand_width, brand_height = brand_font.getsize(brand_text)
    # print('品牌语字体大小:', brand_width, brand_height)
    # 获取标语font的大小
    slogan_width, slogan_height = slogan_font.getsize(slogan_text)
    # print('标语字体大小:', slogan_width, slogan_height)
    # 获取宽度
    text_width = brand_height + slogan_height
    # 品牌语开始位置
    brand_width_start = 190 - int((brand_height + slogan_height) / 2)
    brand_h = 0
    for ch in brand_text:
        ch_width, ch_height = brand_font.getsize(ch)
        brand_h += ch_height
    brand_height_start = 140 - int(brand_h / 2)
    # 标语开始位置
    slogan_h = 0
    for ch in slogan_text:
        ch_width, ch_height = slogan_font.getsize(ch)
        slogan_h += ch_height
    slogan_width_start = brand_width_start + brand_height
    slogan_height_start = 140 - int(slogan_h / 2)

    # 开始书写品牌语
    brand_down = 0
    for ch in brand_text:
        ch_width, ch_height = brand_font.getsize(ch)
        draw.text((brand_width_start + int(brand_height / 2) - int(ch_width / 2), brand_height_start + brand_down), ch,
                  brand_color, brand_font)
        brand_down += ch_height
    # 开始书写标语
    slogan_down = 0
    for ch in slogan_text:
        ch_width, ch_height = slogan_font.getsize(ch)
        draw.text((slogan_width_start + int(slogan_height / 2) - int(ch_width / 2), slogan_height_start + slogan_down),
                  ch, slogan_color, slogan_font)
        slogan_down += ch_height

    # 帽子的坐标计算
    line_x = 190 - int((brand_height + slogan_height) / 2)
    line_y = 140 - int(max(slogan_down, brand_down) / 2)
    line_bottom_y = 140 + int(max(slogan_down, brand_down) / 2)
    # 上边帽子
    draw.rectangle((line_x - 3, line_y - 3, line_x + text_width + 3, line_y - 2), fill=(0, 0, 0))
    draw.rectangle((line_x - 3, line_y - 3, line_x - 2, line_y + 5), fill=(0, 0, 0))
    draw.rectangle((line_x + text_width + 2, line_y - 3, line_x + text_width + 3, line_y + 5), fill=(0, 0, 0))

    # 下边帽子
    draw.rectangle((line_x - 3, line_bottom_y + 3, line_x + text_width + 3, line_bottom_y + 4),
                   fill=(0, 0, 0))
    draw.rectangle((line_x - 3, line_bottom_y + 3, line_x - 2, line_bottom_y - 5), fill=(0, 0, 0))
    draw.rectangle((line_x + text_width + 2, line_bottom_y + 3, line_x + text_width + 3, line_bottom_y - 5),
                   fill=(0, 0, 0))

    # logo_image.show()
    return logo_image


# 实现一半文字被梯形包围
def polygon_right_template(brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
    logo_image = Image.new('RGB', (width, height), (255, 255, 255))
    draw = ImageDraw.Draw(logo_image)
    # 品牌语整体的长宽
    brand_width, brand_height = brand_font.getsize(brand_text)
    # 标语的宽高
    slogan_width, slogan_height = slogan_font.getsize(slogan_text)
    # 品牌语开始位置
    brand_width_start = 190 - int(brand_width / 2)
    brand_height_start = 140 - int((brand_height + slogan_height) / 2)
    # 标语开始位置
    slogan_width_start = 190 - int(slogan_width / 2)
    slogan_height_start = brand_height_start + brand_height
    # 找出长度最大的文本
    w_max = max(brand_width, slogan_width)

    # 左边开始位置坐标
    left_x = 190
    left_y = 140 - int((brand_height + slogan_height) / 2)
    left_y_bottom = 140 + int((brand_height + slogan_height) / 2)
    point1 = (left_x, left_y + 2)
    point2 = (left_x + int(w_max / 2) + 3, left_y - 2 - int((brand_height + slogan_height) / 4))
    point3 = (left_x + int(w_max / 2) + 3, left_y_bottom + 2 + int((brand_height + slogan_height) / 4))
    point4 = (left_x, left_y_bottom + 2)
    draw.polygon([point1, point2, point3, point4], fill=(255, 205, 67))
    draw.text((brand_width_start, brand_height_start), brand_text, brand_color, brand_font)
    draw.text((slogan_width_start, slogan_height_start), slogan_text, slogan_color, slogan_font)
    # logo_image.show()
    return logo_image


# 生成logo主函数
def gen_main(gen_json):
    # 创建生成图像存储路径
    if not os.path.exists('generatordir'):
        os.makedirs('generatordir')
    # 下载图标/图案路径
    if not os.path.exists('logodir'):
        os.makedirs('logodir')
    try:
        # logo名字
        logo_name = time.strftime('%Y%m%d%H%M%S') + str(random.randint(100, 10000)) + '.png'
        brand_text = gen_json['brand_text']
        brand_color_str = gen_json['brand_color']
        brand_color_list = brand_color_str.replace('(', '').replace(')', '').split(',')
        brand_color = (int(brand_color_list[0]), int(brand_color_list[1]), int(brand_color_list[2]))

        slogan_text = gen_json['slogan_text']
        slogan_color_str = gen_json['slogan_color']
        slogan_color_list = slogan_color_str.replace('(', '').replace(')', '').split(',')
        slogan_color = (int(slogan_color_list[0]), int(slogan_color_list[1]), int(slogan_color_list[2]))

        if len(brand_text) < 8:
            brand_size = 42
        else:
            brand_size = 30
        # brand_font = ImageFont.truetype('font/cn/SourceHanSansCN-Bold.otf', brand_size)
        brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
        # slogan_font = ImageFont.truetype(gen_json['slogan_font'], slogan_size)
        slogan_size = 15
        slogan_font = ImageFont.truetype("font/cn/微软vista雅黑.ttf", slogan_size)
        # 选择自定义模型的名称或者编号
        customize_model_id = gen_json['model_id']
        if customize_model_id == 1:  # 实现竖排字体,由于竖排文字需要对其文字大小限制
            if len(brand_text) < 7:
                brand_size = 42
                # brand_font = ImageFont.truetype('font/cn/华文行楷.ttf', brand_size)
                brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
            else:
                brand_size = 30
                # brand_font = ImageFont.truetype('font/cn/华文行楷.ttf', brand_size)
                brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
                slogan_size = 12
                slogan_font = ImageFont.truetype("font/cn/微软vista雅黑.ttf", slogan_size)
            gen_img = vertical_template(brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color)
        elif customize_model_id == 2:  # 实现品牌语被矩形框包围
            gen_img = rectangle_template(brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color)
        elif customize_model_id == 3:  # 实现logo被矩形颜色框包围(涉及半透明图像alpha通道)
            gen_img = rectanglecolor_template(brand_text, brand_font, brand_color, slogan_text, slogan_font,
                                              slogan_color)
        elif customize_model_id == 4:  # 实现对角线对角样式
            gen_img = cornerline_template(brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color)
        elif customize_model_id == 5:  # 实现两个品字型的样式
            gen_img = twopin_template(brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color)
        elif customize_model_id == 6:  # # 实现线条半包围logo字体
            gen_img = line_template(brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color)
        elif customize_model_id == 7:  # 实现竖排字体加上帽子
            if len(brand_text) < 7:
                brand_size = 42
                # brand_font = ImageFont.truetype('font/cn/华文行楷.ttf', brand_size)
                brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
            else:
                brand_size = 30
                # brand_font = ImageFont.truetype('font/cn/华文行楷.ttf', brand_size)
                brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
                slogan_size = 12
                slogan_font = ImageFont.truetype("font/cn/微软vista雅黑.ttf", slogan_size)
            gen_img = verticalline_template(brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color)
        elif customize_model_id == 8:  # 实现一半文字被梯形包围
            gen_img = polygon_right_template(brand_text, brand_font, brand_color, slogan_text, slogan_font,
                                             slogan_color)

        elif customize_model_id == 0:
            # 图标下载
            logo_url = gen_json['logo_url']
            # logo名字
            logo_name = time.strftime('%Y%m%d%H%M%S') + str(random.randint(100, 10000)) + '.png'
            logo_down_path = 'logodir/' + logo_name
            logo_down_result = downlogo(logo_down_path, logo_url)
            # 线上读取logo样式方法
            #logo_down_result = downlogo_path(logo_down_path, logo_url)  # downlogo_path(logo_down_path, logo_url)

            # 定义生成的图像接受对象
            if logo_down_result:
                lg_gen = tenplateGenerator()
                # 判断标语是否存在
                # logo_img = Image.open('data/template/6.png')
                logo_img = Image.open(logo_down_path)
                # location = [110, 93, 271, 187]
                location = [int(i) for i in gen_json['brand_location'].split(',')]
                brand_size = 40
                slogan_size = 16
                brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
                # brand_font = ImageFont.truetype('font/cn/汉仪秦川飞影.ttf', brand_size)
                slogan_font = ImageFont.truetype("font/cn/微软vista雅黑.ttf", slogan_size)
                brand_width, brand_height = brand_font.getsize(brand_text)
                # 获取标语font的大小
                slogan_width, slogan_height = slogan_font.getsize(slogan_text)
                # 空白区域的大小为
                location_width = location[2] - location[0]
                location_height = location[3] - location[1]
                # 生成文字的总长度和宽度为
                text_width = max(brand_width, slogan_width)
                text_height = brand_height + slogan_height
                flag = text_width < location_width  and text_height < location_height
                while not flag:
                    brand_size -= 1
                    slogan_size -= 1
                    if slogan_size<=12:
                        slogan_size=12
                    brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
                    # brand_font = ImageFont.truetype('font/cn/汉仪秦川飞影.ttf', brand_size)
                    slogan_font = ImageFont.truetype("font/cn/微软vista雅黑.ttf", slogan_size)
                    brand_width, brand_height = brand_font.getsize(brand_text)
                    # 获取标语font的大小
                    slogan_width, slogan_height = slogan_font.getsize(slogan_text)
                    # 空白区域的大小为
                    location_width = location[2] - location[0]
                    location_height = location[3] - location[1]
                    # 生成文字的总长度和宽度为
                    text_width = max(brand_width, slogan_width)
                    text_height = brand_height + slogan_height
                    # print('location:', location_width, location_height)
                    # print('text:', text_width, text_height)
                    flag = text_width < location_width and text_height < location_height

                # print(flag,'-----------------------------------------',brand_size,slogan_size)
                gen_img = lg_gen.generator(brand_text, brand_font, brand_color, location, slogan_text,
                                           slogan_font, slogan_color, alpha2white(logo_img))
        # 调用水印和版权图标
        gen_img_new = add_watermark(gen_img, 'www.gongsibao.com')
        gen_image_path = 'generatordir/' + 'generator_' + logo_name
        gen_img_new.save(gen_image_path)
        gen_img_new.show()
        # 上传阿里云oss
        mosaicurl = put2oss('generator_' + logo_name, gen_image_path)
        return {
            'status': 1,
            'image_gen_url': mosaicurl,
            'msg': 'success'
        }
    except Exception as e:
        print("模板------" + str(customize_model_id) + "------" + str(e))
        return {
            'status': 0,
            'image_gen_url': "",
            'msg': '出现异常：' + str(e)
        }


