#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Time    : 2020-05-07 19:16
# @Author  : zhangyunfei
# @File    : SceneGeneratorServer.py
# @Software: PyCharm
import flask, random, os, time
import cv2 as cv
import numpy as np
from PIL import Image, ImageDraw, ImageFont
from flask import request, jsonify
from LogoUtil import put2oss, downlogo_path,downlogo

server = flask.Flask(__name__)
server.config['JSON_AS_ASCII'] = False

'''
    将对应的logo应用到场景中，每个场景写成一个接口
'''
# ------------------------------生成器类------------开始
# #logo生成器，上下左右样式
class logoGenerator:

    def __init__(self):
        self.width = 380  # 生成logo的宽
        self.height = 280  # 生成logo的高
        # 生成空白logo图像，指定背景颜色和大小
        self.logo_gen_image = Image.new('RGBA', (self.width, self.height), (0, 0, 0, 0))

    # 品牌语和标语生成函数，该函数是品牌语和标语都存在的情况下使用
    def generator(self, brand_text, brand_font, brand_color, brand_location, slogan_text, slogan_font, slogan_color,
                  logo_img):
        # 定义画笔
        draw = ImageDraw.Draw(self.logo_gen_image)
        # 获取品牌语font的大小
        brand_width, brand_height = brand_font.getsize(brand_text)
        # print('品牌语字体大小:', brand_width, brand_height)
        # 获取标语font的大小
        slogan_width, slogan_height = slogan_font.getsize(slogan_text)
        # print('标语字体大小:', slogan_width, slogan_height)
        # 加载logo图样，首先放缩图样
        lg_im_resize = logo_img.resize((80, 80), Image.ANTIALIAS)
        # 判断图样与文字的位置
        if brand_location == '右':
            brand_x = 230 - int(brand_width / 2)
            brand_y = 140 - int((brand_height + slogan_height) / 2)
            # print('品牌语开始位置:', brand_x, brand_y)
            slogan_x = 230 - int(slogan_width / 2)
            slogan_y = brand_y + brand_height
            # print('标语开始位置:', slogan_x, slogan_y)
            # 书写文字
            draw.text((brand_x, brand_y), brand_text, brand_color, brand_font)
            draw.text((slogan_x, slogan_y), slogan_text, slogan_color, slogan_font)
            # 找出生成的标语和品牌语的起始位置最小的
            lg_w_x = min(brand_x, slogan_x)
            lg_w = lg_w_x - 80
            lg_h = 100
            self.logo_gen_image.paste(lg_im_resize, (lg_w, lg_h))
        elif brand_location == '左':
            brand_x = 150 - int(brand_width / 2)
            brand_y = 140 - int((brand_height + slogan_height) / 2)
            # print('品牌语开始位置:', brand_x, brand_y)
            slogan_x = 150 - int(slogan_width / 2)
            slogan_y = brand_y + brand_height
            # print('标语开始位置:', slogan_x, slogan_y)
            draw.text((brand_x, brand_y), brand_text, brand_color, brand_font)
            draw.text((slogan_x, slogan_y), slogan_text, slogan_color, slogan_font)
            # 找出生成的标语和品牌语的起始位置最小的
            lg_w_x = min(brand_x, slogan_x)
            # 找出图样在右边的起始位置
            lg_w = lg_w_x + max(brand_width, slogan_width)
            lg_h = 100
            self.logo_gen_image.paste(lg_im_resize, (lg_w, lg_h))
        elif brand_location == '上':
            brand_x = 190 - int(brand_width / 2)
            brand_y = 100 - int((brand_height + slogan_height) / 2)
            # print('品牌语开始位置:', brand_x, brand_y)
            slogan_x = 190 - int(slogan_width / 2)
            slogan_y = brand_y + brand_height
            # print('标语开始位置:', slogan_x, slogan_y)
            draw.text((brand_x, brand_y), brand_text, brand_color, brand_font)
            draw.text((slogan_x, slogan_y), slogan_text, slogan_color, slogan_font)
            # 找出生成的标语和品牌语的起始位置最小的
            lg_w_h = max(brand_y, slogan_y)
            # 找出图样在右边的起始位置
            lg_w = 150
            lg_h = lg_w_h + min(brand_height, slogan_height)
            self.logo_gen_image.paste(lg_im_resize, (lg_w, lg_h))

        elif brand_location == '下':
            brand_x = 190 - int(brand_width / 2)
            brand_y = 180 - int((brand_height + slogan_height) / 2)
            # print('品牌语开始位置:', brand_x, brand_y)
            slogan_x = 190 - int(slogan_width / 2)
            slogan_y = brand_y + brand_height
            # print('标语开始位置:', slogan_x, slogan_y)
            draw.text((brand_x, brand_y), brand_text, brand_color, brand_font)
            draw.text((slogan_x, slogan_y), slogan_text, slogan_color, slogan_font)
            # 找出生成的标语和品牌语的起始位置最小的
            lg_w_h = min(brand_y, slogan_y)
            # 找出图样在右边的起始位置
            lg_w = 150
            lg_h = lg_w_h - 82
            self.logo_gen_image.paste(lg_im_resize, (lg_w, lg_h))

        return self.logo_gen_image

# logo生成器，自定义样式
class customizemodel:
    def __init__(self):
        self.width = 380  # 生成logo的宽
        self.height = 280  # 生成logo的高
        # 生成空白logo图像，指定背景颜色和大小
        self.logo_image = Image.new('RGBA', (self.width, self.height), (0, 0, 0, 0))

    # 实现竖排字体
    def vertical_template(self, brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):

        draw = ImageDraw.Draw(self.logo_image)
        # 获取品牌语font的大小
        brand_width, brand_height = brand_font.getsize(brand_text)
        # print('品牌语字体大小:', brand_width, brand_height)
        # 获取标语font的大小
        slogan_width, slogan_height = slogan_font.getsize(slogan_text)
        # print('标语字体大小:', slogan_width, slogan_height)
        # 获取宽度
        text_width = brand_height + slogan_height
        # 品牌语开始位置
        brand_width_start = 190 - int((brand_height + slogan_height) / 2)
        brand_h = 0
        for ch in brand_text:
            ch_width, ch_height = brand_font.getsize(ch)
            brand_h += ch_height
        brand_height_start = 140 - int(brand_h / 2)
        # 标语开始位置
        slogan_h = 0
        for ch in slogan_text:
            ch_width, ch_height = slogan_font.getsize(ch)
            slogan_h += ch_height
        slogan_width_start = brand_width_start + brand_height
        slogan_height_start = 140 - int(slogan_h / 2)

        # draw.line((brand_width_start,brand_height_start,brand_width_start+200,brand_height_start),fill=(255,255,255),width=3)
        # draw.line((brand_width_start, brand_height_start, brand_width_start + 200, brand_height_start),
        #           fill=(255, 255, 255), width=3)

        # 开始书写品牌语
        brand_down = 0
        for ch in brand_text:
            ch_width, ch_height = brand_font.getsize(ch)
            # print(ch_width)
            draw.text((brand_width_start + int(brand_height / 2) - int(ch_width / 2), brand_height_start + brand_down),
                      ch,
                      brand_color, brand_font)
            brand_down += ch_height

        # 开始书写标语
        slogan_down = 0
        for ch in slogan_text:
            ch_width, ch_height = slogan_font.getsize(ch)
            draw.text(
                (slogan_width_start + int(slogan_height / 2) - int(ch_width / 2), slogan_height_start + slogan_down),
                ch, slogan_color, slogan_font)
            slogan_down += ch_height
        # print(slogan_down)
        # logo_image_new = add_watermark(logo_image, 'www.gongsibao.com')
        # logo_image_new.show()
        return self.logo_image

    # 实现品牌语被矩形框包围
    def rectangle_template(self, brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
        # logo_image = Image.new('RGB', (width, height), (255, 255, 255))
        draw = ImageDraw.Draw(self.logo_image)
        # 品牌语整体的长宽
        brand_width, brand_height = brand_font.getsize(brand_text)
        # 标语的宽高
        slogan_width, slogan_height = slogan_font.getsize(slogan_text)
        # 获取品牌语单个字符的宽度
        brand_w = 0
        for ch in brand_text:
            ch_width, ch_height = brand_font.getsize(ch)
            # print(ch_width, ch_height, brand_height)
            brand_w += ch_width
        # 品牌语开始位置
        brand_width_start = 190 - int(brand_w / 2)
        brand_height_start = 140 - int((brand_height + slogan_height) / 2)
        # 标语开始位置
        slogan_width_start = 190 - int(slogan_width / 2)
        slogan_height_start = brand_height_start + brand_height
        move_w = 0
        for i, ch in enumerate(brand_text):
            ch_width, ch_height = brand_font.getsize(ch)
            draw.text((brand_width_start + move_w, brand_height_start), ch, brand_color, brand_font)
            if i == 0:
                draw.rectangle((brand_width_start + move_w, brand_height_start, brand_width_start + move_w + ch_width,
                                brand_height_start + brand_height), outline='black', width=1)
            else:
                draw.rectangle(
                    (brand_width_start + move_w + 2, brand_height_start, brand_width_start + move_w + ch_width,
                     brand_height_start + brand_height), outline='black', width=1)

            move_w += ch_width

        draw.text((slogan_width_start, slogan_height_start), slogan_text, slogan_color, slogan_font)
        # logo_image_new = add_watermark(logo_image, 'www.gongsibao.com')
        # logo_image_new.show()
        return self.logo_image

    # 实现logo被矩形颜色框包围(涉及半透明图像alpha通道)
    def rectanglecolor_template(self, brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
        draw = ImageDraw.Draw(self.logo_image)
        # 品牌语整体的长宽
        brand_width, brand_height = brand_font.getsize(brand_text)
        # 标语的宽高
        slogan_width, slogan_height = slogan_font.getsize(slogan_text)
        # 品牌语开始位置
        brand_width_start = 190 - int(brand_width / 2)
        brand_height_start = 140 - int((brand_height + slogan_height) / 2)
        # 标语开始位置
        slogan_width_start = 190 - int(slogan_width / 2)
        slogan_height_start = brand_height_start + brand_height

        # 找出长度最大的文本
        w_max = max(brand_width, slogan_width)

        draw.text((brand_width_start, brand_height_start), brand_text, brand_color, brand_font)
        draw.text((slogan_width_start, slogan_height_start), slogan_text, slogan_color, slogan_font)

        # 新定一个带alpha通道的图像，画两个矩形
        # 矩形一位置
        rec_x = 190 - int(w_max / 2)
        rec_y = 140 - int((brand_height + slogan_height) / 2)
        alpha_logo = Image.new('RGBA', (self.width, self.height), (0, 0, 0, 0))
        alpha_draw = ImageDraw.Draw(alpha_logo)
        # 画透明矩形
        alpha_draw.rectangle((rec_x - 10, rec_y - 10, rec_x + w_max,
                              rec_y + brand_height + slogan_height), fill=(173, 177, 185, 50))
        alpha_draw.rectangle((rec_x, rec_y, rec_x + w_max + 10,
                              rec_y + brand_height + slogan_height + 10), fill=(173, 177, 185, 120))
        # 将两个图像融合的结果
        final = Image.new("RGBA", (self.width, self.height))  # 合成的image
        final = Image.alpha_composite(final, self.logo_image.convert('RGBA'))
        final = Image.alpha_composite(final, alpha_logo)
        # final = final.convert('RGB')
        # final.show()
        # logo_image_new = add_watermark(final, 'www.gongsibao.com')
        # logo_image_new.show()
        # final.save('image_mask.jpg')
        return final

    # 实现对角线对角样式
    def cornerline_template(self, brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
        # logo_image = Image.new('RGB', (width, height), (255, 255, 255))
        draw = ImageDraw.Draw(self.logo_image)
        # 品牌语整体的长宽
        brand_width, brand_height = brand_font.getsize(brand_text)
        # 标语的宽高
        slogan_width, slogan_height = slogan_font.getsize(slogan_text)
        # 品牌语开始位置
        brand_width_start = 190 - int(brand_width / 2)
        brand_height_start = 140 - int((brand_height + slogan_height) / 2)
        # 标语开始位置
        slogan_width_start = 190 - int(slogan_width / 2)
        slogan_height_start = brand_height_start + brand_height

        # 找出长度最大的文本
        w_max = max(brand_width, slogan_width)

        draw.text((brand_width_start, brand_height_start), brand_text, brand_color, brand_font)
        draw.text((slogan_width_start, slogan_height_start), slogan_text, slogan_color, slogan_font)

        # 左上角开始位置

        left_x = 185 - int(w_max / 2)
        left_y = 135 - int((brand_height + slogan_height) / 2)
        # draw.line((left_x,left_y,left_x,left_y + 200),width=10,fill='green')
        # draw.line((left_x, left_y, left_x + 200, left_y ), width=10, fill='green')
        draw.rectangle((left_x, left_y, left_x + 2, left_y + 25), fill=(0, 0, 0))
        draw.rectangle((left_x, left_y, left_x + 25, left_y + 2), fill=(0, 0, 0))
        # 右下角开始位置
        right_x = 195 + int(w_max / 2)
        right_y = 145 + int((brand_height + slogan_height) / 2)
        # draw.line((right_x, right_y, right_x, right_y - 200), width=10, fill='green')
        # draw.line((right_x, right_y, right_x - 200, right_y), width=10, fill='green')
        draw.rectangle((right_x, right_y, right_x - 2, right_y - 25), fill=(0, 0, 0))
        draw.rectangle((right_x, right_y, right_x - 25, right_y - 2), fill=(0, 0, 0))

        # logo_image_new = add_watermark(logo_image, 'www.gongsibao.com')
        # logo_image_new.show()
        return self.logo_image

    # 实现两个品字型的样式
    def twopin_template(self, brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
        # logo_image = Image.new('RGB', (width, height), (255, 255, 255))
        draw = ImageDraw.Draw(self.logo_image)
        # 品牌语整体的长宽
        brand_width, brand_height = brand_font.getsize(brand_text)
        # 标语的宽高
        slogan_width, slogan_height = slogan_font.getsize(slogan_text)
        # 品牌语开始位置
        brand_width_start = 190 - int(brand_width / 2)
        brand_height_start = 140 - int((brand_height + slogan_height) / 2)
        # 标语开始位置
        slogan_width_start = 190 - int(slogan_width / 2)
        slogan_height_start = brand_height_start + brand_height

        # 找出长度最大的文本
        w_max = max(brand_width, slogan_width)

        draw.text((brand_width_start, brand_height_start), brand_text, brand_color, brand_font)
        draw.text((slogan_width_start, slogan_height_start), slogan_text, slogan_color, slogan_font)

        # 左边开始位置
        left_x = 180
        left_y = brand_height_start - 35
        # 矩形宽
        rect_w = 4
        # 画竖矩形
        draw.rectangle((left_x - 10, left_y + 2, left_x + 10 + rect_w, left_y + 2 + rect_w), fill=(0, 0, 0))  # 顶部矩形
        draw.rectangle((left_x - 10, left_y + 2, left_x - 10 + rect_w, left_y + 15), fill=(0, 0, 0))  # 上左矩形
        draw.rectangle((left_x + 10, left_y + 2, left_x + 10 + rect_w, left_y + 15), fill=(0, 0, 0))  # 上右矩形

        draw.rectangle((left_x - 20, left_y + 15, left_x - 10 + rect_w, left_y + 15 + rect_w), fill=(0, 0, 0))  # 上左下矩形
        draw.rectangle((left_x + 10, left_y + 15, left_x + 20 + rect_w, left_y + 15 + rect_w), fill=(0, 0, 0))  # 上右下矩形

        draw.rectangle((left_x - 20, left_y + 15, left_x - 20 + rect_w, left_y + 25), fill=(0, 0, 0))  # 上左下左矩形
        draw.rectangle((left_x + 20, left_y + 15, left_x + 20 + rect_w, left_y + 25), fill=(0, 0, 0))  # 上右下右矩形

        draw.rectangle((left_x, left_y + 2, left_x + rect_w, left_y + 25), fill=(0, 0, 0))  # 中间矩形
        draw.rectangle((left_x - 20, left_y + 25, left_x + 20 + rect_w, left_y + 25 + rect_w), fill=(0, 0, 0))  # 底部矩形
        # 左边矩形，中间为空
        draw.rectangle((left_x - 30, left_y - 4, left_x - 14, left_y + 12), fill=(255, 255, 255), outline='black',
                       width=4)
        draw.rectangle((left_x + 18, left_y - 4, left_x + 34, left_y + 12), fill=(255, 255, 255), outline='black',
                       width=4)

        # draw.rectangle((left_x, left_y, left_x + 200, left_y + 10), fill=(0, 0, 0))
        # 右下角开始位置
        # right_x = 1050 + int(w_max / 2)
        # right_y = 1050 + int((brand_height + slogan_height) / 2)
        # # draw.line((right_x, right_y, right_x, right_y - 200), width=10, fill='green')
        # # draw.line((right_x, right_y, right_x - 200, right_y), width=10, fill='green')
        # draw.rectangle((right_x, right_y, right_x - 10, right_y - 200), fill=(0, 0, 0))
        # draw.rectangle((right_x, right_y, right_x - 200, right_y - 10), fill=(0, 0, 0))
        # logo_image.show()
        return self.logo_image

    # 实现线条半包围logo字体
    def line_template(self, brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
        # logo_image = Image.new('RGB', (width, height), (255, 255, 255))
        draw = ImageDraw.Draw(self.logo_image)
        # 品牌语整体的长宽
        brand_width, brand_height = brand_font.getsize(brand_text)
        # 标语的宽高
        slogan_width, slogan_height = slogan_font.getsize(slogan_text)
        # 品牌语开始位置
        brand_width_start = 190 - int(brand_width / 2)
        brand_height_start = 140 - int((brand_height + slogan_height) / 2)
        # 标语开始位置
        slogan_width_start = 190 - int(slogan_width / 2)
        slogan_height_start = brand_height_start + brand_height

        # 找出长度最大的文本
        w_max = max(brand_width, slogan_width)

        draw.text((brand_width_start, brand_height_start), brand_text, brand_color, brand_font)
        draw.text((slogan_width_start, slogan_height_start), slogan_text, slogan_color, slogan_font)

        # 左上角开始位置
        left_x = 180 - int(w_max / 2)
        left_y = 125 - int((brand_height + slogan_height) / 2)
        left_y_bottom = 165 + int((brand_height + slogan_height) / 2)
        draw.rectangle((left_x, left_y, left_x + 1, left_y_bottom), fill=(0, 0, 0))
        draw.rectangle((left_x, left_y, left_x + 10 + int(w_max / 2), left_y + 1), fill=(0, 0, 0))
        draw.rectangle((left_x, left_y_bottom, left_x + +10 + int(w_max / 2), left_y_bottom + 1), fill=(0, 0, 0))
        draw.rectangle((left_x + 10 + int(w_max / 2), left_y, left_x + 10 + int(w_max / 2) + 1, left_y + 10),
                       fill=(0, 0, 0))
        draw.rectangle(
            (left_x + 10 + int(w_max / 2), left_y_bottom, left_x + 10 + int(w_max / 2) - 1, left_y_bottom - 10),
            fill=(0, 0, 0))
        # draw.rectangle((left_x, left_y_bottom, left_x + +100 + int(w_max / 2), left_y_bottom + 10), fill=(0, 0, 0))

        # 右下角开始位置
        # right_x = 1050 + int(w_max / 2)
        # right_y = 1050 + int((brand_height + slogan_height) / 2)
        # # draw.line((right_x, right_y, right_x, right_y - 200), width=10, fill='green')
        # # draw.line((right_x, right_y, right_x - 200, right_y), width=10, fill='green')
        # draw.rectangle((right_x, right_y, right_x - 10, right_y - 200), fill=(0, 0, 0))
        # draw.rectangle((right_x, right_y, right_x - 200, right_y - 10), fill=(0, 0, 0))

        # logo_image.show()
        return self.logo_image

    # 实现竖排字体加上帽子
    def verticalline_template(self, brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
        # logo_image = Image.new('RGB', (width, height), (255, 255, 255))
        draw = ImageDraw.Draw(self.logo_image)
        # 获取品牌语font的大小
        brand_width, brand_height = brand_font.getsize(brand_text)
        # print('品牌语字体大小:', brand_width, brand_height)
        # 获取标语font的大小
        slogan_width, slogan_height = slogan_font.getsize(slogan_text)
        # print('标语字体大小:', slogan_width, slogan_height)
        # 获取宽度
        text_width = brand_height + slogan_height
        # 品牌语开始位置
        brand_width_start = 190 - int((brand_height + slogan_height) / 2)
        brand_h = 0
        for ch in brand_text:
            ch_width, ch_height = brand_font.getsize(ch)
            brand_h += ch_height
        brand_height_start = 140 - int(brand_h / 2)
        # 标语开始位置
        slogan_h = 0
        for ch in slogan_text:
            ch_width, ch_height = slogan_font.getsize(ch)
            slogan_h += ch_height
        slogan_width_start = brand_width_start + brand_height
        slogan_height_start = 140 - int(slogan_h / 2)

        # 开始书写品牌语
        brand_down = 0
        for ch in brand_text:
            ch_width, ch_height = brand_font.getsize(ch)
            draw.text((brand_width_start + int(brand_height / 2) - int(ch_width / 2), brand_height_start + brand_down),
                      ch,
                      brand_color, brand_font)
            brand_down += ch_height
        # 开始书写标语
        slogan_down = 0
        for ch in slogan_text:
            ch_width, ch_height = slogan_font.getsize(ch)
            draw.text(
                (slogan_width_start + int(slogan_height / 2) - int(ch_width / 2), slogan_height_start + slogan_down),
                ch, slogan_color, slogan_font)
            slogan_down += ch_height

        # 帽子的坐标计算
        line_x = 190 - int((brand_height + slogan_height) / 2)
        line_y = 140 - int(max(slogan_down, brand_down) / 2)
        line_bottom_y = 140 + int(max(slogan_down, brand_down) / 2)
        # 上边帽子
        draw.rectangle((line_x - 3, line_y - 3, line_x + text_width + 3, line_y - 2), fill=(0, 0, 0))
        draw.rectangle((line_x - 3, line_y - 3, line_x - 2, line_y + 5), fill=(0, 0, 0))
        draw.rectangle((line_x + text_width + 2, line_y - 3, line_x + text_width + 3, line_y + 5), fill=(0, 0, 0))

        # 下边帽子
        draw.rectangle((line_x - 3, line_bottom_y + 3, line_x + text_width + 3, line_bottom_y + 4),
                       fill=(0, 0, 0))
        draw.rectangle((line_x - 3, line_bottom_y + 3, line_x - 2, line_bottom_y - 5), fill=(0, 0, 0))
        draw.rectangle((line_x + text_width + 2, line_bottom_y + 3, line_x + text_width + 3, line_bottom_y - 5),
                       fill=(0, 0, 0))

        # logo_image.show()
        return self.logo_image

    # 实现一半文字被梯形包围
    def polygon_right_template(self, brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
        # logo_image = Image.new('RGB', (width, height), (255, 255, 255))
        draw = ImageDraw.Draw(self.logo_image)
        # 品牌语整体的长宽
        brand_width, brand_height = brand_font.getsize(brand_text)
        # 标语的宽高
        slogan_width, slogan_height = slogan_font.getsize(slogan_text)
        # 品牌语开始位置
        brand_width_start = 190 - int(brand_width / 2)
        brand_height_start = 140 - int((brand_height + slogan_height) / 2)
        # 标语开始位置
        slogan_width_start = 190 - int(slogan_width / 2)
        slogan_height_start = brand_height_start + brand_height
        # 找出长度最大的文本
        w_max = max(brand_width, slogan_width)

        # 左边开始位置坐标
        left_x = 190
        left_y = 140 - int((brand_height + slogan_height) / 2)
        left_y_bottom = 140 + int((brand_height + slogan_height) / 2)
        point1 = (left_x, left_y + 2)
        point2 = (left_x + int(w_max / 2) + 3, left_y - 2 - int((brand_height + slogan_height) / 4))
        point3 = (left_x + int(w_max / 2) + 3, left_y_bottom + 2 + int((brand_height + slogan_height) / 4))
        point4 = (left_x, left_y_bottom + 2)
        draw.polygon([point1, point2, point3, point4], fill=(255, 205, 67))
        draw.text((brand_width_start, brand_height_start), brand_text, brand_color, brand_font)
        draw.text((slogan_width_start, slogan_height_start), slogan_text, slogan_color, slogan_font)
        # logo_image.show()
        return self.logo_image


# ------------------------------调用生成器入口函数------------开始
# 生成自定义模板logo的入口函数
def template_gen_main(gen_json):
    # 创建生成图像存储路径
    if not os.path.exists('generatordir'):
        os.makedirs('generatordir')
    # logo名字
    logo_name = time.strftime('%Y%m%d%H%M%S') + str(random.randint(100, 10000)) + '.png'
    brand_text = gen_json['brand_text']
    brand_color_str = gen_json['brand_color']
    brand_color_list = brand_color_str.replace('(', '').replace(')', '').split(',')
    brand_color = (int(brand_color_list[0]), int(brand_color_list[1]), int(brand_color_list[2]))

    slogan_text = gen_json['slogan_text']
    slogan_color_str = gen_json['slogan_color']
    slogan_color_list = slogan_color_str.replace('(', '').replace(')', '').split(',')
    slogan_color = (int(slogan_color_list[0]), int(slogan_color_list[1]), int(slogan_color_list[2]))

    if len(brand_text) < 8:
        brand_size = 42
    else:
        brand_size = 30
    # brand_font = ImageFont.truetype('font/cn/华文行楷.ttf', brand_size)
    brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
    # slogan_font = ImageFont.truetype(gen_json['slogan_font'], slogan_size)
    slogan_size = 15
    slogan_font = ImageFont.truetype("font/cn/微软vista雅黑.ttf", slogan_size)
    lg_custom = customizemodel()
    # 选择自定义模型的名称或者编号
    customize_model_id = gen_json['model_id']
    if customize_model_id == 1:  # 实现竖排字体,由于竖排文字需要对其文字大小限制
        if len(brand_text) < 7:
            brand_size = 42
            # brand_font = ImageFont.truetype('font/cn/华文行楷.ttf', brand_size)
            brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
        else:
            brand_size = 30
            # brand_font = ImageFont.truetype('font/cn/华文行楷.ttf', brand_size)
            brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
            slogan_size = 12
            slogan_font = ImageFont.truetype("font/cn/微软vista雅黑.ttf", slogan_size)
        gen_img = lg_custom.vertical_template(brand_text, brand_font, brand_color, slogan_text, slogan_font,
                                              slogan_color)
    if customize_model_id == 2:  # 实现品牌语被矩形框包围
        gen_img = lg_custom.rectangle_template(brand_text, brand_font, brand_color, slogan_text, slogan_font,
                                               slogan_color)
    if customize_model_id == 3:  # 实现logo被矩形颜色框包围(涉及半透明图像alpha通道)
        gen_img = lg_custom.rectanglecolor_template(brand_text, brand_font, brand_color, slogan_text, slogan_font,
                                                    slogan_color)
    if customize_model_id == 4:  # 实现对角线对角样式
        gen_img = lg_custom.cornerline_template(brand_text, brand_font, brand_color, slogan_text, slogan_font,
                                                slogan_color)
    if customize_model_id == 5:  # 实现两个品字型的样式
        gen_img = lg_custom.twopin_template(brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color)
    if customize_model_id == 6:  # # 实现线条半包围logo字体
        gen_img = lg_custom.line_template(brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color)
    if customize_model_id == 7:  # 实现竖排字体加上帽子
        if len(brand_text) < 7:
            brand_size = 42
            # brand_font = ImageFont.truetype('font/cn/华文行楷.ttf', brand_size)
            brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
        else:
            brand_size = 30
            # brand_font = ImageFont.truetype('font/cn/华文行楷.ttf', brand_size)
            brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
            slogan_size = 12
            slogan_font = ImageFont.truetype("font/cn/微软vista雅黑.ttf", slogan_size)
        gen_img = lg_custom.verticalline_template(brand_text, brand_font, brand_color, slogan_text, slogan_font,
                                                  slogan_color)
    if customize_model_id == 8:  # 实现一半文字被梯形包围
        gen_img = lg_custom.polygon_right_template(brand_text, brand_font, brand_color, slogan_text, slogan_font,
                                                   slogan_color)
    return gen_img


# 样式生成logo主函数
def standard_gen_main(gen_json):
    # 创建生成图像存储路径
    if not os.path.exists('generatordir'):
        os.makedirs('generatordir')
    # 下载图标/图案路径
    if not os.path.exists('logodir'):
        os.makedirs('logodir')
    # 图标下载
    logo_url = gen_json['logo_url']
    # logo名字
    logo_name = time.strftime('%Y%m%d%H%M%S') + str(random.randint(100, 10000)) + '.png'
    logo_down_path = 'logodir/' + logo_name
    # 本地下载logo样式方法
    # logo_down_result = downlogo(logo_down_path, logo_url)
    # 线上读取logo样式方法
    logo_down_result = downlogo_path(logo_down_path, logo_url)
    # 定义生成的图像接受对象
    if logo_down_result:
        # 判断标语是否存在
        logo_img = Image.open(logo_down_path).convert('RGBA')
        lg_gen = logoGenerator()
        brand_text = gen_json['brand_text']
        brand_color_str = gen_json['brand_color']
        brand_color_list = brand_color_str.replace('(', '').replace(')', '').split(',')
        brand_color = (int(brand_color_list[0]), int(brand_color_list[1]), int(brand_color_list[2]))
        if len(brand_text) < 8:
            brand_size = 42
        else:
            brand_size = 30
        brand_location = gen_json['brand_location']
        slogan_text = gen_json['slogan_text']
        slogan_color_str = gen_json['slogan_color']
        slogan_color_list = slogan_color_str.replace('(', '').replace(')', '').split(',')
        slogan_color = (int(slogan_color_list[0]), int(slogan_color_list[1]), int(slogan_color_list[2]))
        slogan_size = 16
        # brand_font = ImageFont.truetype('font/cn/华文行楷.ttf', brand_size)
        brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
        # slogan_font = ImageFont.truetype(gen_json['slogan_font'], slogan_size)
        slogan_font = ImageFont.truetype("font/cn/微软vista雅黑.ttf", slogan_size)
        gen_img = lg_gen.generator(brand_text, brand_font, brand_color, brand_location, slogan_text,
                                   slogan_font, slogan_color, logo_img)
        return gen_img


# ------------------------------调用不同场景的服务接口函数------------开始
# 前台展示场景
@server.route('/gsb/logo/reception_scene', methods=['POST', 'GET'])
def reception_scene():
    if request.method == 'POST':
        try:
            gen_json = request.json
            logo_type = gen_json['logo_type']
            if logo_type == 'standard':
                logo_img = standard_gen_main(gen_json)
            if logo_type == 'template':
                logo_img = template_gen_main(gen_json)

            # 首先读取场景图像
            scene_read_image = Image.open('data/scene/5-water.png').convert('RGBA')
            logo_w, logo_h = logo_img.size

            layer1 = scene_read_image  # 场景图
            scene_reslut = Image.new("RGBA", layer1.size)  # 生成一张空白图
            scene_reslut.paste(layer1, (0, 0), layer1)  # 粘贴场景图
            logo_small = logo_img.resize((int(logo_w / 1.2), int(logo_h / 1.2)), Image.ANTIALIAS)
            scene_reslut.paste(logo_small, (470, 210), logo_small)  # 粘贴logo图
            scene_reslut = scene_reslut.convert('RGB')  # 转成RGB
            # scene_reslut.show()
            # # scene_reslut.save('image_mask_2.jpg')

            # logo名字
            scene_name = 'reception_' + time.strftime('%Y%m%d%H%M%S') + str(random.randint(100, 10000)) + '.png'
            # 创建生成图像存储路径
            if not os.path.exists('generatordir'):
                os.makedirs('generatordir')
            scene_reslut_path = 'generatordir/' + scene_name
            scene_reslut.save(scene_reslut_path)
            scene_url = put2oss('scene_' + scene_name, scene_reslut_path)
            return jsonify({'status': 1, 'msg': 'success', 'scene_url': scene_url})
        except Exception as e:
            print(e)
            return jsonify({'status': 0, 'msg': '生成场景出现异常！'})
    else:
        return jsonify({'status': 0, 'msg': '请使用post请求方式！'})


# 电脑场景展示
@server.route('/gsb/logo/computer_scene', methods=['POST', 'GET'])
def computer_scene():
    if request.method == 'POST':
        try:
            gen_json = request.json
            logo_type = gen_json['logo_type']
            if logo_type == 'standard':
                logo_img = standard_gen_main(gen_json)
            if logo_type == 'template':
                logo_img = template_gen_main(gen_json)
            # 首先读取场景图像
            scene_read_image = Image.open('data/scene/13-water.png').convert('RGBA')
            logo_w, logo_h = logo_img.size
            layer1 = scene_read_image  # 场景图
            scene_reslut = Image.new("RGBA", layer1.size)  # 生成一张空白图
            scene_reslut.paste(layer1, (0, 0), layer1)  # 粘贴场景图
            # res_small = res.resize((int(logo_w / 1.2), int(logo_h / 1.2)), Image.ANTIALIAS)
            logo_small = logo_img.resize((int(logo_w / 3), int(logo_h / 3)), Image.ANTIALIAS)
            scene_reslut.paste(logo_img, (385, 210), logo_img)  # 粘贴logo图
            scene_reslut.paste(logo_small, (845, 470), logo_small)  # 粘贴logo图
            scene_reslut = scene_reslut.convert('RGB')  # 转成RGB
            # scene_reslut.show()
            # 生成场景的名字
            scene_name = 'computer_' + time.strftime('%Y%m%d%H%M%S') + str(random.randint(100, 10000)) + '.png'
            # 创建生成图像存储路径
            if not os.path.exists('generatordir'):
                os.makedirs('generatordir')
            scene_reslut_path = 'generatordir/' + scene_name
            scene_reslut.save(scene_reslut_path)
            scene_url = put2oss('scene_' + scene_name, scene_reslut_path)
            return jsonify({'status': 1, 'msg': 'success', 'scene_url': scene_url})
        except Exception as e:
            print(e)
            return jsonify({'status': 0, 'msg': '生成场景出现异常！'})
    else:
        return jsonify({'status': 0, 'msg': '请使用post请求方式！'})


# 茶杯场景展示
@server.route('/gsb/logo/cup_scene', methods=['POST', 'GET'])
def cup_scene():
    if request.method == 'POST':
        try:
            gen_json = request.json
            logo_type = gen_json['logo_type']
            if logo_type == 'standard':
                logo_img = standard_gen_main(gen_json)
            if logo_type == 'template':
                logo_img = template_gen_main(gen_json)
            # 首先读取场景图像
            scene_read_image = Image.open('data/scene/6-water.png').convert('RGBA')
            logo_w, logo_h = logo_img.size
            layer1 = scene_read_image  # 场景图
            scene_reslut = Image.new("RGBA", layer1.size)  # 生成一张空白图
            scene_reslut.paste(layer1, (0, 0), layer1)  # 粘贴场景图
            scene_reslut.paste(logo_img, (360, 310), logo_img)  # 粘贴logo图
            logo_img_small = logo_img.resize((int(logo_w / 3.3), int(logo_h / 3.3)), Image.ANTIALIAS)
            scene_reslut.paste(logo_img_small, (850, 520), logo_img_small)  # 粘贴logo图
            scene_reslut = scene_reslut.convert('RGB')  # 转成RGB
            # scene_reslut.show()
            # 生成场景的名字
            scene_name = 'cup_' + time.strftime('%Y%m%d%H%M%S') + str(random.randint(100, 10000)) + '.png'
            # 创建生成图像存储路径
            if not os.path.exists('generatordir'):
                os.makedirs('generatordir')
            scene_reslut_path = 'generatordir/' + scene_name
            scene_reslut.save(scene_reslut_path)
            scene_url = put2oss('scene_' + scene_name, scene_reslut_path)
            return jsonify({'status': 1, 'msg': 'success', 'scene_url': scene_url})
        except Exception as e:
            print(e)
            return jsonify({'status': 0, 'msg': '生成场景出现异常！'})
    else:
        return jsonify({'status': 0, 'msg': '请使用post请求方式！'})


# 购物袋场景展示
@server.route('/gsb/logo/bag_scene', methods=['POST', 'GET'])
def bag_scene():
    if request.method == 'POST':
        try:
            gen_json = request.json
            logo_type = gen_json['logo_type']
            if logo_type == 'standard':
                logo_img = standard_gen_main(gen_json)
            if logo_type == 'template':
                logo_img = template_gen_main(gen_json)
            # 首先读取场景图像
            scene_read_image = Image.open('data/scene/2-water.png').convert('RGBA')
            logo_w, logo_h = logo_img.size
            layer1 = scene_read_image  # 场景图
            scene_reslut = Image.new("RGBA", layer1.size)  # 生成一张空白图
            scene_reslut.paste(layer1, (0, 0), layer1)  # 粘贴场景图
            scene_reslut.paste(logo_img, (560, 340), logo_img)  # 粘贴logo图
            logo_img_small = logo_img.resize((int(logo_w / 2), int(logo_h / 2)), Image.ANTIALIAS)
            scene_reslut.paste(logo_img_small, (265, 180), logo_img_small)  # 粘贴logo图
            scene_reslut.paste(logo_img_small, (265, 525), logo_img_small)  # 粘贴logo图
            scene_reslut = scene_reslut.convert('RGB')  # 转成RGB
            # scene_reslut.show()
            # 生成场景的名字
            scene_name = 'bag_' + time.strftime('%Y%m%d%H%M%S') + str(random.randint(100, 10000)) + '.png'
            # 创建生成图像存储路径
            if not os.path.exists('generatordir'):
                os.makedirs('generatordir')
            scene_reslut_path = 'generatordir/' + scene_name
            scene_reslut.save(scene_reslut_path)
            scene_url = put2oss('scene_' + scene_name, scene_reslut_path)
            return jsonify({'status': 1, 'msg': 'success', 'scene_url': scene_url})
        except Exception as e:
            print(e)
            return jsonify({'status': 0, 'msg': '生成场景出现异常！'})
    else:
        return jsonify({'status': 0, 'msg': '请使用post请求方式！'})


# 洗发露场景展示
@server.route('/gsb/logo/shampoo_scene', methods=['POST', 'GET'])
def shampoo_scene():
    if request.method == 'POST':
        try:
            gen_json = request.json
            logo_type = gen_json['logo_type']
            if logo_type == 'standard':
                logo_img = standard_gen_main(gen_json)
            if logo_type == 'template':
                logo_img = template_gen_main(gen_json)
            # 首先读取场景图像
            scene_read_image = Image.open('data/scene/11-water.png').convert('RGBA')
            logo_w, logo_h = logo_img.size
            logo_img_small1 = logo_img.resize((int(logo_w / 2.1), int(logo_h / 2.1)), Image.ANTIALIAS)
            logo_img_small2 = logo_img.resize((int(logo_w / 4.1), int(logo_h / 4.1)), Image.ANTIALIAS)
            logo_img_small3 = logo_img.resize((int(logo_w / 2.7), int(logo_h / 2.7)), Image.ANTIALIAS)
            layer1 = scene_read_image  # 场景图
            scene_reslut = Image.new("RGBA", layer1.size)  # 生成一张空白图
            scene_reslut.paste(layer1, (0, 0), layer1)  # 粘贴场景图
            scene_reslut.paste(logo_img_small1, (390, 420), logo_img_small1)  # 粘贴logo图
            scene_reslut.paste(logo_img_small2, (640, 330), logo_img_small2)  # 粘贴logo图
            scene_reslut.paste(logo_img_small3, (615, 550), logo_img_small3)  # 粘贴logo图
            scene_reslut = scene_reslut.convert('RGB')  # 转成RGB
            # scene_reslut.show()
            # 生成场景的名字
            scene_name = 'shampoo_' + time.strftime('%Y%m%d%H%M%S') + str(random.randint(100, 10000)) + '.png'
            # 创建生成图像存储路径
            if not os.path.exists('generatordir'):
                os.makedirs('generatordir')
            scene_reslut_path = 'generatordir/' + scene_name
            scene_reslut.save(scene_reslut_path)
            scene_url = put2oss('scene_' + scene_name, scene_reslut_path)
            return jsonify({'status': 1, 'msg': 'success', 'scene_url': scene_url})
        except Exception as e:
            print(e)
            return jsonify({'status': 0, 'msg': '生成场景出现异常！'})
    else:
        return jsonify({'status': 0, 'msg': '请使用post请求方式！'})


# 化妆品场景展示
@server.route('/gsb/logo/cosmetics_scene', methods=['POST', 'GET'])
def cosmetics_scene():
    if request.method == 'POST':
        try:
            gen_json = request.json
            logo_type = gen_json['logo_type']
            if logo_type == 'standard':
                logo_img = standard_gen_main(gen_json)
            if logo_type == 'template':
                logo_img = template_gen_main(gen_json)
            # 首先读取场景图像
            scene_read_image = Image.open('data/scene/14-water.png').convert('RGBA')
            logo_w, logo_h = logo_img.size
            logo_img_small1 = logo_img.resize((int(logo_w / 3.3), int(logo_h / 3.3)), Image.ANTIALIAS)
            logo_img_small2 = logo_img.resize((int(logo_w / 3.1), int(logo_h / 3.1)), Image.ANTIALIAS)
            logo_img_small3 = logo_img.resize((int(logo_w / 1.9), int(logo_h / 1.9)), Image.ANTIALIAS)
            logo_img_small4 = logo_img.resize((int(logo_w / 2.4), int(logo_h / 2.4)), Image.ANTIALIAS)
            layer1 = scene_read_image  # 场景图
            scene_reslut = Image.new("RGBA", layer1.size)  # 生成一张空白图
            scene_reslut.paste(layer1, (0, 0), layer1)  # 粘贴场景图
            scene_reslut.paste(logo_img_small1, (95, 485), logo_img_small1)  # 粘贴logo图
            scene_reslut.paste(logo_img_small2, (350, 480), logo_img_small2)  # 粘贴logo图
            scene_reslut.paste(logo_img_small3, (610, 410), logo_img_small3)  # 粘贴logo图
            scene_reslut.paste(logo_img_small4, (938, 415), logo_img_small4)  # 粘贴logo图
            scene_reslut = scene_reslut.convert('RGB')  # 转成RGB
            # scene_reslut.show()
            # 生成场景的名字
            scene_name = 'cosmetics_' + time.strftime('%Y%m%d%H%M%S') + str(random.randint(100, 10000)) + '.png'
            # 创建生成图像存储路径
            if not os.path.exists('generatordir'):
                os.makedirs('generatordir')
            scene_reslut_path = 'generatordir/' + scene_name
            scene_reslut.save(scene_reslut_path)
            scene_url = put2oss('scene_' + scene_name, scene_reslut_path)
            return jsonify({'status': 1, 'msg': 'success', 'scene_url': scene_url})
        except Exception as e:
            print(e)
            return jsonify({'status': 0, 'msg': '生成场景出现异常！'})
    else:
        return jsonify({'status': 0, 'msg': '请使用post请求方式！'})


# 户外展示场景
# @server.route('/gsb/logo/house_scene', methods=['POST', 'GET'])
# def house_scene():
#     if request.method == 'POST':
#         try:
#             gen_json = request.json
#             logo_type = gen_json['logo_type']
#             if logo_type == 'standard':
#                 logo_img = standard_gen_main(gen_json)
#             if logo_type == 'template':
#                 logo_img = template_gen_main(gen_json)
#             # 首先读取场景图像
#             scene_read_image = Image.open('data/scene/9-water.png').convert('RGBA')
#             logo_w, logo_h = logo_img.size
#             layer1 = scene_read_image  # 场景图
#             scene_reslut = Image.new("RGBA", layer1.size)  # 生成一张空白图
#             scene_reslut.paste(layer1, (0, 0), layer1)  # 粘贴场景图
#             logo_img_small = logo_img.resize((int(logo_w * 1.2), int(logo_h * 1.2)), Image.ANTIALIAS)
#             scene_reslut.paste(logo_img_small, (430, 250), logo_img_small)  # 粘贴logo图
#             scene_reslut = scene_reslut.convert('RGB')  # 转成RGB
#             # scene_reslut.show()
#             # 生成场景的名字
#             scene_name = 'house_' + time.strftime('%Y%m%d%H%M%S') + str(random.randint(100, 10000)) + '.png'
#             # 创建生成图像存储路径
#             if not os.path.exists('generatordir'):
#                 os.makedirs('generatordir')
#             scene_reslut_path = 'generatordir/' + scene_name
#             scene_reslut.save(scene_reslut_path)
#             scene_url = put2oss('scene_' + scene_name, scene_reslut_path)
#             return jsonify({'status': 1, 'msg': 'success', 'scene_url': scene_url})
#         except Exception as e:
#             print(e)
#             return jsonify({'status': 0, 'msg': '生成场景出现异常！'})
#     else:
#         return jsonify({'status': 0, 'msg': '请使用post请求方式！'})


# 手提袋场景展示
@server.route('/gsb/logo/handbag_scene', methods=['POST', 'GET'])
def handbag_scene():
    if request.method == 'POST':
        try:
            gen_json = request.json
            logo_type = gen_json['logo_type']
            if logo_type == 'standard':
                logo_img = standard_gen_main(gen_json)
            if logo_type == 'template':
                logo_img = template_gen_main(gen_json)
            # 首先读取场景图像
            scene_read_image = Image.open('data/scene/3-water.png').convert('RGBA')
            scene_w, screen_h = scene_read_image.size
            # 创建一个场景图大小的空白图
            blank_img = Image.new('RGBA', scene_read_image.size, (0, 0, 0, 0))
            blank_img.paste(logo_img, (0, 0))  # 把生成的logo图粘贴上
            blank_img_ndarry = np.array(blank_img)  # 由于PIL和opencv数据格式不一样，需要事先转化
            # 进行透视变换
            # 原图中四个角点(左上、右上、左下、右下), 与变换后矩阵位置
            pts1 = np.float32([(0, 0), (380, 0), (0, 280), (380, 280)])
            pts2 = np.float32([[320, 400], [680, 180], [570, 695], [940, 420]])
            # # 生成透视变换矩阵；进行透视变换
            M = cv.getPerspectiveTransform(pts1, pts2)
            result_img = cv.warpPerspective(blank_img_ndarry, M, (scene_w, screen_h))
            img = Image.fromarray(result_img.astype('uint8'))   #转化成PIL图像
            layer1 = scene_read_image  # 场景图
            scene_reslut = Image.new("RGBA", layer1.size)  # 生成一张空白图
            scene_reslut.paste(layer1, (0, 0), layer1)  # 粘贴场景图
            scene_reslut.paste(img, (0, 0), img)  # 粘贴logo图
            ''' 原来的旋转粘贴
                scene_reslut.paste(layer1, (0, 0), layer1)  # 粘贴场景图
                res_small = res.resize((logo_w , logo_h), Image.ANTIALIAS)
                res_small = res_small.rotate(39,expand=1)
                scene_reslut.paste(res_small, (390, 190), res_small)  # 粘贴logo图
            '''
            scene_reslut = scene_reslut.convert('RGB')  # 转成RGB
            # scene_reslut.show()
            # 生成场景的名字
            scene_name = 'handbag_' + time.strftime('%Y%m%d%H%M%S') + str(random.randint(100, 10000)) + '.png'
            # 创建生成图像存储路径
            if not os.path.exists('generatordir'):
                os.makedirs('generatordir')
            scene_reslut_path = 'generatordir/' + scene_name
            scene_reslut.save(scene_reslut_path)
            scene_url = put2oss('scene_' + scene_name, scene_reslut_path)
            return jsonify({'status': 1, 'msg': 'success', 'scene_url': scene_url})
        except Exception as e:
            print(e)
            return jsonify({'status': 0, 'msg': '生成场景出现异常！'})
    else:
        return jsonify({'status': 0, 'msg': '请使用post请求方式！'})


# 书场景展示
@server.route('/gsb/logo/book_scene', methods=['POST', 'GET'])
def book_scene():
    if request.method == 'POST':
        try:
            gen_json = request.json
            logo_type = gen_json['logo_type']
            if logo_type == 'standard':
                logo_img = standard_gen_main(gen_json)
            if logo_type == 'template':
                logo_img = template_gen_main(gen_json)
            # 首先读取场景图像
            scene_read_image = Image.open('data/scene/7-water.png').convert('RGBA')
            logo_w, logo_h = logo_img.size

            layer1 = scene_read_image  # 场景图
            scene_reslut = Image.new("RGBA", layer1.size)  # 生成一张空白图
            scene_reslut.paste(layer1, (0, 0), layer1)  # 粘贴场景图
            logo_img_small1 = logo_img.resize((logo_w, logo_h), Image.ANTIALIAS)
            logo_img_small1 = logo_img_small1.rotate(18, expand=1)
            logo_img_small2 = logo_img.resize((logo_w, logo_h), Image.ANTIALIAS)
            logo_img_small2 = logo_img_small2.rotate(18, expand=1)
            scene_reslut.paste(logo_img_small1, (240, 200), logo_img_small1)  # 粘贴logo图
            scene_reslut.paste(logo_img_small2, (580, 100), logo_img_small2)  # 粘贴logo图
            scene_reslut = scene_reslut.convert('RGB')  # 转成RGB
            # scene_reslut.show()
            # 生成场景的名字
            scene_name = 'book_' + time.strftime('%Y%m%d%H%M%S') + str(random.randint(100, 10000)) + '.png'
            # 创建生成图像存储路径
            if not os.path.exists('generatordir'):
                os.makedirs('generatordir')
            scene_reslut_path = 'generatordir/' + scene_name
            scene_reslut.save(scene_reslut_path)
            scene_url = put2oss('scene_' + scene_name, scene_reslut_path)
            return jsonify({'status': 1, 'msg': 'success', 'scene_url': scene_url})
        except Exception as e:
            print(e)
            return jsonify({'status': 0, 'msg': '生成场景出现异常！'})
    else:
        return jsonify({'status': 0, 'msg': '请使用post请求方式！'})

# 大屏场景展示
@server.route('/gsb/logo/screen_scene', methods=['POST', 'GET'])
def screen_scene():
    if request.method == 'POST':
        try:
            gen_json = request.json
            logo_type = gen_json['logo_type']
            if logo_type == 'standard':
                logo_img = standard_gen_main(gen_json)
            if logo_type == 'template':
                logo_img = template_gen_main(gen_json)
            # 首先读取场景图像
            scene_read_image = Image.open('data/scene/8-water.png').convert('RGBA')
            scene_w, screen_h = scene_read_image.size
            # 创建一个场景图大小的空白图
            blank_img = Image.new('RGBA', scene_read_image.size, (0, 0, 0, 0))
            blank_img.paste(logo_img, (0, 0))  # 把生成的logo图粘贴上
            blank_img_ndarry = np.array(blank_img)  # 由于PIL和opencv数据格式不一样，需要事先转化
            # 进行透视变换
            # 原图中的四个角点(左上、右上、左下、右下), 与变换后矩阵位置
            pts1 = np.float32([(0, 0), (380, 0), (0, 280), (380, 280)])
            pts2 = np.float32([[185, 114], [682, 350], [134, 455], [678, 695]])
            # # 生成透视变换矩阵；进行透视变换
            M = cv.getPerspectiveTransform(pts1, pts2)
            result_img = cv.warpPerspective(blank_img_ndarry, M, (scene_w, screen_h))
            img = Image.fromarray(result_img.astype('uint8'))
            layer1 = scene_read_image  # 场景图
            scene_reslut = Image.new("RGBA", layer1.size)  # 生成一张空白图
            scene_reslut.paste(layer1, (0, 0), layer1)  # 粘贴场景图
            scene_reslut.paste(img, (0, 0), img)  # 粘贴logo图
            scene_reslut = scene_reslut.convert('RGB')  # 转成RGB
            # scene_reslut.show()
            # 生成场景的名字
            scene_name = 'screen_' + time.strftime('%Y%m%d%H%M%S') + str(random.randint(100, 10000)) + '.png'
            # 创建生成图像存储路径
            if not os.path.exists('generatordir'):
                os.makedirs('generatordir')
            scene_reslut_path = 'generatordir/' + scene_name
            scene_reslut.save(scene_reslut_path)
            scene_url = put2oss('scene_' + scene_name, scene_reslut_path)
            return jsonify({'status': 1, 'msg': 'success', 'scene_url': scene_url})
        except Exception as e:
            print(e)
            return jsonify({'status': 0, 'msg': '生成场景出现异常！'})
    else:
        return jsonify({'status': 0, 'msg': '请使用post请求方式！'})

# server.run(host='127.0.0.1', port=15502, debug=True)
server.run(host='172.16.18.2', port=15502, debug=True)