#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Time    : 2020-05-07 19:03
# @Author  : zhangyunfei
# @File    : LogoUtil.py
# @Software: PyCharm
import requests,oss2,re,os,zipfile,random
from PIL import Image,ImageFont,ImageDraw

# ------------------------------工具类函数------------
# 下载logo样式图案
def downlogo(logopath, logo_url):
    try:
        res = requests.get(logo_url, timeout=60)
        if str(res.status_code)[0] == "4":
            print(str(res.status_code), ":", logo_url)
            return False
    except Exception as e:
        print('图像url抛出异常：', logo_url)
        return False
    with open(logopath, "wb") as f:
        f.write(res.content)
    return True

# 线上读取logo样式
def downlogo_path(logopath, logo_url):
    imagepath = re.sub(r'http://43.247.184.94:7170/', '', logo_url)
    # 图像在硬盘上的路径
    baseimagepath = '/data/' + imagepath
    # 防止文件不存在
    if os.path.exists(baseimagepath):
        img = Image.open(baseimagepath)
        img.save(logopath)
    return True

#将alpha通道透明改成白色背景
def alpha2white(img):
    img = img.convert('RGBA')
    width, height = img.size

    for w in range(width):
        for h in range(height):
            dot = (w, h)
            color_d = img.getpixel(dot)
            if (color_d[3] == 0):
                color_d = (255, 255, 255, 255)
                img.putpixel(dot, color_d)
    return img

#生成的文件夹进行zip压缩包
def make_zip(brand_text):
    zip_name = brand_text+'.zip'
    zip_name_path = 'downlogo/zipdir/' +zip_name
    img_path = 'downlogo/'+brand_text
    with zipfile.ZipFile(zip_name_path, 'w') as target:
        for parent,dirname,filenames in os.walk(img_path):
            # print(parent)
            # print(dirname)
            # print(filenames)
            for name in filenames:
                # print(os.path.join(parent,name))
                target.write(os.path.join(parent,name))
                # target.write(filename=os.path.join(parent,name), arcname=name)
    return zip_name_path,zip_name

#上传阿里云OSS
def put2oss(imagename, imagepath):
    # 阿里云接口地址
    endpoint = 'http://oss-cn-beijing.aliyuncs.com'
    auth = oss2.Auth('LTAI4GC5tSKvqsH2hMqj6pvd', '3KV9nIwW8qkTGlrPmAe3HnR3fzM6r5')
    bucket = oss2.Bucket(auth, endpoint, 'gsb-zc')
    # current_file_path = "table.jpg"
    # current_fold = time.strftime('%Y%m%d%H%M%S', time.localtime())
    # p = str(current_fold) + "_" + current_file_path
    bucket.put_object_from_file(imagename, imagepath)
    addr_url = "https://gsb-zc.oss-cn-beijing.aliyuncs.com/" + imagename
    return addr_url

# 加水印和版权图标
def add_watermark(logo_img, text):
    width, height = logo_img.width, logo_img.height
    new_img = Image.new('RGBA', (width * 3, height * 3), (0, 0, 0, 0))
    new_img.paste(logo_img, (width, height))
    img_rgba = new_img.convert('RGBA')
    text_img = Image.new('RGBA', img_rgba.size, (255, 255, 255, 0))
    draw = ImageDraw.Draw(text_img)
    # 添加水印
    # 文本位置, 颜色, 透明度
    font = ImageFont.truetype('font/cn/华文仿宋.ttf', 30)
    # print(len(text) * 12)
    # print(random.randint(12, 20))
    list_ch = [0, 40, 80]
    for i in range(0, img_rgba.size[0], len(text) * 20):
        for j in range(0, img_rgba.size[1], 60):
            draw.text((i + random.choice(list_ch), j), text, font=font, fill=(0, 0, 0, 20))
    # 旋转文字 45 度
    text_img = text_img.rotate(-40)
    # 合成水印图片
    img_with_watermark = Image.alpha_composite(img_rgba, text_img)
    # 原始图片尺寸
    img_with_watermark = img_with_watermark.crop((width, height, width * 2, height * 2))

    return img_with_watermark.convert("RGB")