#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Time    : 2020-05-11 15:12
# @Author  : zhangyunfei
# @File    : LogoTemplatesmall.py
# @Software: PyCharm
from PIL import Image,ImageDraw

class tenplateGenerator():

    def __init__(self):
        self.width = 380
        self.height = 280

    # 品牌语和标语生成函数，该函数是品牌语和标语都存在的情况下使用
    def generator(self, brand_text, brand_font, brand_color,location, slogan_text, slogan_font, slogan_color,
                  logo_img):
        # 生成空白logo图像，指定背景颜色和大小
        logo_gen_image = Image.new('RGB', (self.width, self.height), (255, 255, 255))
        # logo_gen_image = Image.open("data/alpha.png")
        # 定义画笔
        draw = ImageDraw.Draw(logo_img)
        # 获取品牌语font的大小
        brand_width, brand_height = brand_font.getsize(brand_text)
        # print('品牌语字体大小:', brand_width, brand_height)
        # 获取标语font的大小
        slogan_width, slogan_height = slogan_font.getsize(slogan_text)
        # print('标语字体大小:', slogan_width, slogan_height)
        #空白区域的大小为
        location_width = location[2] - location[0]
        location_height = location[3] - location[1]

        # 中心点坐标
        center_x = int((location[0] + location[2]) / 2)
        center_y = int((location[1] + location[3]) / 2)
        #生成文字的总长度和宽度为
        text_width = max(brand_width, slogan_width)
        text_height = brand_height + slogan_height
        # print('location----------:', location_width, location_height)
        # print('text------------:', text_width, text_height)

        if text_width < location_width  and text_height < location_height:
            brand_x = center_x - int(brand_width / 2)
            brand_y = center_y - int((brand_height + slogan_height) / 2)
            # print('品牌语开始位置:', brand_x, brand_y)
            slogan_x = center_x - int(slogan_width / 2)
            slogan_y = brand_y + brand_height
            # print('标语开始位置:', slogan_x, slogan_y)
            draw.text((brand_x, brand_y), brand_text, brand_color, brand_font)
            draw.text((slogan_x, slogan_y), slogan_text, slogan_color, slogan_font)
            scale = 1.2
            scale_width ,scale_height = int(380/scale),int(280/scale)
            logo_img_resize = logo_img.resize((scale_width ,scale_height),Image.ANTIALIAS)
            # logo_gen_image.paste(logo_img, (0, 0))
            logo_gen_image.paste(logo_img_resize, (190-int(scale_width/2), 140-int(scale_height/2)))
            return logo_gen_image
        else:
            return None
