#!/usr/bin/python3
# -*- coding: utf-8 -*- #文件也为UTF-8
import LogoGenerator
import pymysql,requests
import random
import re
import customizelogosmall
import json
import  time
from threading import Thread

#随机取50个descid，其中15个模板id，35个logoid
def GetDescId(sptagdata,templatedata):
    returnlist = []
    if len(templatedata) <= 15:
        returnlist.extend(templatedata)
    else:
        returnlist.extend(random.sample(templatedata,15))
    if len(sptagdata) <= (50- len(returnlist)):
        returnlist.extend(sptagdata)
    else:
        returnlist.extend(random.sample(sptagdata, 50- len(returnlist)))
    return returnlist

#多线程处理生成logo
def wgetlogo(logourl,logoinfo):
    res_info = logoinfo
    data1 = requests.post(logourl, json=logoinfo).json()
    if data1["status"] == 0:
        res_info["pic_url"] =  data1["data"]
        return res_info
    else:
        return {}

class MyThread(Thread):
    def __init__(self, func, args):
        super(MyThread, self).__init__()
        self.func = func
        self.args = args

    def run(self):
        self.result = self.func(*self.args)

    def get_result(self):
        try:
            return self.result
        except Exception:
            return None

#把计算的LOGO结果存入数据库
def SaveLogoResource(inputdata,msg_id,cur):
    try:
        # 调用process方法或服务
        sptagapi = 'http://43.247.184.94:18009/gsb/api/textquery'
        text =  inputdata["profession"] + ":" + inputdata["title"]
        data1 = {"input_text":text }  # 接口访问参数
        # params = json.dumps(data, ensure_ascii=False)
        sptagdata = []
        try:
            sptagdata1 = requests.post(sptagapi, json=data1).json()  # 得到logoid
            # 过滤行业
            idlist = []
            for idinfo in sptagdata1:
                idlist.append(idinfo["id"])
                select_sql = "select * from logo_desc where id = %s" % idinfo["id"]
                cur.execute(select_sql)
                msg = cur.fetchone()
                if msg["profession"] == inputdata["profession"]:
                    sptagdata.append({"id": msg["id"]})
        except:#若语义分析出错，随机取50个
            select_sql = 'SELECT id FROM `logo_desc` WHERE type = "standard" and mark = 0 and profession = %s and id >= ( SELECT floor(RAND() ' \
                         '* (SELECT MAX(id) FROM `logo_desc`))) ORDER BY id LIMIT 50' % inputdata["profession"]
            cur.execute(select_sql)
            msgs = cur.fetchall()
            for ms in msgs:
                sptagdata.append({"id": ms["id"]})
        #sptagdata = [{"id":"1"},{"id":"2"},{"id":"3"}]
        #取模板id
        templatedata = []
        select_sql = 'select id from logo_desc where type = "template" '
        cur.execute(select_sql)
        msgs = cur.fetchall()
        for ms in msgs:
            templatedata.append({"id":ms["id"]})
        #取30条语义分析结果都是logo的，再随机20条模板
        descList = GetDescId(sptagdata,templatedata)
        for data in descList:
            select_sql='select id,first_color,sec_color,height,width,profession,description,textpos,' \
                       'originality,type from logo_desc where id = "%s"' % data["id"]
            cur.execute(select_sql)
            msg=cur.fetchone()
            insert_sql='insert into logo_res (logo_id,first_color,sec_color,height,width,profession,description,textpos,' \
                   'originality,type,msg_id) VALUES(%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)'

            logo_id = msg["id"]
            first_color = msg["first_color"]
            sec_color = msg["sec_color"]
            height = msg["height"]
            width = msg["width"]
            profession = msg["profession"]
            description = msg["description"]
            originality = msg["originality"]
            textpos = msg["textpos"]
            type = msg["type"]
            #msg_id = msg_id
            tup = (logo_id, first_color, sec_color, height, width, profession, description,textpos,originality,
                   type,msg_id)
            #print(str(tup))
            cur.execute(insert_sql, tup)
        #connection.commit()
        #connection.close()
        return  True
    except Exception as e:
        #print(str(e))
        #connection.rollback()
        #connection.close()
        return  False

#把生成的单个Logo信息存入数据库
def SaveSingleLogo(inputdata):
    try:
        #3.调用云飞生成logo方法，把json_str传过去
        #print("调用云飞生成logo方法")
        if inputdata["type"] == "standard":
            gen_json = {
                'brand_text': inputdata['title'],  # 品牌名称
                'brand_font': inputdata["font_url"],  # 字体路径
                'brand_color': inputdata['first_color'],  # 字体颜色
                'brand_location': inputdata['textpos'],  # 左右上下
                'slogan_text': inputdata['subtitle'],  # 标语名称
                'slogan_font': inputdata["font_url"],  # 字体路径
                'slogan_color': inputdata['sec_color'],  # 标语颜色
                'logo_url': inputdata['log_url']  # 图片地址
            }
            json_str = LogoGenerator.gen_main(gen_json)
        else:
            #因目前只有八个模板，且是画的，需要把数据库的模板id对应到1-8的模板上
            model_id = 0
            if inputdata["logo_id"]  > 76 and inputdata["logo_id"] < 83:
                model_id = inputdata["logo_id"] - 76
            elif inputdata["logo_id"]  > 84 and inputdata["logo_id"] < 87:
                model_id = inputdata["logo_id"] - 78


            gen_json = {
                'brand_text': inputdata['title'],  # 品牌名称
                'brand_font': inputdata["font_url"],  # 字体路径
                'brand_color': inputdata['first_color'],  # 字体颜色
                'brand_location': inputdata['textpos'],  # 左右上下
                'slogan_text': inputdata['subtitle'],  # 标语名称
                'slogan_font': inputdata["font_url"],  # 字体路径
                'slogan_color': inputdata['sec_color'],  # 标语颜色
                'logo_url': inputdata['log_url'], # 图片地址
                'model_id': model_id  # 目前是数据库id减76，用于满足1-8的要求,其他计算的id都传0
            }
            json_str = customizelogosmall.gen_main(gen_json)
        if json_str["status"]:
            js=json_str["image_gen_url"]

            return True,js
        else:
            return False, ""
    except Exception as e:
        return  False,""

#换一批
def ChangeABatch(inputdata):
    connection = pymysql.connect(host='rm-2zey194899z131oufao.mysql.rds.aliyuncs.com', port=3306, user='root',
                                 passwd='Gongsibao2018', db='logo_msg')  # 阿里云
    cur = connection.cursor(cursor=pymysql.cursors.DictCursor)
    try:
        select_sql = 'select * from input_msg where title="%s" and subtitle="%s" and profession="%s"' \
                     ' and description = "%s"' % (inputdata["title"], inputdata["subtitle"]
                                                  , inputdata["profession"], inputdata["description"])
        cur.execute(select_sql)
        data = cur.fetchone()
        res_list = []
        if data and data["isasy"]:#说明已做过生成
            mgs_id = data["id"]
            select_sql = "select * from logo_res where msg_id = %s and (pic_url is null or pic_url = '') " % mgs_id
            cur.execute(select_sql)
            data = cur.fetchall()
            if data:#如果存在未生成图片的
                len1 = 10
                if len(data) < 10:
                    len1 = len(data)
                random_list = random.sample(data, len1)
                for dl in random_list:
                    dict1 = {
                        "id": dl["id"],
                        "logo_id": dl["logo_id"],
                        "font_id": dl["font_id"],
                        "title":inputdata["title"],
                        "subtitle":inputdata["subtitle"],
                        "first_color": dl["first_color"],
                        "sec_color": dl["sec_color"],
                        "textpos": dl["textpos"],
                        "type": dl["type"],
                        "pic_url": ""
                    }
                    res_list.append(dict1)
            if len(res_list) < 10:#说明未生成的小于10个，去已生成的中再取其他的
                len1 = 10-len(res_list)
                select_sql = "select * from logo_res where msg_id = %s and (pic_url is not null and pic_url <> '') " % mgs_id
                cur.execute(select_sql)
                data = cur.fetchall()
                if len1 > len(data):
                    len1 = len(data)
                random_list = random.sample(data, len1)
                for dl in random_list:
                    dict1 = {
                        "id": dl["id"],
                        "logo_id": dl["logo_id"],
                        "font_id": dl["font_id"],
                        "title": inputdata["title"],
                        "subtitle": inputdata["subtitle"],
                        "first_color": dl["first_color"],
                        "sec_color": dl["sec_color"],
                        "textpos":dl["textpos"],
                        "type": dl["type"],
                        "pic_url": dl["pic_url"]
                    }
                    res_list.append(dict1)

            #对res_list中的数据做处理
            # 取所有字体
            fontlist = []
            select_sql = 'select * from logo_font '
            cur.execute(select_sql)
            data = cur.fetchall()
            for item in data:
                imagepath = item["name"]
                baseimagepath = 'font/cn/' + imagepath
                #baseimagepath = 'E:\\python\\logo\\bendi\\opencvTest\\font\\cn\\' + imagepath
                fontlist.append({"id": item["id"], "fonts_url": baseimagepath, "font_name": item["name"],
                                 "font_description": item["description"]})

            iserror = True
            threadlist = []#多线程
            res_temp = []#最后返回的结果
            for res in res_list:
                # qu一次log_url
                select_sql = "select * from logo_desc where id = %s" % res["logo_id"]
                cur.execute(select_sql)
                data22 = cur.fetchone()
                if data22:
                    res["log_url"] = data22["pic_url"]
                    res["color_description"] = data22["description"]
                else:
                    res["log_url"] = ""
                    res["color_description"] = ""

                #随机一个字体
                randnum = random.randint(0, len(fontlist) - 1)
                font_url = fontlist[randnum]["fonts_url"]
                font_id = fontlist[randnum]["id"]
                font_name = fontlist[randnum]["font_name"]
                font_dec = fontlist[randnum]["font_description"]
                res["font_id"] = font_id
                res["font_url"] = font_url
                res["font_name"] = font_name
                res["font_description"] = font_dec
                if not res["pic_url"]:
                    k = MyThread(wgetlogo, args=('http://createlogo-service/api/createlogo',res))
                    k.start()
                    threadlist.append(k)
                else:
                    res_temp.append(res)

            for th in threadlist:
                th.join()
                if th.get_result():
                    res_temp.append(th.get_result())
            Update_sql = "UPDATE `logo_msg`.`logo_res` SET  `pic_url`=%s,`font_id`=%s WHERE `id`=%s "
            update_list = []
            for res in res_temp:
                if res["pic_url"]:
                    tub = (res["pic_url"], res["font_id"], res["id"])
                    update_list.append(tub)
            cur.executemany(Update_sql, update_list)
            try:
                connection.commit()
            except:
                connection.rollback()
                iserror = False
            connection.close()

            if iserror and len(res_temp):
                return True, len(res_temp), res_temp
            else:
                return False, 0, []

        else:#说明该任务信息还没有做过生成
            connection.close()
            return ReturnLogoInfo(inputdata,1,10)
    except Exception as e:
        return  False,0,[]


#返回logo信息
def ReturnLogoInfo(inputdata,curpage,pagesize):
    connection = pymysql.connect(host='rm-2zey194899z131oufao.mysql.rds.aliyuncs.com', port=3306, user='root',
                                 passwd='Gongsibao2018', db='logo_msg')  # 阿里云
    cur = connection.cursor(cursor=pymysql.cursors.DictCursor)
    iserror = True
    try:

        select_sql='select * from input_msg where title="%s" and subtitle="%s" and profession="%s"' \
                   ' and description = "%s"' % (inputdata["title"],inputdata["subtitle"]
                                                    ,inputdata["profession"],inputdata["description"])
        cur.execute(select_sql)
        data=cur.fetchone()
        msg_id = ""
        isasy = 0#是否做过语义分析
        if data:#若信息存在
            #取msg_id
            msg_id = data["id"]
            isasy = data["isasy"]
            insert_sql = 'INSERT INTO `logo_msg`.`logo_task` ( `title`, `subtitle`, `profession`, `description`, `date`, `msg_id`) VALUES (%s,%s,%s,%s,%s,%s)'
            tub = (inputdata["title"],inputdata["subtitle"] ,inputdata["profession"],inputdata["description"], time.strftime("%Y-%m-%d %H:%M:%S", time.localtime()),msg_id)
            cur.execute(insert_sql,tub)
        else:#信息不存在
            #插入信息表
            insert_sql = 'INSERT INTO `logo_msg`.`input_msg` (`title`, `subtitle`, `profession`, `description`) VALUES  (%s,%s,%s,%s)'
            tub = (inputdata["title"],inputdata["subtitle"] ,inputdata["profession"],inputdata["description"])
            cur.execute(insert_sql,tub)
            select_sql = 'select * from input_msg where title="%s" and subtitle="%s" and profession="%s"' \
                         ' and description = "%s"' % (inputdata["title"], inputdata["subtitle"]
                                                      , inputdata["profession"], inputdata["description"])
            cur.execute(select_sql)
            data1 = cur.fetchone()
            if data1:
                msg_id = data1["id"]
            insert_sql = 'INSERT INTO `logo_msg`.`logo_task` ( `title`, `subtitle`, `profession`, `description`, `date`, `msg_id`) VALUES (%s,%s,%s,%s,%s,%s)'
            tub = (inputdata["title"],inputdata["subtitle"] ,inputdata["profession"],inputdata["description"], time.strftime("%Y-%m-%d %H:%M:%S", time.localtime()),msg_id)
            cur.execute(insert_sql,tub)
            #connection.commit()

        if not isasy:
            #如果没做过语义分析,调用语义分析
            if not SaveLogoResource(inputdata,msg_id,cur):
                iserror = False; #语义分析失败
            else:
                update_sql = "update input_msg set isasy = %s where id = %s"
                tub = (1,msg_id)
                cur.execute(update_sql, tub)


        #根据id取语义分析的结果
        select_sql  = 'select * from logo_res where msg_id = "%s"' % msg_id
        #cur = connection.cursor(cursor=pymysql.cursors.DictCursor)
        cur.execute(select_sql)
        res_list = cur.fetchall()
        re_count = 30
        if len(res_list) <30:
            re_count = len(res_list)
        random_list = random.sample(res_list, re_count)

        #取所有字体
        fontlist = []
        select_sql = 'select * from logo_font '
        cur.execute(select_sql)
        data = cur.fetchall()
        for item in data:
            imagepath = item["name"]
            baseimagepath = 'font/cn/' + imagepath
            #baseimagepath = 'E:\\python\\logo\\bendi\\opencvTest\\font\\cn\\' + imagepath
            fontlist.append({"id": item["id"], "fonts_url": baseimagepath, "font_name": item["name"],
                             "font_description": item["description"]})
        #把结果分页，根据分页结果
        nfen = 1 #从第一页开始
        fen_dict = {}#分页信息
        temp_list = []
        threadlist = []
        res_temp = []
        for res in random_list:
            dict1= {}
            dict1["id"] = res["id"]
            dict1["title"] = inputdata["title"]
            dict1["subtitle"] = inputdata["subtitle"]
            dict1["first_color"] = res["first_color"]
            dict1["sec_color"] = res["sec_color"]
            dict1["height"] = res["height"]
            dict1["width"] = res["width"]
            dict1["profession"] = res["profession"]
            dict1["description"] = res["description"]
            dict1["textpos"] = res["textpos"]
            dict1["pic_url"] = res["pic_url"]
            dict1["originality"] = res["originality"]
            dict1["groundcolor"] = res["groundcolor"]
            dict1["type"] = res["type"]
            dict1["logo_id"] = res["logo_id"]
            #qu一次log_url
            select_sql = "select * from logo_desc where id = %s" % res["logo_id"]
            cur.execute(select_sql)
            data22 = cur.fetchone()
            if data22:
                dict1["log_url"] = data22["pic_url"]
                dict1["color_description"] = data22["description"]
            else:
                dict1["log_url"] = ""
                dict1["color_description"] = ""
            # 随机一个字体
            randnum = random.randint(0, len(fontlist) - 1)
            font_url = fontlist[randnum]["fonts_url"]
            font_id = fontlist[randnum]["id"]
            font_name = fontlist[randnum]["font_name"]
            font_dec = fontlist[randnum]["font_description"]
            dict1["font_id"] = font_id
            dict1["font_url"] = font_url  #
            dict1["font_name"] = font_name
            dict1["font_description"] = font_dec


            temp_list.append(dict1)
            if len(temp_list) == pagesize:
                fen_dict[nfen] = temp_list
                nfen += 1
                temp_list = []
        if temp_list:
            fen_dict[nfen] = temp_list

        #根据前端的当前page和pagesize
        if curpage > len(fen_dict):
            curpage = len(fen_dict)
        list_r = fen_dict[curpage]
        for r in list_r:
            if not r["pic_url"]:
                k = MyThread(wgetlogo, args=('http://createlogo-service/api/createlogo', r))
                k.start()
                threadlist.append(k)
            else:
                res_temp.append(r)


        for th in threadlist:
            th.join()
            if th.get_result():
                res_temp.append(th.get_result())
        Update_sql = "UPDATE `logo_msg`.`logo_res` SET  `pic_url`=%s,`font_id`=%s WHERE `id`=%s "
        update_list = []
        for res in res_temp:
            if res["pic_url"]:#没有生成图片的不返回
                tub = (res["pic_url"], res["font_id"], res["id"])
                update_list.append(tub)
        cur.executemany(Update_sql, update_list)
        try:
            connection.commit()
        except:
            connection.rollback()
            iserror = False
        connection.close()
        if iserror and len(res_temp):
            return True, len(res_temp), res_temp
        else:
            return False,0,[]
    except Exception as e:
        try:
            connection.rollback()
            connection.close()
            return False, 0, []
        except:
            return False, 0, []
