#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Time    : 2020-05-07 18:32
# @Author  : zhangyunfei
# @File    : LogoGeneratorSmall.py
# @Software: PyCharm
from PIL import Image
from PIL import ImageFont
from PIL import ImageDraw
import numpy as np
import os, time, random
from LogoUtil import downlogo,alpha2white,downlogo_path,add_watermark,put2oss

'''
    logo生成器,主要实现上下左右的logo生成
'''
class logoGenerator():

    def __init__(self):
        self.width = 380
        self.height = 280

    # 品牌语和标语生成函数，该函数是品牌语和标语都存在的情况下使用
    def generator(self, brand_text, brand_font, brand_color, brand_location, slogan_text, slogan_font, slogan_color,
                  logo_img):
        # 生成空白logo图像，指定背景颜色和大小
        logo_gen_image = Image.new('RGB', (self.width, self.height), (255, 255, 255))
        # 定义画笔
        draw = ImageDraw.Draw(logo_gen_image)
        # 获取品牌语font的大小
        brand_width, brand_height = brand_font.getsize(brand_text)
        # print('品牌语字体大小:', brand_width, brand_height)
        # 获取标语font的大小
        slogan_width, slogan_height = slogan_font.getsize(slogan_text)
        # print('标语字体大小:', slogan_width, slogan_height)
        # 加载logo图样，首先放缩图样
        lg_im_resize = logo_img.resize((80, 80), Image.ANTIALIAS)
        # 判断图样与文字的位置
        if brand_location == '右':
            brand_x = 230 - int(brand_width / 2)
            brand_y = 140 - int((brand_height + slogan_height) / 2)
            # print('品牌语开始位置:', brand_x, brand_y)
            slogan_x = 230 - int(slogan_width / 2)
            slogan_y = brand_y + brand_height
            # print('标语开始位置:', slogan_x, slogan_y)
            # 书写文字
            draw.text((brand_x, brand_y), brand_text, brand_color, brand_font)
            draw.text((slogan_x, slogan_y), slogan_text, slogan_color, slogan_font)
            # 找出生成的标语和品牌语的起始位置最小的
            lg_w_x = min(brand_x, slogan_x)
            lg_w = lg_w_x - 80
            lg_h = 100
            logo_gen_image.paste(lg_im_resize, (lg_w, lg_h))
        elif brand_location == '左':
            brand_x = 150 - int(brand_width / 2)
            brand_y = 140 - int((brand_height + slogan_height) / 2)
            # print('品牌语开始位置:', brand_x, brand_y)
            slogan_x = 150 - int(slogan_width / 2)
            slogan_y = brand_y + brand_height
            # print('标语开始位置:', slogan_x, slogan_y)
            draw.text((brand_x, brand_y), brand_text, brand_color, brand_font)
            draw.text((slogan_x, slogan_y), slogan_text, slogan_color, slogan_font)
            # 找出生成的标语和品牌语的起始位置最小的
            lg_w_x = min(brand_x, slogan_x)
            # 找出图样在右边的起始位置
            lg_w = lg_w_x + max(brand_width, slogan_width)
            lg_h = 100
            logo_gen_image.paste(lg_im_resize, (lg_w, lg_h))
        elif brand_location == '上':
            brand_x = 190 - int(brand_width / 2)
            brand_y = 100 - int((brand_height + slogan_height) / 2)
            # print('品牌语开始位置:', brand_x, brand_y)
            slogan_x = 190 - int(slogan_width / 2)
            slogan_y = brand_y + brand_height
            # print('标语开始位置:', slogan_x, slogan_y)
            draw.text((brand_x, brand_y), brand_text, brand_color, brand_font)
            draw.text((slogan_x, slogan_y), slogan_text, slogan_color, slogan_font)
            # 找出生成的标语和品牌语的起始位置最小的
            lg_w_h = max(brand_y, slogan_y)
            # 找出图样在右边的起始位置
            lg_w = 150
            lg_h = lg_w_h + min(brand_height, slogan_height)
            logo_gen_image.paste(lg_im_resize, (lg_w, lg_h))
        elif brand_location == '下':
            brand_x = 190 - int(brand_width / 2)
            brand_y = 180 - int((brand_height + slogan_height) / 2)
            # print('品牌语开始位置:', brand_x, brand_y)
            slogan_x = 190 - int(slogan_width / 2)
            slogan_y = brand_y + brand_height
            # print('标语开始位置:', slogan_x, slogan_y)
            draw.text((brand_x, brand_y), brand_text, brand_color, brand_font)
            draw.text((slogan_x, slogan_y), slogan_text, slogan_color, slogan_font)
            # 找出生成的标语和品牌语的起始位置最小的
            lg_w_h = min(brand_y, slogan_y)
            # 找出图样在右边的起始位置
            lg_w = 150
            lg_h = lg_w_h - 82
            logo_gen_image.paste(lg_im_resize, (lg_w, lg_h))
        return logo_gen_image


# 生成logo主函数
def gen_main(gen_json):
    try:
        # 创建生成图像存储路径
        if not os.path.exists('generatordir'):
            os.makedirs('generatordir')
        # 下载图标/图案路径
        if not os.path.exists('logodir'):
            os.makedirs('logodir')
        # 图标下载
        logo_url = gen_json['logo_url']
        # logo名字
        logo_name = time.strftime('%Y%m%d%H%M%S') + str(random.randint(100, 10000)) + '.png'
        logo_down_path = 'logodir/' + logo_name
        # 本地下载logo样式方法
        logo_down_result = downlogo(logo_down_path, logo_url)
        # 线上读取logo样式方法
        #logo_down_result = downlogo_path(logo_down_path, logo_url)

        # 定义生成的图像接受对象
        if logo_down_result:
            # 判断标语是否存在
            logo_img = Image.open(logo_down_path)
            lg_gen = logoGenerator()
            brand_text = gen_json['brand_text']
            brand_color_str = gen_json['brand_color']
            brand_color_list = brand_color_str.replace('(', '').replace(')', '').split(',')
            brand_color = (int(brand_color_list[0]), int(brand_color_list[1]), int(brand_color_list[2]))
            if len(brand_text) < 8:
                brand_size = 42
            else:
                brand_size = 30
            brand_location = gen_json['brand_location']
            slogan_text = gen_json['slogan_text']
            slogan_color_str = gen_json['slogan_color']
            slogan_color_list = slogan_color_str.replace('(', '').replace(')', '').split(',')
            slogan_color = (int(slogan_color_list[0]), int(slogan_color_list[1]), int(slogan_color_list[2]))
            slogan_size = 16
            # brand_font = ImageFont.truetype('font/cn/华文行楷.ttf', brand_size)
            brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
            # slogan_font = ImageFont.truetype(gen_json['slogan_font'], slogan_size)
            slogan_font = ImageFont.truetype("font/cn/微软vista雅黑.ttf", slogan_size)
            gen_img = lg_gen.generator(brand_text, brand_font, brand_color, brand_location, slogan_text, slogan_font,
                                       slogan_color, alpha2white(logo_img))

            # 调用水印和版权图标
            # copyright_im = Image.open('copyright.png')
            gen_img_new = add_watermark(gen_img, 'www.gongsibao.com')
            gen_image_path = 'generatordir/' + 'generator_' + logo_name
            gen_img_new.save(gen_image_path)
            # gen_img_new.show()
            # 上传阿里云oss
            mosaicurl = put2oss('generator_' + logo_name, gen_image_path)
            return {
                'status': 1,
                'image_gen_url': mosaicurl,
                'msg':'success'
            }
        else:
            print('logo下载失败')
            return {
                'status': 0,
                'image_gen_url': '',
                'msg': '下载图标失败！'
            }
    except Exception as e:
        print(str(e))
        return {
            'status': 0,
            'image_gen_url': "",
            'msg': '出现异常：'+str(e)
        }

