#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Time    : 2020-05-07 18:19
# @Author  : zhangyunfei
# @File    : LogoBaseGenerator.py
# @Software: PyCharm
from PIL import Image,ImageDraw,ImageFont
import os,time
from LogoUtil import downlogo,alpha2white,make_zip,downlogo_path,put2oss
'''
    logo基础生成
    1.白底黑字
    2.黑底白字
    3.白底原色字
    4.黑底原色字--------------
    5.透明底白色字
    6.透明底黑色字
    7.透明底原色字
'''

#创建logobase类
class LogoBaseGen():

    def __init__(self):
        self.width = 2000
        self.height = 2000

    # 品牌语和标语生成函数，该函数是品牌语和标语都存在的情况下使用
    def generator_base(self,mode,brand_text, brand_font, brand_color, brand_location, slogan_text, slogan_font, slogan_color,
                  logo_img,bg_color):
        # 生成空白logo图像，指定背景颜色和大小
        logo_gen_image = Image.new(mode, (self.width, self.height), bg_color)
        # logo_gen_image = Image.open("data/alpha.png")
        # 定义画笔
        draw = ImageDraw.Draw(logo_gen_image)
        # 获取品牌语font的大小
        brand_width, brand_height = brand_font.getsize(brand_text)
        # print('品牌语字体大小:', brand_width, brand_height)
        # 获取标语font的大小
        slogan_width, slogan_height = slogan_font.getsize(slogan_text)
        # print('标语字体大小:', slogan_width, slogan_height)
        # 加载logo图样，首先放缩图样
        lg_im_resize = logo_img.resize((300, 300), Image.ANTIALIAS)
        # 判断图样与文字的位置
        if brand_location == '右':
            brand_x = 1150 - int(brand_width / 2)
            brand_y = 1000 - int((brand_height + slogan_height) / 2)
            # print('品牌语开始位置:', brand_x, brand_y)
            slogan_x = 1150 - int(slogan_width / 2)
            slogan_y = brand_y + brand_height
            # print('标语开始位置:', slogan_x, slogan_y)
            # 书写文字
            draw.text((brand_x, brand_y), brand_text, brand_color, brand_font)
            draw.text((slogan_x, slogan_y), slogan_text, slogan_color, slogan_font)
            # 找出生成的标语和品牌语的起始位置最小的
            lg_w_x = min(brand_x, slogan_x)
            lg_w = lg_w_x - 305
            lg_h = 850
            logo_gen_image.paste(lg_im_resize, (lg_w, lg_h))
        elif brand_location == '左':
            brand_x = 850 - int(brand_width / 2)
            brand_y = 1000 - int((brand_height + slogan_height) / 2)
            # print('品牌语开始位置:', brand_x, brand_y)
            slogan_x = 850 - int(slogan_width / 2)
            slogan_y = brand_y + brand_height
            # print('标语开始位置:', slogan_x, slogan_y)
            draw.text((brand_x, brand_y), brand_text, brand_color, brand_font)
            draw.text((slogan_x, slogan_y), slogan_text, slogan_color, slogan_font)
            # 找出生成的标语和品牌语的起始位置最小的
            lg_w_x = min(brand_x, slogan_x)
            # 找出图样在右边的起始位置
            lg_w = lg_w_x + max(brand_width, slogan_width)
            lg_h = 850
            logo_gen_image.paste(lg_im_resize, (lg_w, lg_h))
        elif brand_location == '上':
            brand_x = 1000 - int(brand_width / 2)
            brand_y = 850 - int((brand_height + slogan_height) / 2)
            # print('品牌语开始位置:', brand_x, brand_y)
            slogan_x = 1000 - int(slogan_width / 2)
            slogan_y = brand_y + brand_height
            # print('标语开始位置:', slogan_x, slogan_y)
            draw.text((brand_x, brand_y), brand_text, brand_color, brand_font)
            draw.text((slogan_x, slogan_y), slogan_text, slogan_color, slogan_font)
            # 找出生成的标语和品牌语的起始位置最小的
            lg_w_h = max(brand_y, slogan_y)
            # 找出图样在右边的起始位置
            lg_w = 850
            lg_h = lg_w_h + min(brand_height, slogan_height)
            logo_gen_image.paste(lg_im_resize, (lg_w, lg_h))

        elif brand_location == '下':
            brand_x = 1000 - int(brand_width / 2)
            brand_y = 1150 - int((brand_height + slogan_height) / 2)
            # print('品牌语开始位置:', brand_x, brand_y)
            slogan_x = 1000 - int(slogan_width / 2)
            slogan_y = brand_y + brand_height
            # print('标语开始位置:', slogan_x, slogan_y)
            draw.text((brand_x, brand_y), brand_text, brand_color, brand_font)
            draw.text((slogan_x, slogan_y), slogan_text, slogan_color, slogan_font)
            # 找出生成的标语和品牌语的起始位置最小的
            lg_w_h = min(brand_y, slogan_y)
            # 找出图样在右边的起始位置
            lg_w = 850
            lg_h = lg_w_h - 305
            logo_gen_image.paste(lg_im_resize, (lg_w, lg_h))
        return logo_gen_image


    # 品牌语和标语生成函数，该函数是品牌语和标语都存在的情况下使用,透明底
    def generator_base_alpha(self, brand_text, brand_font, brand_color, brand_location, slogan_text, slogan_font,
                       slogan_color,logo_img):
        # 生成空白logo图像，指定背景颜色和大小
        logo_gen_image = Image.new('RGBA', (self.width, self.height), (0,0,0,0))
        # logo_gen_image = Image.open("data/alpha.png")
        # 定义画笔
        draw = ImageDraw.Draw(logo_gen_image)
        # 获取品牌语font的大小
        brand_width, brand_height = brand_font.getsize(brand_text)
        # print('品牌语字体大小:', brand_width, brand_height)
        # 获取标语font的大小
        slogan_width, slogan_height = slogan_font.getsize(slogan_text)
        # print('标语字体大小:', slogan_width, slogan_height)
        # 加载logo图样，首先放缩图样
        lg_im_resize = logo_img.resize((300, 300), Image.ANTIALIAS)
        # 判断图样与文字的位置
        if brand_location == '右':
            brand_x = 1150 - int(brand_width / 2)
            brand_y = 1000 - int((brand_height + slogan_height) / 2)
            # print('品牌语开始位置:', brand_x, brand_y)
            slogan_x = 1150 - int(slogan_width / 2)
            slogan_y = brand_y + brand_height
            # print('标语开始位置:', slogan_x, slogan_y)
            # 书写文字
            draw.text((brand_x, brand_y), brand_text, brand_color, brand_font)
            draw.text((slogan_x, slogan_y), slogan_text, slogan_color, slogan_font)
            # 找出生成的标语和品牌语的起始位置最小的
            lg_w_x = min(brand_x, slogan_x)
            lg_w = lg_w_x - 305
            lg_h = 850
            logo_gen_image.paste(lg_im_resize, (lg_w, lg_h))
        elif brand_location == '左':
            brand_x = 850 - int(brand_width / 2)
            brand_y = 1000 - int((brand_height + slogan_height) / 2)
            # print('品牌语开始位置:', brand_x, brand_y)
            slogan_x = 850 - int(slogan_width / 2)
            slogan_y = brand_y + brand_height
            # print('标语开始位置:', slogan_x, slogan_y)
            draw.text((brand_x, brand_y), brand_text, brand_color, brand_font)
            draw.text((slogan_x, slogan_y), slogan_text, slogan_color, slogan_font)
            # 找出生成的标语和品牌语的起始位置最小的
            lg_w_x = min(brand_x, slogan_x)
            # 找出图样在右边的起始位置
            lg_w = lg_w_x + max(brand_width, slogan_width)
            lg_h = 850
            logo_gen_image.paste(lg_im_resize, (lg_w, lg_h))
        elif brand_location == '上':
            brand_x = 1000 - int(brand_width / 2)
            brand_y = 850 - int((brand_height + slogan_height) / 2)
            # print('品牌语开始位置:', brand_x, brand_y)
            slogan_x = 1000 - int(slogan_width / 2)
            slogan_y = brand_y + brand_height
            # print('标语开始位置:', slogan_x, slogan_y)
            draw.text((brand_x, brand_y), brand_text, brand_color, brand_font)
            draw.text((slogan_x, slogan_y), slogan_text, slogan_color, slogan_font)
            # 找出生成的标语和品牌语的起始位置最小的
            lg_w_h = max(brand_y, slogan_y)
            # 找出图样在右边的起始位置
            lg_w = 850
            lg_h = lg_w_h + min(brand_height, slogan_height)
            logo_gen_image.paste(lg_im_resize, (lg_w, lg_h))

        elif brand_location == '下':
            brand_x = 1000 - int(brand_width / 2)
            brand_y = 1150 - int((brand_height + slogan_height) / 2)
            # print('品牌语开始位置:', brand_x, brand_y)
            slogan_x = 1000 - int(slogan_width / 2)
            slogan_y = brand_y + brand_height
            # print('标语开始位置:', slogan_x, slogan_y)
            draw.text((brand_x, brand_y), brand_text, brand_color, brand_font)
            draw.text((slogan_x, slogan_y), slogan_text, slogan_color, slogan_font)
            # 找出生成的标语和品牌语的起始位置最小的
            lg_w_h = min(brand_y, slogan_y)
            # 找出图样在右边的起始位置
            lg_w = 850
            lg_h = lg_w_h - 305
            logo_gen_image.paste(lg_im_resize, (lg_w, lg_h))
        # logo_gen_image = logo_gen_image.resize((2000, 2000), Image.ANTIALIAS)
        return logo_gen_image





#打包程序入口
def gen_main(gen_json):
    # 创建生成图像存储路径
    if not os.path.exists('downlogo'):
        os.makedirs('downlogo')
    # 创建生成图像存储路径
    if not os.path.exists('downlogo/zipdir'):
        os.makedirs('downlogo/zipdir')
    # 下载图标/图案路径
    if not os.path.exists('logodir'):
        os.makedirs('logodir')
    try:
        # 图标下载
        logo_url = gen_json['logo_url']
        # logo名字
        logo_name = time.strftime('%Y%m%d%H%M%S') + '.png'
        logo_down_path = 'logodir/' + logo_name
        # 本地下载logo样式方法
        logo_down_result = downlogo(logo_down_path, logo_url)
        # 线上读取logo样式方法
        #logo_down_result = downlogo_path(logo_down_path, logo_url)
        # 定义生成的图像接受对象
        if logo_down_result:
            # 判断标语是否存在
            logo_img = Image.open(logo_down_path)
            lg_gen = LogoBaseGen()
            brand_text = gen_json['brand_text']
            brand_color_str = gen_json['brand_color']
            brand_color_list = brand_color_str.replace('(', '').replace(')', '').split(',')
            brand_color = (int(brand_color_list[0]), int(brand_color_list[1]), int(brand_color_list[2]))
            brand_size = 180
            # brand_font = ImageFont.truetype('font/cn/华文中宋.ttf', brand_size)
            # brand_font_alpha = ImageFont.truetype('font/cn/华文中宋.ttf', brand_size)
            brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
            brand_font_alpha = ImageFont.truetype(gen_json["brand_font"], brand_size)
            brand_location = gen_json['brand_location']
            slogan_text = gen_json['slogan_text']
            slogan_color_str = gen_json['slogan_color']
            slogan_color_list = slogan_color_str.replace('(', '').replace(')', '').split(',')
            slogan_color = (int(slogan_color_list[0]), int(slogan_color_list[1]), int(slogan_color_list[2]))
            slogan_size = 60
            slogan_font = ImageFont.truetype('font/cn/微软vista雅黑.ttf', slogan_size)
            slogan_font_alpha = ImageFont.truetype('font/cn/微软vista雅黑.ttf', slogan_size)
            #创建存放生成该品牌语的路径
            brand_path = 'downlogo/'+brand_text+'/高清Logo'
            if not os.path.exists(brand_path):
                os.makedirs(brand_path)

            # 白底黑字
            white_bottom_black_text = lg_gen.generator_base('RGBA',brand_text, brand_font, (0,0,0), brand_location, slogan_text,
                                       slogan_font,(0, 0, 0), alpha2white(logo_img),(255,255,255))
            # 黑底白字
            black_bottom_white_text = lg_gen.generator_base('RGB',brand_text, brand_font, (255, 255, 255), brand_location, slogan_text,
                                                       slogan_font, (255, 255, 255), logo_img, (0, 0, 0))
            # 白底原色字
            white_bottom_color_text = lg_gen.generator_base('RGBA',brand_text, brand_font, brand_color, brand_location, slogan_text,
                                                       slogan_font, slogan_color, alpha2white(logo_img), (255, 255, 255))
            # 黑底原色字
            black_bottom_color_text = lg_gen.generator_base('RGB',brand_text, brand_font, brand_color, brand_location,
                                                       slogan_text,slogan_font, slogan_color, logo_img, (0, 0, 0))

            # 透明底白色字
            alpha_bottom_white_text = lg_gen.generator_base_alpha(brand_text, brand_font_alpha, (255,255,255), brand_location,
                                                       slogan_text,slogan_font_alpha, (255,255,255), logo_img)
            # 透明底黑色字
            alpha_bottom_black_text = lg_gen.generator_base_alpha(brand_text, brand_font_alpha, (0,0,0), brand_location,
                                                       slogan_text,slogan_font_alpha, (0,0,0), logo_img)
            # 透明底原色字
            alpha_bottom_color_text = lg_gen.generator_base_alpha(brand_text, brand_font_alpha, brand_color, brand_location,
                                                       slogan_text,slogan_font_alpha, slogan_color, logo_img)


            #保存生成的各种图像
            white_bottom_black_text_path = brand_path+'/'+'白底黑字.png'      #白底黑字
            black_bottom_white_text_path = brand_path+'/'+'黑底白字.png'      #黑底白字
            white_bottom_color_text_path = brand_path+'/'+'白底原色字.png'    #白底原色字
            black_bottom_color_text_path = brand_path+'/'+'黑底原色字.png'    #黑底原色字
            alpha_bottom_white_text_path = brand_path+'/'+'透明底白色字.png'  # 透明底白色字
            alpha_bottom_black_text_path = brand_path+'/'+'透明底黑色字.png'  # 透明底黑色字
            alpha_bottom_color_text_path = brand_path+'/'+'透明底原色字.png'  # 透明底原色字

            white_bottom_black_text.save(white_bottom_black_text_path)
            black_bottom_white_text.save(black_bottom_white_text_path)
            white_bottom_color_text.save(white_bottom_color_text_path)
            black_bottom_color_text.save(black_bottom_color_text_path)
            alpha_bottom_white_text.save(alpha_bottom_white_text_path)
            alpha_bottom_black_text.save(alpha_bottom_black_text_path)
            alpha_bottom_color_text.save(alpha_bottom_color_text_path)
            #创建说明文档
            with open('downlogo/'+brand_text+'/使用说明.txt','w') as ff:
                context1 = '-----------------文件附录-----------------\n'
                context2 = '高清Logo图，包含七种png图像\n'
                context3 = '矢量源文件\n'
                ff.write(context1)
                ff.write(context2)
                ff.write(context3)
            zip_path,zip_name = make_zip(brand_text)

            #将压缩包上传到阿里云oss上
            down_url = put2oss(zip_name,zip_path)
            # print(down_url)

            return {
                'status': 1,
                'down_url': down_url,
                'msg':'success'
            }
        else:
            return {
                'status': 0,
                'down_url': '',
                'msg':'下载图标失败！'
            }
    except Exception as e:
        print(e)
        return {
            'status': 0,
            'down_url': '',
            'msg': '出现异常：'+str(e)
        }