#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Time    : 2020-05-08 11:05
# @Author  : zhangyunfei
# @File    : CustomizeBaseLogo.py
# @Software: PyCharm
# 创建下载的自定义模板logo图
'''
    实现自定义模板生成logo
'''
import os, time,random
from PIL import Image, ImageDraw, ImageFont
from LogoUtil import make_zip,put2oss,alpha2white,downlogo
from LogoTemplateDownload import tenplateGenerator

width, height = 2000, 2000


# 实现竖排字体
def vertical_template(model, modelcolor, brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
    logo_image = Image.new(model, (width, height), modelcolor)
    draw = ImageDraw.Draw(logo_image)
    # 获取品牌语font的大小
    brand_width, brand_height = brand_font.getsize(brand_text)
    # print('品牌语字体大小:', brand_width, brand_height)
    # 获取标语font的大小
    slogan_width, slogan_height = slogan_font.getsize(slogan_text)
    # print('标语字体大小:', slogan_width, slogan_height)
    # 获取宽度
    text_width = brand_height + slogan_height
    # 品牌语开始位置
    brand_width_start = 1000 - int((brand_height + slogan_height) / 2)
    brand_h = 0
    for ch in brand_text:
        ch_width, ch_height = brand_font.getsize(ch)
        brand_h += ch_height
    brand_height_start = 1000 - int(brand_h / 2)
    # 标语开始位置
    slogan_h = 0
    for ch in slogan_text:
        ch_width, ch_height = slogan_font.getsize(ch)
        slogan_h += ch_height
    slogan_width_start = brand_width_start + brand_height
    slogan_height_start = 1000 - int(slogan_h / 2)

    # draw.line((brand_width_start,brand_height_start,brand_width_start+200,brand_height_start),fill=(255,255,255),width=3)
    # draw.line((brand_width_start, brand_height_start, brand_width_start + 200, brand_height_start),
    #           fill=(255, 255, 255), width=3)

    # 开始书写品牌语
    brand_down = 0
    for ch in brand_text:
        ch_width, ch_height = brand_font.getsize(ch)
        # print(ch_width)
        draw.text((brand_width_start + int(brand_height / 2) - int(ch_width / 2), brand_height_start + brand_down), ch,
                  brand_color, brand_font)
        brand_down += ch_height
    # 开始书写标语
    slogan_down = 0
    for ch in slogan_text:
        ch_width, ch_height = slogan_font.getsize(ch)
        draw.text((slogan_width_start + int(slogan_height / 2) - int(ch_width / 2), slogan_height_start + slogan_down),
                  ch, slogan_color, slogan_font)
        slogan_down += ch_height

    return logo_image
    # logo_image.show()
    # logo_image.save('000.png')


# 实现品牌语被矩形框包围
def rectangle_template(model, modelcolor, brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
    logo_image = Image.new(model, (width, height), modelcolor)
    draw = ImageDraw.Draw(logo_image)
    # 品牌语整体的长宽
    brand_width, brand_height = brand_font.getsize(brand_text)
    # 标语的宽高
    slogan_width, slogan_height = slogan_font.getsize(slogan_text)
    # 获取品牌语单个字符的宽度
    brand_w = 0
    for ch in brand_text:
        ch_width, ch_height = brand_font.getsize(ch)
        # print(ch_width, ch_height, brand_height)
        brand_w += ch_width
    # 品牌语开始位置
    brand_width_start = 1000 - int(brand_w / 2)
    brand_height_start = 1000 - int((brand_height + slogan_height) / 2)
    # 标语开始位置
    slogan_width_start = 1000 - int(slogan_width / 2)
    slogan_height_start = brand_height_start + brand_height
    move_w = 0
    for i, ch in enumerate(brand_text):
        ch_width, ch_height = brand_font.getsize(ch)
        draw.text((brand_width_start + move_w, brand_height_start), ch, brand_color, brand_font)
        if i == 0:
            draw.rectangle((brand_width_start + move_w, brand_height_start, brand_width_start + move_w + ch_width,
                            brand_height_start + brand_height), outline='black', width=4)
        else:
            draw.rectangle((brand_width_start + move_w + 10, brand_height_start, brand_width_start + move_w + ch_width,
                            brand_height_start + brand_height), outline='black', width=4)

        move_w += ch_width

    draw.text((slogan_width_start, slogan_height_start), slogan_text, slogan_color, slogan_font)

    # logo_image.show()
    return logo_image


# 实现logo被矩形颜色框包围(涉及半透明图像alpha通道)
def rectanglecolor_template(model, modelcolor, brand_text, brand_font, brand_color, slogan_text, slogan_font,
                            slogan_color):
    logo_image = Image.new(model, (width, height), modelcolor)
    draw = ImageDraw.Draw(logo_image)
    # 品牌语整体的长宽
    brand_width, brand_height = brand_font.getsize(brand_text)
    # 标语的宽高
    slogan_width, slogan_height = slogan_font.getsize(slogan_text)
    # 品牌语开始位置
    brand_width_start = 1000 - int(brand_width / 2)
    brand_height_start = 1000 - int((brand_height + slogan_height) / 2)
    # 标语开始位置
    slogan_width_start = 1000 - int(slogan_width / 2)
    slogan_height_start = brand_height_start + brand_height

    # 找出长度最大的文本
    w_max = max(brand_width, slogan_width)

    draw.text((brand_width_start, brand_height_start), brand_text, brand_color, brand_font)
    draw.text((slogan_width_start, slogan_height_start), slogan_text, slogan_color, slogan_font)

    # 新定一个带alpha通道的图像，画两个矩形
    # 矩形一位置
    rec_x = 1000 - int(w_max / 2)
    rec_y = 1000 - int((brand_height + slogan_height) / 2)
    alpha_logo = Image.new(model, (width, height), modelcolor).convert('RGBA')
    alpha_draw = ImageDraw.Draw(alpha_logo)
    # 画透明矩形
    alpha_draw.rectangle((rec_x - 50, rec_y - 50, rec_x + w_max,
                          rec_y + brand_height + slogan_height), fill=(173, 177, 185, 50))
    alpha_draw.rectangle((rec_x, rec_y, rec_x + w_max + 50,
                          rec_y + brand_height + slogan_height + 50), fill=(173, 177, 185, 120))
    # 将两个图像融合的结果
    final = Image.new("RGBA", (width, height))  # 合成的image
    final = Image.alpha_composite(final, logo_image.convert('RGBA'))
    final = Image.alpha_composite(final, alpha_logo)
    # final = final.convert('RGB')
    # final.show()
    # final.save('image_mask.png')
    return final


# 实现对角线对角样式
def cornerline_template(model, modelcolor, brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
    logo_image = Image.new(model, (width, height), modelcolor)
    draw = ImageDraw.Draw(logo_image)
    # 品牌语整体的长宽
    brand_width, brand_height = brand_font.getsize(brand_text)
    # 标语的宽高
    slogan_width, slogan_height = slogan_font.getsize(slogan_text)
    # 品牌语开始位置
    brand_width_start = 1000 - int(brand_width / 2)
    brand_height_start = 1000 - int((brand_height + slogan_height) / 2)
    # 标语开始位置
    slogan_width_start = 1000 - int(slogan_width / 2)
    slogan_height_start = brand_height_start + brand_height

    # 找出长度最大的文本
    w_max = max(brand_width, slogan_width)

    draw.text((brand_width_start, brand_height_start), brand_text, brand_color, brand_font)
    draw.text((slogan_width_start, slogan_height_start), slogan_text, slogan_color, slogan_font)

    # 左上角开始位置

    left_x = 950 - int(w_max / 2)
    left_y = 950 - int((brand_height + slogan_height) / 2)
    # draw.line((left_x,left_y,left_x,left_y + 200),width=10,fill='green')
    # draw.line((left_x, left_y, left_x + 200, left_y ), width=10, fill='green')
    draw.rectangle((left_x, left_y, left_x + 10, left_y + 200), fill=(0, 0, 0))
    draw.rectangle((left_x, left_y, left_x + 200, left_y + 10), fill=(0, 0, 0))
    # 右下角开始位置
    right_x = 1050 + int(w_max / 2)
    right_y = 1050 + int((brand_height + slogan_height) / 2)
    # draw.line((right_x, right_y, right_x, right_y - 200), width=10, fill='green')
    # draw.line((right_x, right_y, right_x - 200, right_y), width=10, fill='green')
    draw.rectangle((right_x, right_y, right_x - 10, right_y - 200), fill=(0, 0, 0))
    draw.rectangle((right_x, right_y, right_x - 200, right_y - 10), fill=(0, 0, 0))

    # logo_image.show()
    return logo_image


# 实现两个品字型的样式
def twopin_template(model, modelcolor, brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
    logo_image = Image.new(model, (width, height), modelcolor)
    draw = ImageDraw.Draw(logo_image)
    # 品牌语整体的长宽
    brand_width, brand_height = brand_font.getsize(brand_text)
    # 标语的宽高
    slogan_width, slogan_height = slogan_font.getsize(slogan_text)
    # 品牌语开始位置
    brand_width_start = 1000 - int(brand_width / 2)
    brand_height_start = 1000 - int((brand_height + slogan_height) / 2)
    # 标语开始位置
    slogan_width_start = 1000 - int(slogan_width / 2)
    slogan_height_start = brand_height_start + brand_height

    # 找出长度最大的文本
    w_max = max(brand_width, slogan_width)

    draw.text((brand_width_start, brand_height_start), brand_text, brand_color, brand_font)
    draw.text((slogan_width_start, slogan_height_start), slogan_text, slogan_color, slogan_font)

    # 左边开始位置
    left_x = 980
    left_y = brand_height_start - 320
    # 矩形宽
    rect_w = 40
    # 画竖矩形
    draw.rectangle((left_x - 100, left_y + 20, left_x + 100 + rect_w, left_y + 20 + rect_w), fill=(0, 0, 0))  # 顶部矩形
    draw.rectangle((left_x - 100, left_y + 20, left_x - 100 + rect_w, left_y + 150), fill=(0, 0, 0))  # 上左矩形
    draw.rectangle((left_x + 100, left_y + 20, left_x + 100 + rect_w, left_y + 150), fill=(0, 0, 0))  # 上右矩形

    draw.rectangle((left_x - 200, left_y + 150, left_x - 100 + rect_w, left_y + 150 + rect_w), fill=(0, 0, 0))  # 上左下矩形
    draw.rectangle((left_x + 100, left_y + 150, left_x + 200 + rect_w, left_y + 150 + rect_w), fill=(0, 0, 0))  # 上右下矩形

    draw.rectangle((left_x - 200, left_y + 150, left_x - 200 + rect_w, left_y + 250), fill=(0, 0, 0))  # 上左下左矩形
    draw.rectangle((left_x + 200, left_y + 150, left_x + 200 + rect_w, left_y + 250), fill=(0, 0, 0))  # 上右下右矩形

    draw.rectangle((left_x, left_y + 20, left_x + rect_w, left_y + 250), fill=(0, 0, 0))  # 中间矩形
    draw.rectangle((left_x - 200, left_y + 250, left_x + 200 + rect_w, left_y + 250 + rect_w), fill=(0, 0, 0))  # 底部矩形
    # 左边矩形，中间为空
    draw.rectangle((left_x - 300, left_y - 40, left_x - 140, left_y + 120), outline='black',
                   width=40)
    draw.rectangle((left_x + 180, left_y - 40, left_x + 340, left_y + 120), outline='black',
                   width=40)

    # draw.rectangle((left_x, left_y, left_x + 200, left_y + 10), fill=(0, 0, 0))
    # 右下角开始位置
    # right_x = 1050 + int(w_max / 2)
    # right_y = 1050 + int((brand_height + slogan_height) / 2)
    # # draw.line((right_x, right_y, right_x, right_y - 200), width=10, fill='green')
    # # draw.line((right_x, right_y, right_x - 200, right_y), width=10, fill='green')
    # draw.rectangle((right_x, right_y, right_x - 10, right_y - 200), fill=(0, 0, 0))
    # draw.rectangle((right_x, right_y, right_x - 200, right_y - 10), fill=(0, 0, 0))
    # logo_image.show()
    return logo_image


# 实现线条半包围logo字体
def line_template(model, modelcolor, brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color):
    logo_image = Image.new(model, (width, height), modelcolor)
    draw = ImageDraw.Draw(logo_image)
    # 品牌语整体的长宽
    brand_width, brand_height = brand_font.getsize(brand_text)
    # 标语的宽高
    slogan_width, slogan_height = slogan_font.getsize(slogan_text)
    # 品牌语开始位置
    brand_width_start = 1000 - int(brand_width / 2)
    brand_height_start = 1000 - int((brand_height + slogan_height) / 2)
    # 标语开始位置
    slogan_width_start = 1000 - int(slogan_width / 2)
    slogan_height_start = brand_height_start + brand_height

    # 找出长度最大的文本
    w_max = max(brand_width, slogan_width)

    draw.text((brand_width_start, brand_height_start), brand_text, brand_color, brand_font)
    draw.text((slogan_width_start, slogan_height_start), slogan_text, slogan_color, slogan_font)

    # 左上角开始位置
    left_x = 900 - int(w_max / 2)
    left_y = 850 - int((brand_height + slogan_height) / 2)
    left_y_bottom = 1150 + int((brand_height + slogan_height) / 2)
    draw.rectangle((left_x, left_y, left_x + 10, left_y_bottom), fill=(0, 0, 0))
    draw.rectangle((left_x, left_y, left_x + 100 + int(w_max / 2), left_y + 10), fill=(0, 0, 0))
    draw.rectangle((left_x, left_y_bottom, left_x + +100 + int(w_max / 2), left_y_bottom + 10), fill=(0, 0, 0))
    draw.rectangle((left_x + 100 + int(w_max / 2), left_y, left_x + 100 + int(w_max / 2) + 10, left_y + 100),
                   fill=(0, 0, 0))
    draw.rectangle(
        (left_x + 100 + int(w_max / 2), left_y_bottom, left_x + 100 + int(w_max / 2) - 10, left_y_bottom - 100),
        fill=(0, 0, 0))
    # draw.rectangle((left_x, left_y_bottom, left_x + +100 + int(w_max / 2), left_y_bottom + 10), fill=(0, 0, 0))

    # 右下角开始位置
    # right_x = 1050 + int(w_max / 2)
    # right_y = 1050 + int((brand_height + slogan_height) / 2)
    # # draw.line((right_x, right_y, right_x, right_y - 200), width=10, fill='green')
    # # draw.line((right_x, right_y, right_x - 200, right_y), width=10, fill='green')
    # draw.rectangle((right_x, right_y, right_x - 10, right_y - 200), fill=(0, 0, 0))
    # draw.rectangle((right_x, right_y, right_x - 200, right_y - 10), fill=(0, 0, 0))

    # logo_image.show()
    return logo_image


# 实现竖排字体加上帽子
def verticalline_template(model, modelcolor, brand_text, brand_font, brand_color, slogan_text, slogan_font,
                          slogan_color):
    logo_image = Image.new(model, (width, height), modelcolor)
    draw = ImageDraw.Draw(logo_image)
    # 获取品牌语font的大小
    brand_width, brand_height = brand_font.getsize(brand_text)
    # print('品牌语字体大小:', brand_width, brand_height)
    # 获取标语font的大小
    slogan_width, slogan_height = slogan_font.getsize(slogan_text)
    # print('标语字体大小:', slogan_width, slogan_height)
    # 获取宽度
    text_width = brand_height + slogan_height
    # 品牌语开始位置
    brand_width_start = 1000 - int((brand_height + slogan_height) / 2)
    brand_h = 0
    for ch in brand_text:
        ch_width, ch_height = brand_font.getsize(ch)
        brand_h += ch_height
    brand_height_start = 1000 - int(brand_h / 2)
    # 标语开始位置
    slogan_h = 0
    for ch in slogan_text:
        ch_width, ch_height = slogan_font.getsize(ch)
        slogan_h += ch_height
    slogan_width_start = brand_width_start + brand_height
    slogan_height_start = 1000 - int(slogan_h / 2)

    # 开始书写品牌语
    brand_down = 0
    for ch in brand_text:
        ch_width, ch_height = brand_font.getsize(ch)
        draw.text((brand_width_start + int(brand_height / 2) - int(ch_width / 2), brand_height_start + brand_down), ch,
                  brand_color, brand_font)
        brand_down += ch_height
    # print(brand_down)
    # 开始书写标语
    slogan_down = 0
    for ch in slogan_text:
        ch_width, ch_height = slogan_font.getsize(ch)
        draw.text((slogan_width_start + int(slogan_height / 2) - int(ch_width / 2), slogan_height_start + slogan_down),
                  ch, brand_color, slogan_font)
        slogan_down += ch_height
    # print(slogan_down)

    # 帽子的坐标计算
    line_x = 1000 - int((brand_height + slogan_height) / 2)
    line_y = 1000 - int(max(slogan_down, brand_down) / 2)
    line_bottom_y = 1000 + int(max(slogan_down, brand_down) / 2)
    # 上边帽子
    draw.rectangle((line_x - 30, line_y - 30, line_x + text_width + 30, line_y - 20), fill=(255, 255, 255))
    draw.rectangle((line_x - 30, line_y - 30, line_x - 20, line_y + 20), fill=(255, 255, 255))
    draw.rectangle((line_x + text_width + 20, line_y - 30, line_x + text_width + 30, line_y + 20), fill=(255, 255, 255))

    # 下边帽子
    draw.rectangle((line_x - 30, line_bottom_y + 30, line_x + text_width + 30, line_bottom_y + 40),
                   fill=(255, 255, 255))
    draw.rectangle((line_x - 30, line_bottom_y + 30, line_x - 20, line_bottom_y - 20), fill=(255, 255, 255))
    draw.rectangle((line_x + text_width + 20, line_bottom_y + 30, line_x + text_width + 30, line_bottom_y - 20),
                   fill=(255, 255, 255))
    # logo_image.show()
    return logo_image


# 实现一半文字被梯形包围
def polygon_right_template(model, modelcolor, brand_text, brand_font, brand_color, slogan_text, slogan_font,
                           slogan_color):
    logo_image = Image.new(model, (width, height), modelcolor)
    draw = ImageDraw.Draw(logo_image)
    # 品牌语整体的长宽
    brand_width, brand_height = brand_font.getsize(brand_text)
    # 标语的宽高
    slogan_width, slogan_height = slogan_font.getsize(slogan_text)
    # 品牌语开始位置
    brand_width_start = 1000 - int(brand_width / 2)
    brand_height_start = 1000 - int((brand_height + slogan_height) / 2)
    # 标语开始位置
    slogan_width_start = 1000 - int(slogan_width / 2)
    slogan_height_start = brand_height_start + brand_height
    # 找出长度最大的文本
    w_max = max(brand_width, slogan_width)

    # 左边开始位置坐标
    left_x = 1000
    left_y = 1000 - int((brand_height + slogan_height) / 2)
    left_y_bottom = 1000 + int((brand_height + slogan_height) / 2)
    point1 = (left_x, left_y + 20)
    point2 = (left_x + int(w_max / 2) + 30, left_y - 20 - int((brand_height + slogan_height) / 4))
    point3 = (left_x + int(w_max / 2) + 30, left_y_bottom + 20 + int((brand_height + slogan_height) / 4))
    point4 = (left_x, left_y_bottom + 20)
    draw.polygon([point1, point2, point3, point4], fill=(102, 204, 255))
    draw.text((brand_width_start, brand_height_start), brand_text, brand_color, brand_font)
    draw.text((slogan_width_start, slogan_height_start), slogan_text, slogan_color, slogan_font)
    # logo_image.show()
    return logo_image


def down_customize_logo(gen_json):
    # 创建生成图像存储路径
    if not os.path.exists('downlogo'):
        os.makedirs('downlogo')
    # 创建生成图像存储路径
    if not os.path.exists('downlogo/zipdir'):
        os.makedirs('downlogo/zipdir')
    # 下载图标/图案路径
    if not os.path.exists('logodir'):
        os.makedirs('logodir')
    try:
        brand_text = gen_json['brand_text']
        brand_color_str = gen_json['brand_color']
        brand_color_list = brand_color_str.replace('(', '').replace(')', '').split(',')
        brand_color = (int(brand_color_list[0]), int(brand_color_list[1]), int(brand_color_list[2]))
        brand_size = 150
        # brand_font = ImageFont.truetype('font/cn/华文中宋.ttf', brand_size)
        brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
        customize_model_id = gen_json['model_id']
        slogan_text = gen_json['slogan_text']
        slogan_color_str = gen_json['slogan_color']
        slogan_color_list = slogan_color_str.replace('(', '').replace(')', '').split(',')
        slogan_color = (int(slogan_color_list[0]), int(slogan_color_list[1]), int(slogan_color_list[2]))
        slogan_size = 30
        slogan_font = ImageFont.truetype('font/cn/微软vista雅黑.ttf', slogan_size)
        # 创建存放生成该品牌语的路径
        brand_path = 'downlogo/' + brand_text + '/高清Logo'
        if not os.path.exists(brand_path):
            os.makedirs(brand_path)
        if customize_model_id == 1:  # 实现竖排字体,由于竖排文字需要对其文字大小限制
            # 白底黑字
            white_bottom_black_text = vertical_template('RGB', (255, 255, 255), brand_text, brand_font, (0, 0, 0),
                                                        slogan_text, slogan_font, (0, 0, 0))
            # 黑底白字
            black_bottom_white_text = vertical_template('RGB', (0, 0, 0), brand_text, brand_font, (255, 255, 255),
                                                        slogan_text, slogan_font, (255, 255, 255))
            # 白底原色字
            white_bottom_color_text = vertical_template('RGB', (255, 255, 255), brand_text, brand_font, brand_color,
                                                        slogan_text, slogan_font, slogan_color)
            # 黑底原色字
            black_bottom_color_text = vertical_template('RGB', (0, 0, 0), brand_text, brand_font, brand_color,
                                                        slogan_text, slogan_font, slogan_color)
            # 透明底白色字
            alpha_bottom_white_text = vertical_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, (255, 255, 255),
                                                        slogan_text, slogan_font, (255, 255, 255))
            # 透明底黑色字
            alpha_bottom_black_text = vertical_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, (0, 0, 0),
                                                        slogan_text, slogan_font, (0, 0, 0))
            # 透明底原色字
            alpha_bottom_color_text = vertical_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, brand_color,
                                                        slogan_text, slogan_font, slogan_color)
        elif customize_model_id == 2:  # 实现竖排字体,由于竖排文字需要对其文字大小限制
            # 白底黑字
            white_bottom_black_text = rectangle_template('RGB', (255, 255, 255), brand_text, brand_font, (0, 0, 0),
                                                         slogan_text, slogan_font, (0, 0, 0))
            # 黑底白字
            black_bottom_white_text = rectangle_template('RGB', (0, 0, 0), brand_text, brand_font, (255, 255, 255),
                                                         slogan_text, slogan_font, (255, 255, 255))
            # 白底原色字
            white_bottom_color_text = rectangle_template('RGB', (255, 255, 255), brand_text, brand_font, brand_color,
                                                         slogan_text, slogan_font, slogan_color)
            # 黑底原色字
            black_bottom_color_text = rectangle_template('RGB', (0, 0, 0), brand_text, brand_font, brand_color,
                                                         slogan_text, slogan_font, slogan_color)
            # 透明底白色字
            alpha_bottom_white_text = rectangle_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, (255, 255, 255),
                                                         slogan_text, slogan_font, (255, 255, 255))
            # 透明底黑色字
            alpha_bottom_black_text = rectangle_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, (0, 0, 0),
                                                         slogan_text, slogan_font, (0, 0, 0))
            # 透明底原色字
            alpha_bottom_color_text = rectangle_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, brand_color,
                                                         slogan_text, slogan_font, slogan_color)
        elif customize_model_id == 3:  # 实现竖排字体,由于竖排文字需要对其文字大小限制
            # 白底黑字
            white_bottom_black_text = rectanglecolor_template('RGB', (255, 255, 255), brand_text, brand_font, (0, 0, 0),
                                                              slogan_text, slogan_font, (0, 0, 0))
            # 黑底白字
            black_bottom_white_text = rectanglecolor_template('RGB', (0, 0, 0), brand_text, brand_font, (255, 255, 255),
                                                              slogan_text, slogan_font, (255, 255, 255))
            # 白底原色字
            white_bottom_color_text = rectanglecolor_template('RGB', (255, 255, 255), brand_text, brand_font,
                                                              brand_color,
                                                              slogan_text, slogan_font, slogan_color)
            # 黑底原色字
            black_bottom_color_text = rectanglecolor_template('RGB', (0, 0, 0), brand_text, brand_font, brand_color,
                                                              slogan_text, slogan_font, slogan_color)
            # 透明底白色字
            alpha_bottom_white_text = rectanglecolor_template('RGBA', (0, 0, 0, 0), brand_text, brand_font,
                                                              (255, 255, 255),
                                                              slogan_text, slogan_font, (255, 255, 255))
            # 透明底黑色字
            alpha_bottom_black_text = rectanglecolor_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, (0, 0, 0),
                                                              slogan_text, slogan_font, (0, 0, 0))
            # 透明底原色字
            alpha_bottom_color_text = rectanglecolor_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, brand_color,
                                                              slogan_text, slogan_font, slogan_color)
        elif customize_model_id == 4:  # 实现对角线对角样式
            # 白底黑字
            white_bottom_black_text = cornerline_template('RGB', (255, 255, 255), brand_text, brand_font, (0, 0, 0),
                                                          slogan_text, slogan_font, (0, 0, 0))
            # 黑底白字
            black_bottom_white_text = cornerline_template('RGB', (0, 0, 0), brand_text, brand_font, (255, 255, 255),
                                                          slogan_text, slogan_font, (255, 255, 255))
            # 白底原色字
            white_bottom_color_text = cornerline_template('RGB', (255, 255, 255), brand_text, brand_font, brand_color,
                                                          slogan_text, slogan_font, slogan_color)
            # 黑底原色字
            black_bottom_color_text = cornerline_template('RGB', (0, 0, 0), brand_text, brand_font, brand_color,
                                                          slogan_text, slogan_font, slogan_color)
            # 透明底白色字
            alpha_bottom_white_text = cornerline_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, (255, 255, 255),
                                                          slogan_text, slogan_font, (255, 255, 255))
            # 透明底黑色字
            alpha_bottom_black_text = cornerline_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, (0, 0, 0),
                                                          slogan_text, slogan_font, (0, 0, 0))
            # 透明底原色字
            alpha_bottom_color_text = cornerline_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, brand_color,
                                                          slogan_text, slogan_font, slogan_color)
        elif customize_model_id == 5:  # 实现两个品字型的样式
            # 白底黑字
            white_bottom_black_text = twopin_template('RGB', (255, 255, 255), brand_text, brand_font, (0, 0, 0),
                                                      slogan_text, slogan_font, (0, 0, 0))
            # 黑底白字
            black_bottom_white_text = twopin_template('RGB', (0, 0, 0), brand_text, brand_font, (255, 255, 255),
                                                      slogan_text, slogan_font, (255, 255, 255))
            # 白底原色字
            white_bottom_color_text = twopin_template('RGB', (255, 255, 255), brand_text, brand_font, brand_color,
                                                      slogan_text, slogan_font, slogan_color)
            # 黑底原色字
            black_bottom_color_text = twopin_template('RGB', (0, 0, 0), brand_text, brand_font, brand_color,
                                                      slogan_text, slogan_font, slogan_color)
            # 透明底白色字
            alpha_bottom_white_text = twopin_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, (255, 255, 255),
                                                      slogan_text, slogan_font, (255, 255, 255))
            # 透明底黑色字
            alpha_bottom_black_text = twopin_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, (0, 0, 0),
                                                      slogan_text, slogan_font, (0, 0, 0))
            # 透明底原色字
            alpha_bottom_color_text = twopin_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, brand_color,
                                                      slogan_text, slogan_font, slogan_color)
        elif customize_model_id == 6:  # 实现线条半包围logo字体
            # 白底黑字
            white_bottom_black_text = line_template('RGB', (255, 255, 255), brand_text, brand_font, (0, 0, 0),
                                                    slogan_text, slogan_font, (0, 0, 0))
            # 黑底白字
            black_bottom_white_text = line_template('RGB', (0, 0, 0), brand_text, brand_font, (255, 255, 255),
                                                    slogan_text, slogan_font, (255, 255, 255))
            # 白底原色字
            white_bottom_color_text = line_template('RGB', (255, 255, 255), brand_text, brand_font, brand_color,
                                                    slogan_text, slogan_font, slogan_color)
            # 黑底原色字
            black_bottom_color_text = line_template('RGB', (0, 0, 0), brand_text, brand_font, brand_color,
                                                    slogan_text, slogan_font, slogan_color)
            # 透明底白色字
            alpha_bottom_white_text = line_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, (255, 255, 255),
                                                    slogan_text, slogan_font, (255, 255, 255))
            # 透明底黑色字
            alpha_bottom_black_text = line_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, (0, 0, 0),
                                                    slogan_text, slogan_font, (0, 0, 0))
            # 透明底原色字
            alpha_bottom_color_text = line_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, brand_color,
                                                    slogan_text, slogan_font, slogan_color)
        elif customize_model_id == 7:  # 实现竖排字体加上帽子
            # 白底黑字
            white_bottom_black_text = verticalline_template('RGB', (255, 255, 255), brand_text, brand_font, (0, 0, 0),
                                                            slogan_text, slogan_font, (0, 0, 0))
            # 黑底白字
            black_bottom_white_text = verticalline_template('RGB', (0, 0, 0), brand_text, brand_font, (255, 255, 255),
                                                            slogan_text, slogan_font, (255, 255, 255))
            # 白底原色字
            white_bottom_color_text = verticalline_template('RGB', (255, 255, 255), brand_text, brand_font, brand_color,
                                                            slogan_text, slogan_font, slogan_color)
            # 黑底原色字
            black_bottom_color_text = verticalline_template('RGB', (0, 0, 0), brand_text, brand_font, brand_color,
                                                            slogan_text, slogan_font, slogan_color)
            # 透明底白色字
            alpha_bottom_white_text = verticalline_template('RGBA', (0, 0, 0, 0), brand_text, brand_font,
                                                            (255, 255, 255),
                                                            slogan_text, slogan_font, (255, 255, 255))
            # 透明底黑色字
            alpha_bottom_black_text = verticalline_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, (0, 0, 0),
                                                            slogan_text, slogan_font, (0, 0, 0))
            # 透明底原色字
            alpha_bottom_color_text = verticalline_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, brand_color,
                                                            slogan_text, slogan_font, slogan_color)
        elif customize_model_id == 8:  # 实现一半文字被梯形包围
            # 白底黑字
            white_bottom_black_text = polygon_right_template('RGB', (255, 255, 255), brand_text, brand_font, (0, 0, 0),
                                                             slogan_text, slogan_font, (0, 0, 0))
            # 黑底白字
            black_bottom_white_text = polygon_right_template('RGB', (0, 0, 0), brand_text, brand_font, (255, 255, 255),
                                                             slogan_text, slogan_font, (255, 255, 255))
            # 白底原色字
            white_bottom_color_text = polygon_right_template('RGB', (255, 255, 255), brand_text, brand_font,
                                                             brand_color,
                                                             slogan_text, slogan_font, slogan_color)
            # 黑底原色字
            black_bottom_color_text = polygon_right_template('RGB', (0, 0, 0), brand_text, brand_font, brand_color,
                                                             slogan_text, slogan_font, slogan_color)
            # 透明底白色字
            alpha_bottom_white_text = polygon_right_template('RGBA', (0, 0, 0, 0), brand_text, brand_font,
                                                             (255, 255, 255),
                                                             slogan_text, slogan_font, (255, 255, 255))
            # 透明底黑色字
            alpha_bottom_black_text = polygon_right_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, (0, 0, 0),
                                                             slogan_text, slogan_font, (0, 0, 0))
            # 透明底原色字
            alpha_bottom_color_text = polygon_right_template('RGBA', (0, 0, 0, 0), brand_text, brand_font, brand_color,
                                                             slogan_text, slogan_font, slogan_color)
        elif customize_model_id == 0:  # 实现logo图样内部固定区域写字
            # 图标下载
            logo_url = gen_json['logo_url']
            # logo名字
            logo_name = time.strftime('%Y%m%d%H%M%S') + str(random.randint(100, 10000)) + '.png'
            logo_down_path = 'logodir/' + logo_name
            logo_down_result = downlogo(logo_down_path, logo_url)
            # 线上读取logo样式方法
            # logo_down_result = downlogo_path(logo_down_path, logo_url)  # downlogo_path(logo_down_path, logo_url)
            # 定义生成的图像接受对象
            if logo_down_result:
                lg_gen = tenplateGenerator()
                # 判断标语是否存在
                # logo_img = Image.open('data/template/6.png')
                logo_img = Image.open('logo_down_path')
                logo_img = logo_img.convert('RGBA')
                # scale = 3
                # print(380 * scale, 280 * scale)
                # scale_width, scale_height = int(380 * scale), int(280 * scale)
                # logo_img = logo_img.resize((scale_width, scale_height), Image.ANTIALIAS)
                # location = [110, 93, 271, 187]
                # location = [int(int(i) * 3) for i in gen_json['brand_location'].split(',')]
                location = [int(i) for i in gen_json['brand_location'].split(',')]
                brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
                # brand_font = ImageFont.truetype('font/cn/汉仪秦川飞影.ttf', brand_size)
                slogan_font = ImageFont.truetype("font/cn/微软vista雅黑.ttf", slogan_size)
                brand_width, brand_height = brand_font.getsize(brand_text)
                # 获取标语font的大小
                slogan_width, slogan_height = slogan_font.getsize(slogan_text)
                # 空白区域的大小为
                location_width = location[2] - location[0]
                location_height = location[3] - location[1]
                # 生成文字的总长度和宽度为
                text_width = max(brand_width, slogan_width)
                text_height = brand_height + slogan_height
                flag = text_width < location_width and text_height < location_height
                while not flag:
                    brand_size -= 1
                    slogan_size -= 1
                    if brand_size < 30:
                        break
                    if slogan_size <= 25:
                        slogan_size = 25
                    brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
                    # brand_font = ImageFont.truetype('font/cn/汉仪秦川飞影.ttf', brand_size)
                    slogan_font = ImageFont.truetype("font/cn/微软vista雅黑.ttf", slogan_size)

                    brand_width, brand_height = brand_font.getsize(brand_text)
                    # 获取标语font的大小
                    slogan_width, slogan_height = slogan_font.getsize(slogan_text)
                    # 空白区域的大小为
                    location_width = location[2] - location[0]
                    location_height = location[3] - location[1]
                    # 生成文字的总长度和宽度为
                    text_width = max(brand_width, slogan_width)
                    text_height = brand_height + slogan_height
                    # print('location:', location_width, location_height)
                    # print('text:', text_width, text_height)
                    flag = text_width < location_width and text_height < location_height

                # 白底黑字
                white_bottom_black_text = lg_gen.generator('RGBA', brand_text, brand_font, (0, 0, 0), location,
                                                           slogan_text, slogan_font, (0, 0, 0), alpha2white(logo_img),
                                                           (255, 255, 255))
                # 黑底白字
                black_bottom_white_text = lg_gen.generator('RGB', brand_text, brand_font, (255, 255, 255),
                                                           location, slogan_text,
                                                           slogan_font, (255, 255, 255), logo_img, (0, 0, 0))
                # 白底原色字
                white_bottom_color_text = lg_gen.generator('RGBA', brand_text, brand_font, brand_color,
                                                           location, slogan_text,
                                                           slogan_font, slogan_color, alpha2white(logo_img),
                                                           (255, 255, 255))
                # 黑底原色字
                black_bottom_color_text = lg_gen.generator('RGB', brand_text, brand_font, brand_color, location,
                                                           slogan_text, slogan_font, slogan_color, logo_img, (0, 0, 0))

                # 透明底白色字
                alpha_bottom_white_text = lg_gen.generator_alpha(brand_text, brand_font, (255, 255, 255), location,
                                                                 slogan_text,
                                                                 slogan_font, (255, 255, 255), logo_img)
                # 透明底黑色字
                alpha_bottom_black_text = lg_gen.generator_alpha(brand_text, brand_font, (0, 0, 0), location,
                                                                 slogan_text,
                                                                 slogan_font, (0, 0, 0), logo_img)
                # 透明底原色字
                alpha_bottom_color_text = lg_gen.generator_alpha(brand_text, brand_font, brand_color, location,
                                                                 slogan_text,
                                                                 slogan_font, slogan_color, logo_img)

        # 保存生成的各种图像
        white_bottom_black_text_path = brand_path + '/' + '白底黑字.png'  # 白底黑字
        black_bottom_white_text_path = brand_path + '/' + '黑底白字.png'  # 黑底白字
        white_bottom_color_text_path = brand_path + '/' + '白底原色字.png'  # 白底原色字
        black_bottom_color_text_path = brand_path + '/' + '黑底原色字.png'  # 黑底原色字
        alpha_bottom_white_text_path = brand_path + '/' + '透明底白色字.png'  # 透明底白色字
        alpha_bottom_black_text_path = brand_path + '/' + '透明底黑色字.png'  # 透明底黑色字
        alpha_bottom_color_text_path = brand_path + '/' + '透明底原色字.png'  # 透明底原色字

        if white_bottom_black_text:
            white_bottom_black_text.save(white_bottom_black_text_path)
        if black_bottom_white_text:
            black_bottom_white_text.save(black_bottom_white_text_path)
        if white_bottom_color_text:
            white_bottom_color_text.save(white_bottom_color_text_path)
        if black_bottom_color_text:
            black_bottom_color_text.save(black_bottom_color_text_path)
        if alpha_bottom_white_text:
            alpha_bottom_white_text.save(alpha_bottom_white_text_path)
        if alpha_bottom_black_text:
            alpha_bottom_black_text.save(alpha_bottom_black_text_path)
        if alpha_bottom_color_text:
            alpha_bottom_color_text.save(alpha_bottom_color_text_path)
        # 创建说明文档
        with open('downlogo/' + brand_text + '/使用说明.txt', 'w') as ff:
            context1 = '-----------------文件附录-----------------\n'
            context2 = '高清Logo图，包含七种png图像\n'
            context3 = '矢量源文件\n'
            context4 = '使用说明\n'
            context5 = '注：由于生成图像尺寸固定大小为2000*2000，样式会有略微改动，如有需求改动，请联系平台。\n'
            ff.write(context1)
            ff.write(context2)
            ff.write(context3)
            ff.write(context4)
            ff.write(context5)
        zip_path, zip_name = make_zip(brand_text)

        # 将压缩包上传到阿里云oss上
        down_url = put2oss(zip_name,zip_path)
        # print(down_url)
        return {
            'status': 1,
            'down_url': down_url,
            'msg': 'success'
        }
    except Exception as e:
        print(e)
        return {
            'status': 0,
            'down_url': '',
            'msg': '出现异常：' + str(e)
        }


# if __name__ == '__main__':
#     gen_json = {'brand_text': '大话西游', 'brand_font': 'font/cn/SourceHanSansCN-Bold.otf',
#                 'brand_color': '(255,39,150)', 'brand_location': '110, 93, 271, 187', 'slogan_text': '我的意中人是一个绝世美人',
#                 'slogan_font': 'font/cn/SourceHanSansCN-Bold.otf', 'slogan_color': '(0,0,0)',
#                 'logo_url': 'http://43.247.184.94:7170/Img/logo/mode/mpic5.png', 'model_id': 0}
#     res = down_customize_logo(gen_json)

    # gen_json = {
    #     'brand_text': '中华人民共和国我爱你中国',  # 品牌名称
    #     'brand_color': '(255, 122, 0)',  # 字体颜色
    #     'brand_location': '右',  # 左右上下
    #     'slogan_text': 'STORM',  # 标语名称，可以为空
    #     'slogan_color': '(0, 0, 0)',  # 标语颜色
    #     'logo_url': 'http://43.247.184.94:7170/Img/logo/phone/pic2.png'  # 图片地址
    # }
    # brand_text = gen_json['brand_text']
    # brand_color_str = gen_json['brand_color']
    # brand_color_list = brand_color_str.replace('(', '').replace(')', '').split(',')
    # brand_color = (int(brand_color_list[0]), int(brand_color_list[1]), int(brand_color_list[2]))
    # brand_size = 150
    # slogan_text = gen_json['slogan_text']
    # slogan_color_str = gen_json['slogan_color']
    # slogan_color_list = slogan_color_str.replace('(', '').replace(')', '').split(',')
    # slogan_color = (int(slogan_color_list[0]), int(slogan_color_list[1]), int(slogan_color_list[2]))
    # slogan_size = 30
    # brand_font = ImageFont.truetype('font/cn/汉仪秦川飞影.ttf', brand_size)
    # # slogan_font = ImageFont.truetype('font/cn/华文仿宋.ttf', slogan_size)
    # # brand_font = ImageFont.truetype(gen_json["brand_font"], brand_size)
    # print(brand_font)
    # # slogan_font = ImageFont.truetype(gen_json['slogan_font'], slogan_size)
    # slogan_font = ImageFont.truetype("font/cn/微软vista雅黑.ttf", slogan_size)
    # model = 'RGBA'
    # modelcolor = (0,0,0,0)
    # vertical_template(model,modelcolor,brand_text, brand_font, brand_color, slogan_text,slogan_font, slogan_color)
    # rectangle_template(model,modelcolor,brand_text, brand_font, brand_color, slogan_text,slogan_font, slogan_color)
    # rectanglecolor_template(model,modelcolor,brand_text, brand_font, brand_color, slogan_text,slogan_font, slogan_color)
    # cornerline_template(model,modelcolor,brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color)
    # twopin_template(model,modelcolor,brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color)
    # line_template(model,modelcolor,brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color)
    # verticalline_template(model,modelcolor,brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color)
    # polygon_right_template(model,modelcolor,brand_text, brand_font, brand_color, slogan_text, slogan_font, slogan_color)
