var system = require("../../../system")
const CtlBase = require("../../ctlms.base");
class RoleCtl extends CtlBase {
  constructor() {
    super();
    this.roleSve = system.getObject("service.uc.roleSve");
  }

    /**
   * saas  添加 
   * @param {*} params 
   */
  async addRole(params, pobj2, req) {
    try {
      return await this.roleSve.addRole(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * saas  更新
   * @param {*} params 
   */
  async updRole(params, pobj2, req) {
    try {
      return await this.roleSve.updRole(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * saas 删除 
   * @param {*} params 
   */
  async delRole(params, pobj2, req) {
    try {
      return await this.roleSve.delRole(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  /**
   * saas  查询列表 
   * @param {*} params 
   */
  async listRole(params, pobj2, req) {
    try {
      return await this.roleSve.listRole(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }

  /**
   * saas  查询明细
   * @param {*} params 
   */
  async queryById(params, pobj2, req) {
    try {
      return await this.roleSve.queryById(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
  async setAuth(params, pobj2, req) {
    try {
      return await this.roleSve.setAuth(params);
    } catch (error) {
      return system.getResult(null, `系统错误 错误信息 ${error}`);
    }
  }
}
module.exports = RoleCtl;