var system = require("../../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctlms.base");

var cacheBaseComp = null;
class MerchantCtl extends CtlBase {
  constructor() {
    super();
    this.merchantSve = system.getObject("service.merchant.merchantSve");
  }

  async nameList(pobj, pobj2, req) {
    try {
      return await this.merchantSve.nameList();
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async infoPage(pobj, pobj2, req) {
    try {
      this.doTimeCondition(pobj, ["createdBegin", "createdEnd"]);
      return await this.merchantSve.infoPage(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async add(pobj, pobj2, req) {
    try {
      return await this.merchantSve.add(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async upd(pobj, pobj2, req) {
    try {
      return await this.merchantSve.upd(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }

  async audit(pobj, pobj2, req) {
    try {
      return await this.merchantSve.audit(pobj);
    } catch (e) {
      console.log(e);
      return system.getResultFail(500, "接口错误");
    }
  }
}
module.exports = MerchantCtl;