const system = require("../system");
const settings = require("../../config/settings");
class CtlBase {
  constructor() {
    this.restClient = system.getObject("util.restClient");
  }
  async doexec(methodname, pobj, query, req) {
    try {
      console.log(methodname, "-------ctl methodname-------");
      var rtn = await this[methodname](pobj, query, req);
      return rtn;
    } catch (e) {
      console.log(e.stack);
      return system.getResultFail(-200, "Ctl出现异常，请联系管理员");
    }
  }
  encryptPasswd(passwd) {
    if (!passwd) {
      throw new Error("请输入密码");
    }
    var md5 = this.md5(passwd + "_" + settings.salt);
    return md5.toString().toLowerCase();
  }

  trim(o) {
    if(!o) {
      return "";
    }
    return o.toString().trim();
  }

  doTimeCondition(params, fields) {
    if (!params || !fields || fields.length == 0) {
      return;
    }

    for (var f of fields) {
        if (params[f]) {
        var suffix = this.endWith(f, 'Begin') ? " 00:00:00" : " 23:59:59";
        params[f] =  params[f] + suffix;
      }
    }
  }

  endWith(source, str){
    if(!str  || !source || source.length == 0 || str.length > source.length) {
      return false;
    }
    return source.substring(source.length - str.length) == str;
  }
}
module.exports = CtlBase;
