const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
/**
 * 发薪列表
 */
class TransactioninService extends ServiceBase {
    constructor() {
        super("all", ServiceBase.getDaoName(TransactioninService));
    }

    /**
     * @param {int} invoiceId  发票ID
     * @param {*} params 
     * 
     */
    async signPage(params) {
        var currentPage = Number(params.currentPage || 0);
        var pageSize = Number(params.pageSize || 10);

        var where = {};
        if (params.company_name) {
            where.company_name = {
                [this.db.Op.like]: "%" + params.company_name + "%"
            };
        }
        if(params.sign_body){
            where.sign_body = params.sign_body;
        }
        if(params.id_no){
            where.id_no = params.id_no
        }
        if(params.invoiceId){
            where.invoiceId = this.trim(params.invoiceId);
        }

        if(params.compreSalary){
            where.deduct_amt = this.trim(params.compreSalary);
        }
        
        this.addWhereTime(where, 'transaction_time', params.signBegin, params.signEnd, true);
        var orderby = [
            ["id", 'desc']
        ];

        var attributes = [`id`, `company_name`, `id_name`, `id_no`, `bank_no`,`invoiceId`, `actual_amount`,`deduct_amt`, `transaction_time`, `sign_body`,`order_item_id`, `channel_rsp_no`, `merchant_account_id`];
        var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
        if (page && page.rows) {
            for (var row of page.rows) {
                this.handleDate(row, ["transaction_time"], null, -8);
            }
        }
        return page;
    }

}

module.exports = TransactioninService;