const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class TaxinfoService extends ServiceBase {
    constructor() {
        super("all", ServiceBase.getDaoName(TaxinfoService));
    }

    async signPage(params) {
        var currentPage = Number(params.currentPage || 0);
        var pageSize = Number(params.pageSize || 10);

        var where = {};

        if (params.company_name) {
            where.company_name = {
                [this.db.Op.like]: "%" + params.company_name + "%"
            };
        }
        
        if(params.sign_body){
            where.sign_body = params.sign_body;
        }

        let id_no = this.trim(params.id_no);
        if(id_no){
            where.id_no = id_no;
        }
        this.addWhereTime(where, 'tax_time', params.signBegin, params.signEnd, true);
        var orderby = [
            ["id", 'desc']
        ];
        var page = await this.getPageList(currentPage, pageSize, where, orderby);
        if (page && page.rows) {
            for (var row of page.rows) {
                this.handleDate(row, ["tax_time"], "YYYY-MM-DD", -8);
            }
        }
        return page;
    }

}

module.exports = TaxinfoService;