const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class RecruitService extends ServiceBase {
    constructor() {
        super("all", ServiceBase.getDaoName(RecruitService));
    }

    async signPage(params) {
        var currentPage = Number(params.currentPage || 0);
        var pageSize = Number(params.pageSize || 10);

        var where = {};
        if (params.company_name) {
            where.company_name = {
                [this.db.Op.like]: "%" + params.company_name + "%"
            };
        }
        if(params.sign_body){
            where.sign_body = params.sign_body;
        }
        this.addWhereTime(where, 'publish_date', params.signBegin, params.signEnd, true);
        var orderby = [
            ["id", 'desc']
        ];
        var attributes = [`id`, `company_name`, `recruit_name`, `publish_date`, `phone_no`, `recruit_count`, `pay_type`, `age_range`, `compre_salary`, `work_address`];
        var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
        if (page && page.rows) {
            for (var row of page.rows) {
                this.handleDate(row, ["publish_date"], "YYYY-MM-DD", -8);
            }
        }
        return page;
    }

}

module.exports = RecruitService;