const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");

class MerchantService extends ServiceBase {
    constructor() {
        super("all", ServiceBase.getDaoName(MerchantService));
        this.electroniccontractDao = system.getObject("db.all.electroniccontractDao");
        this.loadDao = system.getObject("db.all.loadDao");
        this.recruitDao = system.getObject("db.all.recruitDao");
        this.taxinfoDao = system.getObject("db.all.taxinfoDao");
        this.transactioninDao = system.getObject("db.all.transactioninDao");

        this.recruitSve = system.getObject("service.all.recruitSve");
        this.electroniccontractSve = system.getObject("service.all.electroniccontractSve");
        this.loadSve = system.getObject("service.all.loadSve");
        this.taxinfoSve = system.getObject("service.all.taxinfoSve");
        this.transactioninSve = system.getObject("service.all.transactioninSve");
        this.merchantaccountSve = system.getObject("service.all.merchantaccountSve");
    }

    async signPage(params) {
        var currentPage = Number(params.currentPage || 1);
        var pageSize = Number(params.pageSize || 10);

        var where = {};
        if (params.company_name) {
            where.company_name = {
                [this.db.Op.like]: "%" + params.company_name + "%"
            };
        }
        if (params.sign_body) {
            where.sign_body = params.sign_body;
        }
        if(params.id_no){
            where.id_no = params.id_no;
        }
        this.addWhereTime(where, 'begin_time', params.signBegin, params.signEnd, true);
        var orderby = [
            ["id", 'desc']
        ];
        var attributes = [`id`, `company_name`, `type`, `link_man`, `link_no`, `link_email`, `bank_account_name`, `bank_no`, `open_bank`, `sign_body`, `begin_time`, `invalid_time`,`contract_url`,`business_license`];
        var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
        if (page && page.rows) {
            for (var row of page.rows) {
                this.handleDate(row, ["begin_time", "invalid_time"], "YYYY-MM-DD");
            }
        }
        return page;
    }

    async dataSummarize(params) {
        var where = {};
        var wheres = {};
        if (params.sign_body) {
            where.sign_body = params.sign_body;
            wheres.sign_body = params.sign_body;
        }
        this.addWhereTime(where, 'begin_time', params.signBegin, params.signEnd, true);


        var addMer = await this.findCount({where: where});//商户新增
        var upMer = await this.findCount({where: wheres});//累积
        var where_ele = {};
        if (params.sign_body) {
            where_ele.sign_body = params.sign_body;
        }
        this.addWhereTime(where_ele, 'completed_date', params.signBegin, params.signEnd, true);

        var addEle = await this.electroniccontractDao.findCount({where: where_ele});//电子签新增
        var upEle = await this.electroniccontractDao.findCount({where: wheres});//累积


        var where_loa = {};
        if (params.sign_body) {
            where_loa.sign_body = params.sign_body;
        }
        this.addWhereTime(where_loa, 'affirm_time', params.signBegin, params.signEnd, true);

        var addLoad = await this.loadDao.findCount({where: where_loa});//工作量新增
        var upLoad = await this.loadDao.findCount({where: wheres});//


        var where_rec = {};
        if (params.sign_body) {
            where_rec.sign_body = params.sign_body;
        }
        this.addWhereTime(where_rec, 'publish_date', params.signBegin, params.signEnd, true);

        var addrec = await this.recruitDao.findCount({where: where_rec});//招聘需求
        var upRec = await this.recruitDao.findCount({where: wheres});

        var where_tax = {};
        if (params.sign_body) {
            where_tax.sign_body = params.sign_body;
        }
        this.addWhereTime(where_tax, 'tax_time', params.signBegin, params.signEnd, true);

        var addTac = await this.taxinfoDao.findCount({where: where_tax});//完税人次
        var upTac = await this.taxinfoDao.findCount({where: wheres});

        var addTacSum = await this.taxinfoDao.findSum("income_tax", {where: where_tax});//完税金额
        var upTacSum = await this.taxinfoDao.findSum("income_tax", {where: wheres});

        var where_tra = {};
        if (params.sign_body) {
            where_tra.sign_body = params.sign_body;
        }
        this.addWhereTime(where_tra, 'transaction_time', params.signBegin, params.signEnd, true);
        var addTra = await this.transactioninDao.findCount({where: where_tra});//交易比数
        var upTra = await this.transactioninDao.findCount({where: wheres});

        var addTraSum = await this.transactioninDao.findSum("actual_amount", {where: where_tra});//交易金额
        var upTraSum = await this.transactioninDao.findSum("actual_amount", {where: wheres});

        var result = {
            addMer: addMer || 0,//商户新增
            upMer: upMer || 0,

            addEle: addEle || 0,//电子签新增
            upEle: upEle || 0,

            addLoad: addLoad || 0,//工作量新增
            upLoad: upLoad || 0,

            addrec: addrec || 0,//招聘需求
            upRec: upRec || 0,

            addTac: addTac || 0,//完税人次
            upTac: upTac || 0,

            addTacSum: (addTacSum || 0).toFixed(2),//完税金额
            upTacSum: (upTacSum || 0).toFixed(2),

            addTra: addTra || 0, //交易比数
            upTra: upTra || 0,

            addTraSum: (addTraSum || 0).toFixed(2),//交易金额
            upTraSum: (upTraSum || 0).toFixed(2),
        };

        return result;
    }


    async dataChart(params) {
        var result = [];
        var sql = "SELECT DATE_FORMAT(completed_date,'%Y-%m-%d') days,COUNT(id) COUNT FROM electronic_contract_info WHERE 1=1";
        var sqls = "SELECT DATE_FORMAT(transaction_time,'%Y-%m-%d') days,COUNT(id) COUNT FROM transaction_info WHERE 1=1";
        if (params.company_name) {
            sql = sql + " AND company_name = '" + params.company_name + "'";
            sqls = sqls + " AND company_name = '" + params.company_name + "'";
        }
        if (params.sign_body) {
            sql = sql + " AND sign_body = '" + params.sign_body + "'";
            sqls = sqls + " AND sign_body = '" + params.sign_body + "'";
        }
        if (params.signBegin || params.signEnd) {
            sql = sql + " AND completed_date >= '" + params.signBegin + "' AND completed_date <= '" + params.signEnd + "'";
            sqls = sqls + " AND transaction_time >= '" + params.signBegin + "' AND transaction_time <= '" + params.signEnd + "'";
        }
        sql = sql + " GROUP BY days ORDER BY days ASC";
        sqls = sqls + " GROUP BY days ORDER BY days ASC";
        var list = await this.customQuery(sql);
        var lists = await this.customQuery(sqls);
        var m = {
            mx: [],
            my: []
        };
        for (let i = 0; list.length > i; i++) {
            m.mx.push(list[i].days);
            m.my.push(list[i].COUNT);
        }
        result.push(m);
        var t = {
            tx: [],
            ty: []
        };
        for (let j = 0; lists.length > j; j++) {
            t.tx.push(lists[j].days);
            t.ty.push(lists[j].COUNT);
        }
        result.push(t);
        return result || [];
    }

    async commercialCount(params) {

        let page = await this.signPage(params);

        let rows = page.rows;
        if (!page || !page.rows || page.rows.length == 0) {
            return page;
        }
        let companyNames = [];
        for (var row of rows) {
            companyNames.push(row.company_name);
        }
        // 电子签约数量  company_name --> num
        let electronMap = await this.electroniccontractDao.statCount(companyNames, params.sign_body);

        // 招工需求
        let recruitMap = await this.recruitDao.statCount(companyNames, params.sign_body);

        // 工作量确认单
        let loadMap = await this.loadDao.statCount(companyNames, params.sign_body);

        // 交易笔数、交易金额
        let traMap = await this.transactioninDao.statCount(companyNames, params.sign_body);
        //交易金额
        let traSUm = await this.transactioninDao.statCounts(companyNames, params.sign_body);

        // 完税人次
        let taxMap = await this.taxinfoDao.statCount(companyNames, params.sign_body);
        // 完税金额
        let taxSUm = await this.taxinfoDao.statCounts(companyNames, params.sign_body);

        for (var row of rows) {
            row.dzCount = electronMap[row.company_name] || 0;
            row.zgCount = recruitMap[row.company_name] || 0;
            row.gzCount = loadMap[row.company_name] || 0;
            row.jyCOunt = traMap[row.company_name] || 0;
            row.jySum = traSUm[row.company_name] || 0;
            row.wsCOunt = taxMap[row.company_name] || 0;
            row.wsSum = taxSUm[row.company_name] || 0;
        }
        page.rows = rows;
        return page;

    }

    async commercialList(params) {
        var db = "";
        var firlt = "";
        var page = {};
        if (params.type == 1) { //招工
            db = "recruit_info";
            firlt = "publish_date"
            this.doTimeCondition(params, ["signBegin", "signEnd"]);
            page = await this.recruitSve.signPage(params);
        } else if (params.type == 2) {//电子签约
            db = "electronic_contract_info";
            firlt = "completed_date";
            this.doTimeCondition(params, ["signBegin", "signEnd"]);
            page = await this.electroniccontractSve.signPage(params);
        } else if (params.type == 3) {//工作量
            db = "load_info";
            firlt = "affirm_time";
            this.doTimeCondition(params, ["signBegin", "signEnd"]);
            page = await this.loadSve.signPage(params);
        } else if (params.type == 4) {//交易
            db = "transaction_info";
            firlt = "transaction_time";
            this.doTimeCondition(params, ["signBegin", "signEnd"]);
            page = await this.transactioninSve.signPage(params);
            await this.merchantaccountSve.setAccount(page.rows);
        } else {//完税
            db = "tax_info";
            firlt = "tax_time";
            page = await this.taxinfoSve.signPage(params);
        }
        var sql = "SELECT DATE_FORMAT(" + firlt + ",'%Y-%m-%d') days,COUNT(id) COUNT FROM " + db + " WHERE 1=1";

        if (params.company_name) {
            sql = sql + " AND company_name = '" + params.company_name + "'";
        }
        if (params.sign_body) {
            sql = sql + " AND sign_body = '" + params.sign_body + "'";
        }
        sql = sql + " GROUP BY days ORDER BY days ASC";
        var charts = [[], []];
        var chart = await this.customQuery(sql);
        for (let i = 0; i < chart.length; i++) {
            charts[0].push(chart[i].days);
            charts[1].push(chart[i].COUNT)
        }
        page.charts = charts;
        return page;

    }


    async commercialCountTo(params) {

        let page = await this.electroniccontractSve.signPageGroup(params);

        let rows = page.rows;
        if (!page || !page.rows || page.rows.length == 0) {
            return page;
        }
        let companyNames = [];
        for (var row of rows) {
            companyNames.push(row.id_no);
        }
        // 电子签约数量
        let electronMap = await this.electroniccontractDao.sCount(companyNames);

        // 工作量确认单
        let loadMap = await this.loadDao.sCount(companyNames);

        // 交易笔数
        let traMap = await this.transactioninDao.sCount(companyNames);
        //交易金额
        let traSUm = await this.transactioninDao.sCountS(companyNames);

        // 完税人次
        let taxMap = await this.taxinfoDao.sCount(companyNames);
        // 完税金额
        let taxSUm = await this.taxinfoDao.sCount(companyNames);

        for (var row of rows) {
            row.dzCount = electronMap[row.id_no] || 0;
            row.gzCount = loadMap[row.id_no] || 0;
            row.jyCOunt = traMap[row.id_no] || 0;
            row.jySum = traSUm[row.id_no] || 0;
            row.wsCOunt = taxMap[row.id_no] || 0;
            row.wsSum = taxSUm[row.id_no] || 0;
        }
        page.rows = rows;
        return page;

    }

    async commercialCountToChares(params) {
        var db = "";
        var firlt = "";
        var page = {};
        if (params.type == 1) {//电子签约
            db = "electronic_contract_info";
            firlt = "completed_date";
            this.doTimeCondition(params, ["signBegin", "signEnd"]);
            page = await this.electroniccontractSve.signPage(params);
        } else if (params.type == 2) {//工作量
            db = "load_info";
            firlt = "affirm_time";
            this.doTimeCondition(params, ["signBegin", "signEnd"]);
            page = await this.loadSve.signPage(params);
        } else if (params.type == 3) {//交易
            db = "transaction_info";
            firlt = "transaction_time";
            this.doTimeCondition(params, ["signBegin", "signEnd"]);
            page = await this.transactioninSve.signPage(params);
            await this.merchantaccountSve.setAccount(page.rows);
        } else {//完税
            db = "tax_info";
            firlt = "tax_time";
            this.doTimeCondition(params, ["signBegin", "signEnd"]);
            page = await this.taxinfoSve.signPage(params);
        }
        var sql = "SELECT DATE_FORMAT(" + firlt + ",'%Y-%m-%d') days,COUNT(id) COUNT FROM " + db + " WHERE 1=1";

        if (params.company_name) {
            sql = sql + " AND company_name = '" + params.company_name + "'";
        }
        if (params.sign_body) {
            sql = sql + " AND sign_body = '" + params.sign_body + "'";
        }
        if(params.idno){
            sql = sql + " AND id_no = '" + params.idno + "'";
        }
        if(params.id_no){
            sql = sql + " AND id_no = '" + params.id_no + "'";
        }
        sql = sql + " GROUP BY days ORDER BY days ASC";

        var charts = [[], []];
        var chart = await this.customQuery(sql);
        for (let i = 0; i < chart.length; i++) {
            charts[0].push(chart[i].days);
            charts[1].push(chart[i].COUNT)
        }
        page.charts = charts;
        return page;
    }

    async tenantSel(params){
        var sql = " SELECT company_name FROM merchant_info WHERE 1=1 ";
        if (params.sign_body) {
            sql = sql + "AND sign_body = '"+params.sign_body+"'";
        }
        var page = await this.customQuery(sql);
        var result = [];
        for (let i=0;i<page.length;i++){
            var data = {};
            data.value = page[i].company_name;
            data.label = page[i].company_name;
            result.push(data)
        }

        return result;
    }

    mainConfig() {
        return {
            "山东鑫云业服网络科技有限公司": {
                "obj": [
                    {
                        "label": "服务商名称：",
                        "value": "山东鑫云业服网络科技有限公司"
                    },
                    {
                        "label": "联系人姓名：",
                        "value": "吴海燕"
                    },
                    {
                        "label": "联系人手机：",
                        "value": "18530106181"
                    },
                    {
                        "label": "联系地址：",
                        "value": "山东省淄博市高青县田镇街道高苑路82号"
                    },
                    {
                        "label": "开户行：",
                        "value": "中国农业银行股份有限公司淄博文化路支行"
                    },
                    {
                        "label": "对公账户：",
                        "value": "15245601040004855"
                    }
                ],
                "obj1": [
                    {
                        "label": "合作方：",
                        "value": ""
                    },
                    {
                        "label": "合作方地址：",
                        "value": ""
                    },
                    {
                        "label": "合作方开户行：",
                        "value": ""
                    },
                    {
                        "label": "合作方对公账户：",
                        "value": ""
                    },
                    {
                        "label": "签约合同：",
                        "value": ""
                    }
                ],
                "contractUrl": ""
            }
        }
    }

    async getConfig(sign_body) {
        return this.mainConfig()[sign_body] || {};
    }

}

module.exports = MerchantService;