const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
/**
 * 工作量确认单
 */
class LoadService extends ServiceBase {
    constructor() {
        super("all", ServiceBase.getDaoName(LoadService));
    }

    async signPage(params) {
        var currentPage = Number(params.currentPage || 0);
        var pageSize = Number(params.pageSize || 10);

        var where = {};
        if (params.company_name) {
            where.company_name = {
                [this.db.Op.like]: "%" + params.company_name + "%"
            };
        }
        if(params.sign_body){
            where.sign_body = params.sign_body;
        }
        if(params.id_no){
            where.id_no = params.id_no
        }
        if(params.compreSalary){
            where.compre_salary = this.trim(params.compreSalary);
        }
        this.addWhereTime(where, 'affirm_time', params.signBegin, params.signEnd, true);
        var orderby = [
            ["id", 'desc']
        ];
        var attributes = [`id`, `company_name`, `name`, `phone_no`, `id_no`, `bankno`, `workload`, `compre_salary`, `affirm_time`, `sign_body`];
        var page = await this.getPageList(currentPage, pageSize, where, orderby, attributes);
        if (page && page.rows) {
            for (var row of page.rows) {
                this.handleDate(row, ["begin_time", "invalid_time"], "YYYY-MM-DD", -8);
                this.handleDate(row, ["affirm_time"], null, -8);
            }
        }
        return page;
    }

}

module.exports = LoadService;