/* jshint indent: 2 */

module.exports = function(sequelize, DataTypes) {
  return sequelize.define('transactionin', {
    id: {
      type: DataTypes.INTEGER(11),
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    invoiceId: {
      type: DataTypes.INTEGER(11),
      field: 'invoice_id', 
    },
    company_name: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    id_name: {
      type: DataTypes.STRING(20),
      allowNull: true
    },
    id_no: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    bank_no: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    actual_amount: {
      type: DataTypes.STRING(20),
      allowNull: true
    },
    transaction_time: {
      type: DataTypes.DATE,
      allowNull: true
    },
    order_item_id: {
      type: DataTypes.STRING,
      allowNull: true
    },
    channel_rsp_no: {
      type: DataTypes.STRING,
      allowNull: true
    },
    merchant_account_id: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true
    },
    deleted_at: {
      type: DataTypes.DATE,
      allowNull: true
    },
    version: {
      type: DataTypes.INTEGER(11),
      allowNull: true,
      defaultValue: '0'
    },
    redundance_1: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    redundance_2: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    redundance_3: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    redundance_4: {
      type: DataTypes.STRING(255),
      allowNull: true
    }
  }, {
    tableName: 'transaction_info'
  });
};
