/* jshint indent: 2 */

module.exports = function(sequelize, DataTypes) {
  return sequelize.define('merchant', {
    id: {
      type: DataTypes.INTEGER(11),
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    company_name: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    usc_code: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    type: {
      type: DataTypes.CHAR(2),
      allowNull: false
    },
    link_man: {
      type: DataTypes.STRING(32),
      allowNull: false
    },
    link_no: {
      type: DataTypes.STRING(20),
      allowNull: true
    },
    link_email: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    bank_account_name: {
      type: DataTypes.STRING(30),
      allowNull: false
    },
    bank_no: {
      type: DataTypes.STRING(30),
      allowNull: false
    },
    open_bank: {
      type: DataTypes.STRING(255),
      allowNull: false
    },
    sign_body: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    begin_time: {
      type: DataTypes.DATE,
      allowNull: true
    },
    invalid_time: {
      type: DataTypes.DATE,
      allowNull: true
    },
    created_at: {
      type: DataTypes.DATE,
      allowNull: true
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: true
    },
    deleted_at: {
      type: DataTypes.DATE,
      allowNull: true
    },
    version: {
      type: DataTypes.INTEGER(11),
      allowNull: true,
      defaultValue: '0'
    },
    redundance_1: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    redundance_2: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    redundance_3: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    redundance_4: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    contract_url: {
      type: DataTypes.STRING(300),
      allowNull: true
    },
    business_license: {
      type: DataTypes.STRING(300),
      allowNull: true
    }
  }, {
    tableName: 'merchant_info'
  });
};
