const system = require("../../../system");
const Dao = require("../../dao.base");

class TaxinfoDao extends Dao {
    constructor() {
        super(Dao.getModelName(TaxinfoDao));
    }
    async statCount(companyNames, sign_body) {
        var result = {};
        if(!companyNames || companyNames.length == 0) {
            return result;
        }

        let and = [];
        and.push("company_name IN (:companyNames)");
        if (sign_body) {
            and.push("AND sign_body = :sign_body");
        }

        var sql = `SELECT company_name, COUNT(1) AS num FROM tax_info WHERE  ${and.join(" ")} GROUP BY company_name`;

        let list = await this.customQuery(sql, {companyNames: companyNames, sign_body: sign_body});

        if(!list || list.length == 0) {
            return result;
        }

        for (var item of list) {
            result[item.company_name] = item.num || 0;
        }
        return result;
    }
    async statCounts(companyNames, sign_body) {
        var result = {};
        if(!companyNames || companyNames.length == 0) {
            return result;
        }
        let and = [];
        and.push("company_name IN (:companyNames)");
        if (sign_body) {
            and.push("AND sign_body = :sign_body");
        }
        var sql = `SELECT company_name, SUM(income_tax) AS num FROM tax_info WHERE ${and.join(" ")} GROUP BY company_name`;

        let list = await this.customQuery(sql, {companyNames: companyNames, sign_body: sign_body});

        if(!list || list.length == 0) {
            return result;
        }

        for (var item of list) {
            result[item.company_name] = item.num || 0;
        }
        return result;
    }

    async sCount(idno) {
        var result = {};
        if(!idno || idno.length == 0) {
            return result;
        }
        var sql = "SELECT id_no, COUNT(1) AS num FROM `tax_info` WHERE id_no IN (:idno) GROUP BY name";

        let list = await this.customQuery(sql, {idno: idno});

        if(!list || list.length == 0) {
            return result;
        }

        for (var item of list) {
            result[item.id_no] = item.num || 0;
        }
        return result;
    }

    async sCountS(inno) {
        var result = {};
        if(!inno || inno.length == 0) {
            return result;
        }
        var sql = "SELECT id_no, SUM(income_tax) AS num FROM `tax_info` WHERE company_name IN (:inno) GROUP BY name";

        let list = await this.customQuery(sql, {inno: inno});

        if(!list || list.length == 0) {
            return result;
        }

        for (var item of list) {
            result[item.id_no] = parseFloat((item.num || 0).toFixed(2));
        }
        return result;
    }
}

module.exports = TaxinfoDao;