const system = require("../../../system");
const Dao = require("../../dao.base");

class RecruitDao extends Dao {
    constructor() {
        super(Dao.getModelName(RecruitDao));
    }

    async statCount(companyNames, sign_body) {
        var result = {};
        if(!companyNames || companyNames.length == 0) {
            return result;
        }

        let and = [];
        and.push("company_name IN (:companyNames)");
        if (sign_body) {
            and.push("AND sign_body = :sign_body");
        }

        var sql = `SELECT company_name, COUNT(1) AS num FROM recruit_info WHERE ${and.join(" ")} GROUP BY company_name `;
        let list = await this.customQuery(sql, {companyNames: companyNames, sign_body: sign_body});

        if(!list || list.length == 0) {
            return result;
        }

        for (var item of list) {
            result[item.company_name] = item.num || 0;
        }
        return result;
    }
}

module.exports = RecruitDao;