var system = require("../../../system")
const CtlBase = require("../../ctl.base");

class TransactioninCtl extends CtlBase {
    constructor() {
        super("all", CtlBase.getServiceName(TransactioninCtl));

        this.merchantaccountSve = system.getObject("service.all.merchantaccountSve");
    }

    async allList(qobj){
        var params = qobj || {};
        this.doTimeCondition(params, ["signBegin", "signEnd"]);
        try {
            var page = await this.service.signPage(params);
            await this.merchantaccountSve.setAccount(page.rows);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }

}

module.exports = TransactioninCtl;