var system = require("../../../system")
const CtlBase = require("../../ctl.base");
//工作量
class InvoiceCtl extends CtlBase {
    constructor() {
        super("all", CtlBase.getServiceName(InvoiceCtl));
    }

    async companyPage(qobj){
        var params = qobj || {};
        params.invoiceType = 1;
        try {
            this.doTimeCondition(params, ['signBegin', 'signEnd']);
            var page = await this.service.pageByCondition(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }

    async myPage(qobj){
        var params = qobj || {};
        params.invoiceType = 2;
        try {
            var page = await this.service.pageByCondition(params);
            return system.getResult2(page);
        } catch (e) {
            console.log(e);
            return system.getErrResult2("您的网络不稳, 请稍后重试");
        }
    }
}

module.exports = InvoiceCtl;