const system = require("../../../system");
const ServiceBase = require("../../sve.base");
const settings = require("../../../../config/settings");
const appconfig = system.getSysConfig();
class MaterialService extends ServiceBase {
    constructor() {
        super("bizchance", ServiceBase.getDaoName(MaterialService));
    }
    // async findAndCountAll(obj) {
    //     var self = this;
    //     const apps = await this.dao.findAndCountAll(obj);
    //     return apps;
    // }

    /*根据交付单编号获取注册材料信息详情*/
    async findInfoByDeliverNumber(qobj) {
        return await this.dao.findInfoByDeliverNumber(qobj);
    }

    /* 根据交付单编号更新交付单编号信息 */
    async updateInfoByDeliverNumber(qobj) {
        var self = this;
        return self.db.transaction(async function (t) {
            return await self.dao.updateInfoByDeliverNumber(qobj, t);
        });
    }
    /* 根据id更新zip信息 */
    async updateZipById(qobj) {
        var self = this;
        return self.db.transaction(async function (t) {
            return await self.dao.updateZipById(qobj, t);
        });
    }

    /*获取没有压缩文件的信息*/
    async findnoUrlInfo() {
        var sql = "select id,file_info from material_information where is_download = 0 and file_info is not null";
        var d = await this.dao.customQuery(sql);
        if (d && d.length > 0) {
            var rtndata = [];
            d.forEach(item => {
                if (item.file_info.uploadList && item.file_info.uploadList != 'undefined') {
                    rtndata.push({ "id": item.id, "uploadList": item.file_info.uploadList });
                }
            });
            return rtndata;
        }
        else {
            return [];
        }

    }

    /*插入信息*/
    async insertInfo(qobj) {
        var self = this;
        return self.db.transaction(async function (t) {
            return await self.dao.insertInfo(qobj, t);
        });
    }

}
module.exports = MaterialService;