const system = require("../../../system");
const settings = require("../../../../config/settings");
const appconfig = system.getSysConfig();
/**
 * 商机表
 */
module.exports = (db, DataTypes) => {
  return db.define("bizopt", {
    demand_code: { // 需求编码
      allowNull: false,
      type: DataTypes.STRING
    },
    business_type: { // 商机类型
      allowNull: false,
      type: DataTypes.STRING
    },
    business_status: { // 商机状态
      allowNull: false,
      type: DataTypes.STRING
    },
    business_info: { // 商机详情
      allowNull: false,
      type: DataTypes.JSON
    },
    v_coname: { // 联系人-虚拟字段
      allowNull: true,
      type: DataTypes.STRING
    },
    v_cophone: { // 联系电话-虚拟字段
      allowNull: true,
      type: DataTypes.STRING
    },
    source_number: { // 来源单号 （下单时产生的编号)
      allowNull: true,
      type: DataTypes.STRING
    },
    source_name: { //渠道来源
      allowNull: true,
      type: DataTypes.STRING
    },
    service_address: { // 区域地址
      allowNull: true,
      type: DataTypes.STRING
    },
    close_reason: { // 关闭理由
      allowNull: true,
      type: DataTypes.STRING
    },
    facilitator_id: { // 服务商id
      allowNull: true,
      type: DataTypes.STRING
    },
    facilitator_name: { // 服务商名称
      allowNull: true,
      type: DataTypes.STRING
    },
    salesman_opcode: { // 组织架构路径
      allowNull: true,
      type: DataTypes.STRING
    },
    salesman_id: {// 业务员id
      allowNull: true,
      type: DataTypes.STRING
    },
    salesman_name: { // 业务员姓名
      allowNull: true,
      type: DataTypes.STRING
    },
    salesman_phone: { // 业务员联系方式
      allowNull: true,
      type: DataTypes.STRING
    }
  }, {
    paranoid: false,//假的删除
    underscored: true,
    version: true,
    freezeTableName: true,
    //freezeTableName: true,
    // define the table's name
    tableName: 'bussiness_opportunity',
    validate: {

    },
    indexes: [
      // Create a unique index on email
      //  {
      //    unique: true,
      //    fields: ['email']
      //  },
      //
      //  // Creates a gin index on data with the jsonb_path_ops operator
      //  {
      //    fields: ['data'],
      //    using: 'gin',
      //    operator: 'jsonb_path_ops'
      //  },
      //
      //  // By default index name will be [table]_[fields]
      //  // Creates a multi column partial index
      //  {
      //    name: 'public_by_author',
      //    fields: ['author', 'status'],
      //    where: {
      //      status: 'public'
      //    }
      //  },
      //
      //  // A BTREE index with a ordered field
      //  {
      //    name: 'title_index',
      //    method: 'BTREE',
      //    fields: ['author', {attribute: 'title', collate: 'en_US', order: 'DESC', length: 5}]
      //  }
    ]
  });
}

