const system = require("../../../system");
const Dao = require("../../dao.base");
class DeliverybillDao extends Dao {
  constructor() {
    super(Dao.getModelName(DeliverybillDao));
  }
  convertAggResult (aggresult) {
    if (aggresult) {
      Object.keys(aggresult).forEach((k) => {
        if (k.indexOf("sum") >= 0) {
          aggresult[k] = aggresult[k] / 100
        }
      })
    }
    return aggresult
  }
  extraModelFilter (pobj) {
    return { "key": "include", "value": { model: this.db.models.settlebill, raw: true, attributes: ['memo'] } };
  }
  extraWhere (qobj, qw, qc) {//根据业务员id获取交付单信息的组装条件
    //qc.raw = true;
    //检查查询的用户所属公司是否是平台运营公司-1,如果是则不添加公司查询条件, 不添加路径条件,返回所有数据
    if (qw["delivery_status"] == "handling") {//解决首页多状态查询
      qw["delivery_status"] = { [this.db.Op.notIn]: ['received', 'success', 'closed'] }
    }

    if (qobj.company_id == 1) {
      if (qobj.bizpath && qobj.bizpath != "") {
        if (qobj.bizpath.indexOf("pmxdeliverrequest") > 0) {//说明是从商机列表过来的
          qw["delivery_status"] = "success";
          qw["settle_status"] = "waittosettle";
        }
      }

      return qw
    } else {
      //需要添加公司查询条件
      qw["facilitator_id"] = Number(qobj.company_id)
      // 为空说明是管理员,不需设置组织结构过滤
      if (qobj.opath && qobj.opath != "") {
        qw["delivery_man_opcode"] = { [this.db.Op.like]: `%${qobj.opath}%` }
      } else {//说明是租户管理员，给租户自己核销结算的功能，
        if (qobj.bizpath.indexOf("pmxdeliverrequest") > 0) {//说明是结算核销路由过来的
          qw["delivery_status"] = "success";
          qw["settle_status"] = "waittosettle";
        }

      }
      //不是来自平台前端查询
      if (qobj.bizpath && qobj.bizpath.indexOf("pmx") < 0) {
        qc.where.product_code = qc.where.product_code || {
          [this.db.Op.notIn]: ["ICP", "EDI", "ICPANNUALREPORT", "EDIANNUALREPORT"]
        }
        if (qobj.bizpath && qobj.bizpath != "") {
          if (qobj.bizpath.indexOf("myDeliver") > 0) {//说明是从商机列表过来的
            qw["delivery_man_id"] = qobj.userid;
          }
        }
      }
    }
    return qw;
  }

  /*根据交付单编号获取订单详情*/
  async findInfoByDeliverCode (qobj) {
    var qcwhere = { "delivery_code": qobj.deliverNumber };
    return await this.findOne(qcwhere);
  }

  /*根据交付单编号更新状态信息*/
  async updateStatusByDeliverCode (qobj, t) {
    var setobj = { "delivery_status": qobj.deliverStatus };
    if (qobj.statusReason && qobj.statusReason != 'undefined') {
      setobj.close_reason = qobj.statusReason;
    }
    else {
      setobj.close_reason = "";
    }
    var whereobj = { "delivery_code": qobj.deliverNumber };
    var rs = await this.findOne(whereobj);
    if (rs && rs != 'undefined') {
      if (qobj.deliverStatus == "collecting" || qobj.deliverStatus == "received" || qobj.deliverStatus == "paid" || qobj.deliverStatus == "userConfirmationReject") {//兼顾阿里
        rs.delivery_info.payStatus = "待交付";
      }
      else if (qobj.deliverStatus == "closed") {
        rs.delivery_info.payStatus = "已关闭";
      }
      else {
        rs.delivery_info.payStatus = "已交付";
      }
      setobj.delivery_info = rs.delivery_info;
    }
    return await this.updateByWhere(setobj, whereobj, t);
  }

  /*更新业务员/交付员信息*/
  async updateSalesmanInfoByDeliverCode (qobj, t) {
    var setobj = {};
    if (qobj.type == "salesman") {
      if (qobj.salesmanId && qobj.salesmanId != 'undefined') {
        setobj.salesman_id = qobj.salesmanId;
      };
      if (qobj.salesmanName && qobj.salesmanName != 'undefined') {
        setobj.salesman_name = qobj.salesmanName;
      };
      if (qobj.salesmanOpcode && qobj.salesmanOpcode != 'undefined') {
        setobj.salesman_opcode = qobj.salesmanOpcode;
      };
    }
    if (qobj.type == "deliverman") {
      if (qobj.deliverymanId && qobj.deliverymanId != 'undefined') {
        setobj.delivery_man_id = qobj.deliverymanId;
      };
      if (qobj.deliverymanName && qobj.deliverymanName != 'undefined') {
        setobj.delivery_man_name = qobj.deliverymanName;
      };
      if (qobj.deliverymanOpcode && qobj.deliverymanOpcode != 'undefined') {
        setobj.delivery_man_opcode = qobj.deliverymanOpcode;
      };
    }
    // if (qobj.salesmanPhone && qobj.salesmanPhone != 'undefined') {
    //   setobj.salesman_phone = qobj.salesmanPhone;
    // };
    if (qobj.facilitatorId && qobj.facilitatorId != 'undefined') {
      setobj.facilitator_id = qobj.facilitatorId;
    };
    if (qobj.facilitatorName && qobj.facilitatorName != 'undefined') {
      setobj.facilitator_name = qobj.facilitatorName;
    };
    var whereobj = { "delivery_code": qobj.deliverNumber };
    return await this.updateByWhere(setobj, whereobj, t);
  }

  /*根据交付单更新交付材料信息*/
  async updateInfoByDeliverCode (qobj, t) {//公司注册、云上园区注册时填写交付材料
    var whereobj = { "delivery_code": qobj.deliverNumber };
    var setobj = { "delivery_info": qobj.baseInfo };
    if (qobj.deliverStatus && qobj.deliverStatus != 'undefined') {
      setobj.delivery_status = qobj.deliverStatus;
    }
    if (qobj.statusReason && qobj.statusReason != 'undefined') {
      setobj.close_reason = qobj.statusReason;
    }
    else {
      setobj.close_reason = "";
    }
    return await this.updateByWhere(setobj, whereobj, t);
  }

  /*插入交付单信息*/
  async insertInfo (qobj, t) {//到时候看交付单信息后再确定
    var obj = {
      "delivery_code": qobj.deliverNumber,
      "delivery_status": qobj.deliverStatus,
      "delivery_info": qobj.baseInfo
    };
    if (qobj.businessMode && qobj.businessMode != 'undefined') {
      obj.demand_code = qobj.businessMode;
    }
    if (qobj.schemeNumber && qobj.schemeNumber != 'undefined') {
      obj.scheme_number = qobj.schemeNumber;
    }
    if (qobj.businessName && qobj.businessName != 'undefined') {
      obj.product_name = qobj.businessName;
    }
    if (qobj.businessType && qobj.businessType != 'undefined') {
      obj.product_code = qobj.businessType;
    }

    if (qobj.txOrderNum && qobj.txOrderNum != 'undefined') {
      obj.master_source_number = qobj.txOrderNum;
    }
    if (qobj.channelSource && qobj.channelSource != 'undefined') {
      obj.source_name = qobj.channelSource;
    }
    if (qobj.channelNumber && qobj.channelNumber != 'undefined') {
      obj.source_number = qobj.channelNumber;
    }
    if (qobj.skuCode && qobj.skuCode != 'undefined') {
      obj.sku_code = qobj.skuCode;
    }
    if (qobj.serviceCode && qobj.serviceCode != 'undefined') {
      obj.service_address = qobj.serviceCode;
    }
    if (qobj.servicerCode && qobj.servicerCode != 'undefined') {
      obj.facilitator_id = qobj.servicerCode;
    }
    if (qobj.servicerName && qobj.servicerName != 'undefined') {
      obj.facilitator_name = qobj.servicerName;
    }
    if (qobj.clerkName && qobj.clerkName != 'undefined') {
      obj.delivery_man_name = qobj.clerkName;
    }
    if (qobj.salesmanName && qobj.salesmanName != 'undefined') {
      obj.salesman_name = qobj.salesmanName;
    }
    if (qobj.salesmanPhone && qobj.salesmanPhone != 'undefined') {
      obj.salesman_phone = qobj.salesmanPhone
    }
    if (qobj.salesmanOpcode && qobj.salesmanOpcode != 'undefined') {
      obj.salesman_opcode = qobj.salesmanOpcode;
    }
    if (qobj.clerkOpcode && qobj.clerkOpcode != 'undefined') {
      obj.delivery_man_opcode = qobj.clerkOpcode;
    }
    if (qobj.salesmanId && qobj.salesmanId != 'undefined') {
      obj.salesman_id = qobj.salesmanId;
    }
    if (qobj.clerkId && qobj.clerkId != 'undefined') {
      obj.delivery_man_id = qobj.clerkId;
    }
    if (qobj.sellingPrice && qobj.sellingPrice != 'undefined') {
      obj.selling_price = qobj.sellingPrice;
    }
    if (qobj.costPrice && qobj.costPrice != 'undefined') {
      obj.cost_price = qobj.costPrice;
    }
    if (qobj.statusReason && qobj.statusReason != 'undefined') {
      obj.close_reason = qobj.statusReason;
    }
    return await this.create(obj, t);
  }


}
module.exports = DeliverybillDao;
