var system = require("../../../system")
const http = require("http")
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");

class CompanyCtl extends CtlBase {
  constructor() {
    super("common", CtlBase.getServiceName(CompanyCtl));
  }
  async update(p,q,req){
   let u= await super.update(p,q,req)
   //缓存失效
   await this.cacheManager["CompanyCache"].invalidate(p.companykey)
   let company=await this.cacheManager["CompanyCache"].cache(p.companykey)
   return system.getResult(company)
  }

  async setOrgs(p,q,req){
    let orgs=await this.service.setOrgs(p,req.xctx.fromcompanykey)
    return system.getResult(orgs)
   }
   async getOrgs(p,q,req){
    let companynew=await this.cacheManager["CompanyCache"].cache(req.xctx.fromcompanykey)
    return system.getResult({orgJson:JSON.parse(companynew.orgJson)})
   }
  
}
module.exports = CompanyCtl;
