var system = require("../../../system");
const http = require("http");
const querystring = require('querystring');
var settings = require("../../../../config/settings");
const CtlBase = require("../../ctl.base");
const moment = require('moment');
class CacheInfoCtl extends CtlBase {
  constructor() {
    super("bizchance", CtlBase.getServiceName(CacheInfoCtl));
    this.deliverService = system.getObject("service.bizchance.deliverybillSve");
  }

  /*根据交付单id获取缓存详情*/
  async findInfoByDeliverId(mobj,qobj,req){
    var pobj = mobj.d;
    if (pobj.deliverNumber && pobj.deliverNumber != 'undefined')
    {
      try{
        var rs = await this.service.findInfoByDeliverId(pobj);
        var divInfo = await this.deliverService.findInfoByDeliverCode(pobj);
        var rarr = {};
        if (rs && rs != 'undefined'){
          rarr.deliverNumber = rs.deliver_id;
          rarr.cacheInfo = rs.cache_info;
          rarr.statusInfo = {};
          if (divInfo && divInfo != 'undefined'){
            rarr.statusInfo.deliverStatus = divInfo.delivery_status;//状态
            rarr.statusInfo.statusReason = divInfo.close_reason;//状态原因
            rarr.statusInfo.createdTime = this.timeFormat(divInfo.created_at);
            rarr.statusInfo.updateTime = this.timeFormat(divInfo.updated_at)
          }
        }
       
        return system.getResult(rarr);
      }
      catch(error){
        return system.getResultError(error);
      }
    }
    else{
      return system.getResultError("参数错误！");
    }
  }

  /*根据交付单id更新缓存信息*/
  async updateInfoByDeliverId(mobj,qobj,req){
    var pobj = mobj.d;
    console.log("cache---------------------------------------" + JSON.stringify(pobj));
    if (pobj.deliverNumber && pobj.deliverNumber != 'undefined' && pobj.cacheInfo && pobj.cacheInfo != 'undefined'){
      try{
        var res = await this.service.updateInfoByDeliverId(pobj);
        return system.getResult("更新成功！");
      }
      catch (error){
        console.log("error----------------------------" + error);
        return system.getResultError(error);
      }
    }
    else{
      console.log("-----------------------------------------参数错误");
      return system.getResultError("参数错误!");
    }
  }

  /*插入或更新缓存信息 */
  async createInfo(mobj,qobj,req){
    var pobj = mobj.d;
    if (pobj.deliverNumber && pobj.deliverNumber != 'undefined' && pobj.cacheInfo && pobj.cacheInfo != 'undefined'){
      try{
        var rs = await this.service.findInfoByDeliverId(pobj);
        if (rs){
          await this.service.updateInfoByDeliverId(pobj);
        }
        else{
          await this.service.insertInfo(pobj);
        }
        
        return system.getResult("操作成功！");
      }
      catch (error){
        return system.getResultError(error);
      }
    }
    else{
      return system.getResultError("参数错误!");
    }
  }

  timeFormat(date) {
    let localTime = moment.utc(date).toDate();
    localTime = moment(localTime).format("YYYY-MM-DD");
    return localTime;
  }
}
module.exports = CacheInfoCtl;

// var task = new CacheInfoCtl();
// var obj={"demand_code":"30030302992","business_status":"isFinished"};
// task.updateStatusByDemandCode(obj,{},{}).then(d=>{
//   console.log(d);
//   //console.log(d[0].analyse);

// })
