var APIBase = require("../../api.base");
var system = require("../../../system");
var settings = require("../../../../config/settings");
class BizChanceAPI extends APIBase {
   constructor() {
      super();
      this.bizChanceS = system.getObject("service.bizchance.bizoptSve");
      this.dateUtil = system.getObject("util.dateClient");
   }
   /**
    * 按照服务商进行分组统计
    * @param {*} p 
    * @param {*} q 
    * @param {*} req 
    */

   async statBizChanceCountBySp(p, q, req) {
      let bizStatus = p.bizStatus
      let betweenTime = this.dateUtil.betweenTime(p.dateType);
      let rtn = await this.bizChanceS.statBizChanceCountBySp(bizStatus, betweenTime)
      return system.getResult(rtn)
   }

   /**
    * 待处理商机beforeSubmission
    * 处理中商机 beforeConfirmation
    *累计处理商机 包括成单和关闭
    * @param {*} p 
    * @param {*} q 
    * @param {*} req 
    */
   async statBizChance(p, q, req) {
      let companyId = p.company_id
      let userid = p.userid
      let username = p.username
      let opath = p.opath
      let betweenTime = this.dateUtil.betweenTime(p.dateType);
      let rtn = await this.bizChanceS.statBizChance(companyId, opath, username, userid, betweenTime);
      return system.getResult(rtn)
   }
   classDesc() {
      return {
         groupName: "auth",
         groupDesc: "认证相关的包",
         name: "AccessAuthAPI",
         desc: "关于认证的类",
         exam: `
             post  http://p.apps.com/api/auth/accessAuth/getAccessKey
             {
                appKey:xxxxx,
                secret:yyyyyy
             }
         `,
      };
   }
   methodDescs() {
      return [
         {
            methodDesc: "生成访问token,访问地址：http://......../api/auth/accessAuth/getAccessKey,访问token需要放置到后续API方法调用的请求头中",
            methodName: "getAccessKey",
            paramdescs: [
               {
                  paramDesc: "访问appkey",
                  paramName: "appkey",
                  paramType: "string",
                  defaultValue: "",
               },
               {
                  paramDesc: "访问secret",
                  paramName: "secret",
                  paramType: "string",
                  defaultValue: "",
               }
            ],
            rtnTypeDesc: "返回JSON对象字符串",
            rtnType: "json object {accessKey: xxxxxx, app: {xxx:xxx}},注意app,是当前app信息,详细见后面示例"
         },
      ];
   }
   exam() {
      return ``
   }
}
module.exports = BizChanceAPI;
