const system = require("../../../system");
const ServiceBase = require("../../sve.base")

class EordersignlogService extends ServiceBase {
  constructor() {
    super("eorder", ServiceBase.getDaoName(EordersignlogService));
    this.eorderDao = system.getObject("db.eorder.eorderDao");
  }

  /**
   * fn:保存签约证日志
   * @param params
   * @returns {Promise<void>}
   */
  async saveEorderSignLog(params) {
    if(!params.order_id){
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if(!params.product_id){
      return system.getResult(null, `参数错误 产品ID不能为空`);
    }
    if(!params.engine_contract_name){
      return system.getResult(null, `参数错误 签署任务名称不能为空`);
    }
    if(!params.engine_contract_id){
      return system.getResult(null, `参数错误 签署ID不能为空`);
    }
    if(!params.actual_spend_name){
      return system.getResult(null, `参数错误 实际使用方不能为空`);
    }
    params.spended_num = Number(params.spended_num || 0);
    params.spended_at = params.spended_at?params.spended_at:new Date();
    params.platform_id=params.platform_id?params.platform_id:'';
    if(!params.platform_name){
      return system.getResult(null, `参数错误 平台名称不能为空`);
    }
    try{
      let orderBean = await this.eorderDao.model.findOne({
        where:{
          id:this.trim(params.order_id)
        }
      });
      if(!orderBean){
        return system.getResult(null, `订单【${params.order_id}】不存在`);
      }
      params.merchant_id = orderBean.merchant_id;
      await this.dao.create(params);
      return system.getResultSuccess();
    }catch (e) {
      console.log(e);
      return system.getResult(null,`系统错误`);
    }

  }

  /**
   * fn:签约日志列表
   * @param params
   * @returns {Promise<void>}
   */
  async pageEorderSignLog(params){
    params.currentPage = Number(params.currentPage || 1);
    params.pageSize = Number(params.pageSize || 10);
    params.startRow = (params.currentPage - 1) * params.pageSize;
    try{
      let countRes = await this.dao.countEorderSignLog(params);
      if(countRes.eordersignlogCount==0){
        return system.getResult({count: 0, rows: []});
      }
      let list =await  this.dao.pageEorderSignLog(params);
      if(!list || list.length==0){
        return system.getResult({count: 0, rows: []});
      }
      for (let item of list) {
        this.handleDate(item,['spended_at','created_at'],null,null)
      }
      return system.getResult({count: countRes.eordersignlogCount, rows: list});
    }catch (e) {
      console.log(e);
      return system.getResult(null, `系统错误`);
    }
  }


  /**
   * fn: 合同列表（分页）
   * @param params
   * @returns {Promise<void>}
   */
  async pageEorderContract(params){
    try{
      params.currentPage = Number(params.currentPage || 1);
      params.pageSize = Number(params.pageSize || 10);
      params.startRow = (params.currentPage - 1) * params.pageSize;
      let listContract = await this.dao.countEordersignlogContract(params);
      if(listContract.count==0){
        return system.getResult({count: 0, rows: []});
      }

      let list =await  this.dao.PageeordersignlogContract(params);
      if(!list || list.length==0){
        return system.getResult({count: 0, rows: []});
      }
      for (let item of list) {
        this.handleDate(item,['created_at','live_start','live_end'],null,null)
      }
      return  system.getResult({count: listContract.count, rows: list});
    }catch (e) {
      console.log(e);
      return system.getResult(`系统错误`);
    }
  }
}

module.exports = EordersignlogService;