const system = require("../../../system");
const ServiceBase = require("../../sve.base")

class EorderproductService extends ServiceBase {
  constructor() {
    super("eorder", ServiceBase.getDaoName(EorderproductService));
    this.eorderDao = system.getObject("db.eorder.eorderDao");
  }

  /**
   * fn:根据产品ID查询(根据订单创建时间升序派)
   * @param params
   * @returns {Promise<void>}
   */
  async listEorderProduct(params){
    try{
      if(!params.product_id){
        return system.getResult(null, `参数错误 产品ID不能为空`);
      }
      let list = await this.dao.findAllByOrderIdCreatedAsc({product_id:this.trim(params.product_id),merchant_id:this.trim(params.merchant_id)});
      return system.getResult(list || []);
    }catch (e) {
      console.log(e);
      return system.getResult(null,`系统错误`);
    }
  }

  /**
   * fn:查看当前商户下所有的订单相关的产品（没有分页）
   * @param params
   * @returns {Promise<void>}
   */
  async listEorderProductByMerchantId(params){
      if(!params.merchant_id){
        return system.getResult(null, `参数错误 商户ID 不能为空`);
      }
      let p_list = await this.eorderDao.model.findAll({
        where:{
          merchant_id: this.trim(params.merchant_id)
        },
        attributes:['id']
      });
      let ids =[];
      if(!p_list || p_list.length==0){
        return system.getResultSuccess([]);
      }else{
        for (let item of p_list) {
          ids.push(item.id);
        }
      }

      let list = await this.dao.model.findAll({
        where:{
          order_id:{
            [this.db.Op.in]:ids
          }
        },
        attributes:['product_id']
      });
      return system.getResultSuccess(list);
  }
}

module.exports = EorderproductService;