const system = require("../../../system");
const ServiceBase = require("../../sve.base")

class EorderauthlogService extends ServiceBase {
  constructor() {
    super("eorder", ServiceBase.getDaoName(EorderauthlogService));
    this.eorderDao = system.getObject("db.eorder.eorderDao");
  }

  /**
   * fn:保存身份验证日志
   * @param params
   * @returns {Promise<void>}
   */
  async saveEorderAuthLog(params) {
    if(!params.order_id){
      return system.getResult(null, `参数错误 订单ID不能为空`);
    }
    if(!params.product_id){
      return system.getResult(null, `参数错误 产品ID不能为空`);
    }
    if(!params.user_name){
      return system.getResult(null, `参数错误 使用方不能为空`);
    }
    if(!params.actual_spend_name){
      return system.getResult(null, `参数错误 实际使用方不能为空`);
    }
    if(!params.platform_name){
      return system.getResult(null, `参数错误 平台名称不能为空`);
    }
    params.platform_id=params.platform_id?params.platform_id:'';
    params.spended_num = Number(params.spended_num || 0);
    params.spended_at = params.spended_at?params.spended_at:new Date();
    try{
      let orderBean = await this.eorderDao.model.findOne({
        where:{
          id:this.trim(params.order_id)
        }
      });
      if(!orderBean){
        return system.getResult(null, `订单【${params.order_id}】不存在`);
      }
      params.merchant_id = orderBean.merchant_id;
      await this.dao.create(params);
      return system.getResultSuccess();
    }catch (e) {
      console.log(e);
      return system.getResult(null,`系统错误`);
    }

  }

  /**
   * fn:身份验证日志列表
   * @param params
   * @returns {Promise<void>}
   */
  async pageEorderAuthLog(params){
    params.currentPage = Number(params.currentPage || 1);
    params.pageSize = Number(params.pageSize || 10);
    params.startRow = (params.currentPage - 1) * params.pageSize;
    try{
      let countRes = await this.dao.countEorderAuthLog(params);
      if(countRes.eorderauthlogCount==0){
        return system.getResult({count: 0, rows: []});
      }
      let list =await  this.dao.pageEorderAuthLog(params);
      if(!list || list.length==0){
        return system.getResult({count: 0, rows: []});
      }
      for (let item of list) {
        this.handleDate(item,['spended_at','created_at'],null,null)
        item.pass_name = item.pass == 0 ? '未通过':'已通过';
      }
      return system.getResult({count: countRes.eorderauthlogCount, rows: list});
    }catch (e) {
      console.log(e);
      return system.getResult(null, `系统错误`);
    }
  }
}

module.exports = EorderauthlogService;